/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node.testing;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.guice.ExportBinder;

public class TestingNodeModule
implements Module {
    private static final AtomicLong nextId = new AtomicLong(ThreadLocalRandom.current().nextInt(1000000));
    private final String environment;
    private final Optional<String> pool;

    public TestingNodeModule() {
        this((Optional<String>)Optional.absent());
    }

    public TestingNodeModule(Optional<String> environment) {
        this((String)environment.or((Object)("test" + nextId.getAndIncrement())));
    }

    public TestingNodeModule(String environment) {
        this(environment, (Optional<String>)Optional.absent());
    }

    public TestingNodeModule(String environment, Optional<String> pool) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)environment) ? 1 : 0) != 0, (Object)"environment is null or empty");
        this.environment = environment;
        this.pool = (Optional)Preconditions.checkNotNull(pool, (Object)"pool is null");
    }

    public TestingNodeModule(String environment, String pool) {
        this(environment, (Optional<String>)Optional.of((Object)Preconditions.checkNotNull((Object)pool, (Object)"pool is null")));
    }

    public void configure(Binder binder) {
        binder.bind(NodeInfo.class).in(Scopes.SINGLETON);
        NodeConfig nodeConfig = new NodeConfig().setEnvironment(this.environment).setNodeInternalIp(TestingNodeModule.getV4Localhost()).setNodeBindIp(TestingNodeModule.getV4Localhost());
        if (this.pool.isPresent()) {
            nodeConfig.setPool((String)this.pool.get());
        }
        binder.bind(NodeConfig.class).toInstance((Object)nodeConfig);
        ExportBinder.newExporter((Binder)binder).export(NodeInfo.class).withGeneratedName();
    }

    private static InetAddress getV4Localhost() {
        try {
            return InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"Could not create localhost address");
        }
    }
}

