/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public final class OrcDataSourceUtils {
    private OrcDataSourceUtils() {
    }

    public static Iterable<DiskRange> mergeAdjacentDiskRanges(Iterable<DiskRange> diskRanges, DataSize maxMergeDistance) {
        ArrayList ranges = Lists.newArrayList(diskRanges);
        Collections.sort(ranges, new Comparator<DiskRange>(){

            @Override
            public int compare(DiskRange o1, DiskRange o2) {
                return Long.compare(o1.getOffset(), o2.getOffset());
            }
        });
        long maxMergeDistanceBytes = maxMergeDistance.toBytes();
        ArrayList<DiskRange> result = new ArrayList<DiskRange>();
        DiskRange last = (DiskRange)ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            DiskRange current = (DiskRange)ranges.get(i);
            if (last.getEnd() + maxMergeDistanceBytes + 1L >= current.getOffset()) {
                last = last.span(current);
                continue;
            }
            result.add(last);
            last = current;
        }
        result.add(last);
        return result;
    }

    public static Slice getDiskRangeSlice(DiskRange diskRange, Map<DiskRange, byte[]> buffers) {
        for (Map.Entry<DiskRange, byte[]> bufferEntry : buffers.entrySet()) {
            DiskRange bufferRange = bufferEntry.getKey();
            byte[] buffer = bufferEntry.getValue();
            if (!bufferRange.contains(diskRange)) continue;
            int offset = Ints.checkedCast((long)(diskRange.getOffset() - bufferRange.getOffset()));
            return Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)diskRange.getLength());
        }
        throw new IllegalStateException("No matching buffer for disk range");
    }
}

