/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.LongVector;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.OrcReaderUtils;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampStreamReader
implements StreamReader {
    private static final int MILLIS_PER_SECOND = 1000;
    private final StreamDescriptor streamDescriptor;
    private final long baseTimestampInSeconds;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<LongStream> secondsStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream secondsStream;
    @Nonnull
    private StreamSource<LongStream> nanosStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream nanosStream;
    private final long[] nanosVector = new long[1024];
    private boolean rowGroupOpen;

    public TimestampStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, (DateTimeZone)Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException("Value is not null but seconds stream is not present");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException("Value is not null but nanos stream is not present");
                }
                this.secondsStream.skip(this.readOffset);
                this.nanosStream.skip(this.readOffset);
            }
        }
        LongVector longVector = OrcReaderUtils.castOrcVector(vector, LongVector.class);
        if (this.presentStream == null) {
            if (this.secondsStream == null) {
                throw new OrcCorruptionException("Value is not null but seconds stream is not present");
            }
            if (this.nanosStream == null) {
                throw new OrcCorruptionException("Value is not null but nanos stream is not present");
            }
            Arrays.fill(longVector.isNull, false);
            this.secondsStream.nextLongVector(this.nextBatchSize, longVector.vector);
            this.nanosStream.nextLongVector(this.nextBatchSize, this.nanosVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, longVector.isNull);
            if (nullValues != this.nextBatchSize) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException("Value is not null but seconds stream is not present");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException("Value is not null but nanos stream is not present");
                }
                this.secondsStream.nextLongVector(this.nextBatchSize, longVector.vector, longVector.isNull);
                this.nanosStream.nextLongVector(this.nextBatchSize, this.nanosVector, longVector.isNull);
            }
        }
        for (int i = 0; i < this.nextBatchSize; ++i) {
            longVector.vector[i] = TimestampStreamReader.decodeTimestamp(longVector.vector[i], this.nanosVector[i], this.baseTimestampInSeconds);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.secondsStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.nanosStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.secondsStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class);
        this.nanosStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    public static long decodeTimestamp(long seconds, long serializedNanos, long baseTimestampInSeconds) {
        long millis = (seconds + baseTimestampInSeconds) * 1000L;
        long nanos = TimestampStreamReader.parseNanos(serializedNanos);
        if (millis < 0L && nanos != 0L) {
            millis -= 1000L;
        }
        return millis + nanos / 1000000L;
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }
}

