/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyStringDictionaryTreeReader;
import com.facebook.hive.orc.lazy.LazyStringDirectTreeReader;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LazyStringTreeReader
extends LazyTreeReader {
    private LazyTreeReader reader;

    public LazyStringTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        switch (encodings.get(this.columnId).getKind()) {
            case DIRECT: {
                this.reader = new LazyStringDirectTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            case DICTIONARY: {
                this.reader = new LazyStringDictionaryTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)encodings.get(this.columnId).getKind()));
            }
        }
        this.reader.startStripe(streams, encodings, indexes, rowBaseInStripe);
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        this.reader.seek(rowIndexEntry, backwards);
    }

    @Override
    public Object next(Object previous) throws IOException {
        return this.reader.next(previous);
    }

    @Override
    public void skipRowsInComplexType(long numRows) throws IOException {
        this.reader.skipRowsInComplexType(numRows);
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skipRows(numNonNullValues);
    }

    @Override
    public boolean nextIsNull(long currentRow) throws IOException {
        return this.reader.nextIsNull(currentRow);
    }

    @Override
    public boolean nextIsNullInComplexType() throws IOException {
        return this.reader.nextIsNullInComplexType();
    }

    @Override
    public Object getInComplexType(Object previous, long row) throws IOException {
        return this.reader.getInComplexType(previous, row);
    }

    @Override
    public Object get(long currentRow, Object previous) throws IOException {
        return this.reader.get(currentRow, previous);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

