/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveMetastoreClientFactory;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransportException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceState;
import io.airlift.discovery.client.ServiceType;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;

public class DiscoveryLocatedHiveCluster
implements HiveCluster {
    private final ServiceSelector selector;
    private final HiveMetastoreClientFactory clientFactory;

    @Inject
    public DiscoveryLocatedHiveCluster(@ServiceType(value="hive-metastore") ServiceSelector selector, HiveMetastoreClientFactory clientFactory) {
        this.selector = (ServiceSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector is null");
        this.clientFactory = (HiveMetastoreClientFactory)Preconditions.checkNotNull((Object)clientFactory, (Object)"clientFactory is null");
    }

    @Override
    public HiveMetastoreClient createMetastoreClient() {
        ArrayList descriptors = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.selector.selectAllServices(), DiscoveryLocatedHiveCluster.runningPredicate()));
        if (descriptors.isEmpty()) {
            throw new DiscoveryException("No metastore servers available for pool: " + this.selector.getPool());
        }
        Collections.shuffle(descriptors);
        TTransportException lastException = null;
        for (ServiceDescriptor descriptor : descriptors) {
            String thrift = (String)descriptor.getProperties().get("thrift");
            if (thrift == null) continue;
            try {
                HostAndPort metastore = HostAndPort.fromString((String)thrift);
                Preconditions.checkArgument((boolean)metastore.hasPort());
                return this.clientFactory.create(metastore.getHostText(), metastore.getPort());
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (TTransportException e) {
                lastException = e;
            }
        }
        throw new DiscoveryException("Unable to connect to any metastore servers in pool: " + this.selector.getPool(), lastException);
    }

    private static Predicate<? super ServiceDescriptor> runningPredicate() {
        return new Predicate<ServiceDescriptor>(){

            public boolean apply(ServiceDescriptor input) {
                return input.getState() != ServiceState.STOPPED;
            }
        };
    }
}

