/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileSystemCache;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.hive.HdfsConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration) {
        this.hdfsConfiguration = (HdfsConfiguration)Preconditions.checkNotNull((Object)hdfsConfiguration, (Object)"hdfsConfiguration is null");
    }

    public Configuration getConfiguration(Path path) {
        URI uri = path.toUri();
        if ("file".equals(uri.getScheme()) || "maprfs".equals(uri.getScheme())) {
            return new Configuration();
        }
        String host = uri.getHost();
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (String)"path host is null: %s", (Object[])new Object[]{path});
        return this.hdfsConfiguration.getConfiguration(host);
    }

    public FileSystem getFileSystem(Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem(this.getConfiguration(path));
        fileSystem.setVerifyChecksum(this.hdfsConfiguration.verifyChecksum());
        return fileSystem;
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
    }
}

