/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveRecordSink;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitSourceProvider;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class HiveClient
implements ConnectorMetadata,
ConnectorSplitManager,
ConnectorRecordSinkProvider,
ConnectorHandleResolver {
    public static final String PRESTO_OFFLINE = "presto_offline";
    private static final String PARTITION_VALUE_WILDCARD = "";
    private static final Logger log = Logger.get(HiveClient.class);
    private final String connectorId;
    private final int maxOutstandingSplits;
    private final int maxSplitIteratorThreads;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final boolean forceLocalScheduling;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowCorruptWritesForTesting;
    private final HiveMetastore metastore;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final DateTimeZone timeZone;
    private final Executor executor;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final int maxInitialSplits;
    private final HiveStorageFormat hiveStorageFormat;
    private final boolean recursiveDfsWalkerEnabled;
    private final TypeManager typeManager;

    @Inject
    public HiveClient(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService, TypeManager typeManager) {
        this(connectorId, metastore, namenodeStats, hdfsEnvironment, directoryLister, DateTimeZone.forTimeZone((TimeZone)hiveClientConfig.getTimeZone()), (Executor)new BoundedExecutor((Executor)executorService, hiveClientConfig.getMaxGlobalSplitIteratorThreads()), hiveClientConfig.getMaxSplitSize(), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMaxSplitIteratorThreads(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getMaxInitialSplitSize(), hiveClientConfig.getMaxInitialSplits(), hiveClientConfig.isForceLocalScheduling(), hiveClientConfig.getAllowDropTable(), hiveClientConfig.getAllowRenameTable(), hiveClientConfig.getAllowCorruptWritesForTesting(), hiveClientConfig.getHiveStorageFormat(), false, typeManager);
    }

    public HiveClient(HiveConnectorId connectorId, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, DateTimeZone timeZone, Executor executor, DataSize maxSplitSize, int maxOutstandingSplits, int maxSplitIteratorThreads, int minPartitionBatchSize, int maxPartitionBatchSize, DataSize maxInitialSplitSize, int maxInitialSplits, boolean forceLocalScheduling, boolean allowDropTable, boolean allowRenameTable, boolean allowCorruptWritesForTesting, HiveStorageFormat hiveStorageFormat, boolean recursiveDfsWalkerEnabled, TypeManager typeManager) {
        this.connectorId = ((HiveConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.maxSplitSize = (DataSize)Preconditions.checkNotNull((Object)maxSplitSize, (Object)"maxSplitSize is null");
        Preconditions.checkArgument((maxOutstandingSplits > 0 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxInitialSplitSize = (DataSize)Preconditions.checkNotNull((Object)maxInitialSplitSize, (Object)"maxInitialSplitSize is null");
        this.maxInitialSplits = maxInitialSplits;
        this.forceLocalScheduling = forceLocalScheduling;
        this.allowDropTable = allowDropTable;
        this.allowRenameTable = allowRenameTable;
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = (HiveMetastore)Preconditions.checkNotNull((Object)metastore, (Object)"metastore is null");
        this.hdfsEnvironment = (HdfsEnvironment)Preconditions.checkNotNull((Object)hdfsEnvironment, (Object)"hdfsEnvironment is null");
        this.namenodeStats = (NamenodeStats)Preconditions.checkNotNull((Object)namenodeStats, (Object)"namenodeStats is null");
        this.directoryLister = (DirectoryLister)Preconditions.checkNotNull((Object)directoryLister, (Object)"directoryLister is null");
        this.timeZone = (DateTimeZone)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.hiveStorageFormat = hiveStorageFormat;
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
    }

    public HiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        try {
            this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            return new HiveTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), session);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle").getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
                throw new TableNotFoundException(tableName);
            }
            ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(this.getColumnHandles(table, false), HiveClient.columnMetadataGetter(table, this.typeManager)));
            return new ConnectorTableMetadata(tableName, (List)columns, table.getOwner());
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            try {
                for (String tableName : this.metastore.getAllTables(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName));
                }
            }
            catch (NoSuchObjectException e) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            for (HiveColumnHandle columnHandle : this.getColumnHandles(table, true)) {
                if (!columnHandle.getName().equals("__presto__sample_weight__")) continue;
                return columnHandle;
            }
            return null;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return true;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            ImmutableMap.Builder columnHandles = ImmutableMap.builder();
            for (HiveColumnHandle columnHandle : this.getColumnHandles(table, false)) {
                columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
            }
            return columnHandles.build();
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    private List<HiveColumnHandle> getColumnHandles(Table table, boolean includeSampleWeight) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int hiveColumnIndex = 0;
        for (StructField structField : HiveUtil.getTableStructFields(table)) {
            HiveType hiveType = HiveType.getHiveType(structField.getFieldObjectInspector());
            if (hiveType != null && (includeSampleWeight || !structField.getFieldName().equals("__presto__sample_weight__"))) {
                Type type = HiveClient.getType(structField.getFieldObjectInspector(), this.typeManager);
                Preconditions.checkNotNull((Object)type, (String)"Unsupported hive type: %s", (Object[])new Object[]{structField.getFieldObjectInspector().getTypeName()});
                columns.add((Object)new HiveColumnHandle(this.connectorId, structField.getFieldName(), hiveColumnIndex, hiveType, type.getTypeSignature(), hiveColumnIndex, false));
            }
            ++hiveColumnIndex;
        }
        columns.addAll(this.getPartitionKeyColumnHandles(table, hiveColumnIndex));
        return columns.build();
    }

    private List<HiveColumnHandle> getPartitionKeyColumnHandles(Table table, int startOrdinal) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List partitionKeys = table.getPartitionKeys();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            FieldSchema field = (FieldSchema)partitionKeys.get(i);
            HiveType hiveType = HiveType.getSupportedHiveType(field.getType());
            columns.add((Object)new HiveColumnHandle(this.connectorId, field.getName(), startOrdinal + i, hiveType, HiveClient.getType(field.getType()).getTypeSignature(), -1, true));
        }
        return columns.build();
    }

    public static Type getType(String hiveType) {
        switch (hiveType) {
            case "boolean": {
                return BooleanType.BOOLEAN;
            }
            case "tinyint": {
                return BigintType.BIGINT;
            }
            case "smallint": {
                return BigintType.BIGINT;
            }
            case "int": {
                return BigintType.BIGINT;
            }
            case "bigint": {
                return BigintType.BIGINT;
            }
            case "float": {
                return DoubleType.DOUBLE;
            }
            case "double": {
                return DoubleType.DOUBLE;
            }
            case "string": {
                return VarcharType.VARCHAR;
            }
            case "timestamp": {
                return TimestampType.TIMESTAMP;
            }
            case "binary": {
                return VarbinaryType.VARBINARY;
            }
        }
        throw new IllegalArgumentException("Unsupported hive type " + hiveType);
    }

    @Nullable
    public static Type getType(ObjectInspector fieldInspector, TypeManager typeManager) {
        switch (fieldInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveObjectInspector)fieldInspector).getPrimitiveCategory();
                return HiveClient.getPrimitiveType(primitiveCategory);
            }
            case MAP: {
                MapObjectInspector mapObjectInspector = Types.checkType(fieldInspector, MapObjectInspector.class, "fieldInspector");
                Type keyType = HiveClient.getType(mapObjectInspector.getMapKeyObjectInspector(), typeManager);
                Type valueType = HiveClient.getType(mapObjectInspector.getMapValueObjectInspector(), typeManager);
                if (keyType == null || valueType == null) {
                    return null;
                }
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
            }
            case LIST: {
                ListObjectInspector listObjectInspector = Types.checkType(fieldInspector, ListObjectInspector.class, "fieldInspector");
                Type elementType = HiveClient.getType(listObjectInspector.getListElementObjectInspector(), typeManager);
                if (elementType == null) {
                    return null;
                }
                return typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType.getTypeSignature()), (List)ImmutableList.of());
            }
            case STRUCT: {
                StructObjectInspector structObjectInspector = Types.checkType(fieldInspector, StructObjectInspector.class, "fieldInspector");
                ArrayList<TypeSignature> fieldTypes = new ArrayList<TypeSignature>();
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (StructField field : structObjectInspector.getAllStructFieldRefs()) {
                    fieldNames.add(field.getFieldName());
                    Type fieldType = HiveClient.getType(field.getFieldObjectInspector(), typeManager);
                    if (fieldType == null) {
                        return null;
                    }
                    fieldTypes.add(fieldType.getTypeSignature());
                }
                return typeManager.getParameterizedType("row", fieldTypes, fieldNames);
            }
        }
        throw new IllegalArgumentException("Unsupported hive type " + fieldInspector.getTypeName());
    }

    private static Type getPrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return BigintType.BIGINT;
            }
            case SHORT: {
                return BigintType.BIGINT;
            }
            case INT: {
                return BigintType.BIGINT;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return DoubleType.DOUBLE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
        }
        return null;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (HiveViewNotSupportedException e) {
            }
            catch (TableNotFoundException e) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, HiveColumnHandle.class, "columnHandle").getColumnMetadata(this.typeManager);
    }

    public ConnectorTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Renaming tables is disabled in this Hive catalog");
        }
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void dropTable(ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Hive catalog");
        }
        try {
            Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
            if (!handle.getSession().getUser().equals(table.getOwner())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, String.format("Unable to drop table '%s': owner of the table is different from session user", table));
            }
            this.metastore.dropTable(handle.getSchemaName(), handle.getTableName());
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((this.allowCorruptWritesForTesting || this.timeZone.equals((Object)DateTimeZone.getDefault()) ? 1 : 0) != 0, (String)"To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", (Object[])new Object[]{this.timeZone.getID()});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        HiveStorageFormat hiveStorageFormat = HiveSessionProperties.getHiveStorageFormat(session, this.hiveStorageFormat);
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!HiveRecordSink.isTypeSupported(column.getType())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot create table with unsupported type: %s", column.getType().getDisplayName()));
            }
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getType());
        }
        if (tableMetadata.isSampled()) {
            columnNames.add((Object)"__presto__sample_weight__");
            columnTypes.add((Object)BigintType.BIGINT);
        }
        SchemaTableName table = tableMetadata.getTable();
        String schemaName = table.getSchemaName();
        String tableName = table.getTableName();
        String location = this.getDatabase(schemaName).getLocationUri();
        if (Strings.isNullOrEmpty((String)location)) {
            throw new RuntimeException(String.format("Database '%s' location is not set", schemaName));
        }
        Path databasePath = new Path(location);
        if (!this.pathExists(databasePath)) {
            throw new RuntimeException(String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
        }
        if (!this.isDirectory(databasePath)) {
            throw new RuntimeException(String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
        }
        Path targetPath = new Path(databasePath, tableName);
        if (this.pathExists(targetPath)) {
            throw new RuntimeException(String.format("Target directory for table '%s' already exists: %s", table, targetPath));
        }
        if (!this.useTemporaryDirectory(targetPath)) {
            return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), targetPath.toString(), session, hiveStorageFormat);
        }
        String temporaryPrefix = "/tmp/presto-" + StandardSystemProperty.USER_NAME.value();
        Path temporaryRoot = new Path(targetPath, temporaryPrefix);
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        this.createDirectories(temporaryPath);
        return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), temporaryPath.toString(), session, hiveStorageFormat);
    }

    public void commitCreateTable(ConnectorOutputTableHandle tableHandle, Collection<String> fragments) {
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        Path targetPath = new Path(handle.getTargetPath());
        if (handle.hasTemporaryPath()) {
            if (this.pathExists(targetPath)) {
                SchemaTableName table = new SchemaTableName(handle.getSchemaName(), handle.getTableName());
                throw new RuntimeException(String.format("Unable to commit creation of table '%s': target directory already exists: %s", table, targetPath));
            }
            this.rename(new Path(handle.getTemporaryPath()), targetPath);
        }
        ImmutableList types = FluentIterable.from(handle.getColumnTypes()).transform(HiveType::toHiveType).transform(HiveType::getHiveTypeName).toList();
        boolean sampled = false;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int i = 0; i < handle.getColumnNames().size(); ++i) {
            String name = handle.getColumnNames().get(i);
            String type = (String)types.get(i);
            if (name.equals("__presto__sample_weight__")) {
                columns.add((Object)new FieldSchema(name, type, "Presto sample weight column"));
                sampled = true;
                continue;
            }
            columns.add((Object)new FieldSchema(name, type, null));
        }
        HiveStorageFormat hiveStorageFormat = handle.getHiveStorageFormat();
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(handle.getTableName());
        serdeInfo.setSerializationLib(hiveStorageFormat.getSerDe());
        serdeInfo.setParameters((Map)ImmutableMap.of());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(targetPath.toString());
        sd.setCols((List)columns.build());
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(hiveStorageFormat.getInputFormat());
        sd.setOutputFormat(hiveStorageFormat.getOutputFormat());
        sd.setParameters((Map)ImmutableMap.of());
        Table table = new Table();
        table.setDbName(handle.getSchemaName());
        table.setTableName(handle.getTableName());
        table.setOwner(handle.getTableOwner());
        table.setTableType(TableType.MANAGED_TABLE.toString());
        String tableComment = "Created by Presto";
        if (sampled) {
            tableComment = "Sampled table created by Presto. Only query this table from Hive if you understand how Presto implements sampling.";
        }
        table.setParameters((Map)ImmutableMap.of((Object)"comment", (Object)tableComment));
        table.setPartitionKeys((List)ImmutableList.of());
        table.setSd(sd);
        this.metastore.createTable(table);
    }

    public RecordSink getRecordSink(ConnectorOutputTableHandle tableHandle) {
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        Path target = new Path(handle.getTemporaryPath(), UUID.randomUUID().toString());
        JobConf conf = new JobConf(this.hdfsEnvironment.getConfiguration(target));
        return new HiveRecordSink(handle, target, conf);
    }

    public RecordSink getRecordSink(ConnectorInsertTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    private Database getDatabase(String database) {
        try {
            return this.metastore.getDatabase(database);
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(database);
        }
    }

    private boolean useTemporaryDirectory(Path path) {
        try {
            return !(this.hdfsEnvironment.getFileSystem(path) instanceof PrestoS3FileSystem);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private boolean pathExists(Path path) {
        try {
            return this.hdfsEnvironment.getFileSystem(path).exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private boolean isDirectory(Path path) {
        try {
            return this.hdfsEnvironment.getFileSystem(path).isDirectory(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private void createDirectories(Path path) {
        try {
            if (!this.hdfsEnvironment.getFileSystem(path).mkdirs(path)) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directory: " + path, e);
        }
    }

    private void rename(Path source, Path target) {
        try {
            if (!this.hdfsEnvironment.getFileSystem(source).rename(source, target)) {
                throw new IOException("rename returned false");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to rename %s to %s", source, target), e);
        }
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            try {
                this.dropView(session, viewName);
            }
            catch (ViewNotFoundException ignored) {
                // empty catch block
            }
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)"comment", (Object)"Presto View").put((Object)"presto_view", (Object)"true").build();
        FieldSchema dummyColumn = new FieldSchema("dummy", "string", null);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols((List)ImmutableList.of((Object)dummyColumn));
        sd.setSerdeInfo(new SerDeInfo());
        Table table = new Table();
        table.setDbName(viewName.getSchemaName());
        table.setTableName(viewName.getTableName());
        table.setOwner(session.getUser());
        table.setTableType(TableType.VIRTUAL_VIEW.name());
        table.setParameters((Map)properties);
        table.setViewOriginalText(HiveUtil.encodeViewData(viewData));
        table.setViewExpandedText("/* Presto View */");
        table.setSd(sd);
        try {
            this.metastore.createTable(table);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        String view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        if (view == null) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            try {
                for (String tableName : this.metastore.getAllViews(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName));
                }
            }
            catch (NoSuchObjectException e) {
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, String> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, prefix.getSchemaName());
        for (SchemaTableName schemaTableName : tableNames) {
            try {
                Table table = this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
                if (!HiveUtil.isPrestoView(table)) continue;
                views.put((Object)schemaTableName, (Object)HiveUtil.decodeViewData(table.getViewOriginalText()));
            }
            catch (NoSuchObjectException ignored) {}
        }
        return views.build();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkArgument((this.allowCorruptWritesForTesting || this.timeZone.equals((Object)DateTimeZone.getDefault()) ? 1 : 0) != 0, (String)"To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", (Object[])new Object[]{this.timeZone.getID()});
        throw new UnsupportedOperationException();
    }

    public void commitInsert(ConnectorInsertTableHandle insertHandle, Collection<String> fragments) {
        throw new UnsupportedOperationException();
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull(effectivePredicate, (Object)"effectivePredicate is null");
        if (effectivePredicate.isNone()) {
            return new ConnectorPartitionResult((List)ImmutableList.of(), TupleDomain.none());
        }
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        Table table = this.getTable(tableName);
        Optional<HiveBucketing.HiveBucket> bucket = HiveBucketing.getHiveBucket(table, effectivePredicate.extractFixedValues());
        TupleDomain<HiveColumnHandle> compactEffectivePredicate = HiveClient.toCompactTupleDomain(effectivePredicate);
        if (table.getPartitionKeys().isEmpty()) {
            return new ConnectorPartitionResult((List)ImmutableList.of((Object)new HivePartition(tableName, compactEffectivePredicate, bucket)), effectivePredicate);
        }
        List<HiveColumnHandle> partitionColumns = this.getPartitionKeyColumnHandles(table, 0);
        List<String> partitionNames = this.getFilteredPartitionNames(tableName, partitionColumns, effectivePredicate);
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (String partitionName : partitionNames) {
            Optional<Map<ConnectorColumnHandle, SerializableNativeValue>> values = this.parseValuesAndFilterPartition(partitionName, partitionColumns, effectivePredicate);
            if (!values.isPresent()) continue;
            partitions.add((Object)new HivePartition(tableName, compactEffectivePredicate, partitionName, values.get(), bucket));
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)effectivePredicate.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
        return new ConnectorPartitionResult((List)partitions.build(), remainingTupleDomain);
    }

    private Optional<Map<ConnectorColumnHandle, SerializableNativeValue>> parseValuesAndFilterPartition(String partitionName, List<HiveColumnHandle> partitionColumns, TupleDomain<ConnectorColumnHandle> predicate) {
        List<String> partitionValues = HiveClient.extractPartitionKeyValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            SerializableNativeValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), column.getHiveType(), this.timeZone);
            Domain allowedDomain = (Domain)predicate.getDomains().get(column);
            if (allowedDomain != null && !allowedDomain.includesValue(parsedValue.getValue())) {
                return Optional.empty();
            }
            builder.put((Object)column, (Object)parsedValue);
        }
        return Optional.of(builder.build());
    }

    private Table getTable(SchemaTableName tableName) {
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            String protectMode = (String)table.getParameters().get(ProtectMode.PARAMETER_NAME);
            if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                throw new TableOfflineException(tableName);
            }
            String prestoOffline = (String)table.getParameters().get(PRESTO_OFFLINE);
            if (!Strings.isNullOrEmpty((String)prestoOffline)) {
                throw new TableOfflineException(tableName, String.format("Table '%s' is offline for Presto: %s", tableName, prestoOffline));
            }
            return table;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    private List<String> getFilteredPartitionNames(SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)effectivePredicate.getDomains().get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Comparable value = domain.getNullableSingleValue();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (value instanceof Slice) {
                    filter.add(((Slice)value).toStringUtf8());
                    continue;
                }
                Preconditions.checkArgument((value instanceof Boolean || value instanceof Double || value instanceof Long ? 1 : 0) != 0, (Object)"Only Boolean, Slice (UTF8 String), Double and Long partition keys are supported");
                filter.add(value.toString());
                continue;
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        try {
            return this.metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filter);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    private static List<String> extractPartitionKeyValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> connectorPartitions) {
        Iterable<HivePartitionMetadata> hivePartitions;
        Table table;
        HiveTableHandle hiveTableHandle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        Preconditions.checkNotNull(connectorPartitions, (Object)"connectorPartitions is null");
        List partitions = Lists.transform(connectorPartitions, partition -> Types.checkType(partition, HivePartition.class, "partition"));
        HivePartition partition2 = (HivePartition)Iterables.getFirst((Iterable)partitions, null);
        if (partition2 == null) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        SchemaTableName tableName = partition2.getTableName();
        Optional<HiveBucketing.HiveBucket> bucket = partition2.getBucket();
        partitions = Ordering.natural().onResultOf(ConnectorPartition::getPartitionId).reverse().sortedCopy((Iterable)partitions);
        try {
            table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            hivePartitions = this.getPartitionMetadata(table, tableName, partitions);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
        return new HiveSplitSourceProvider(this.connectorId, table, hivePartitions, bucket, this.maxSplitSize, this.maxOutstandingSplits, this.maxSplitIteratorThreads, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, this.maxPartitionBatchSize, hiveTableHandle.getSession(), this.maxInitialSplitSize, this.maxInitialSplits, this.forceLocalScheduling, this.recursiveDfsWalkerEnabled).get();
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(final Table table, final SchemaTableName tableName, List<HivePartition> partitions) throws NoSuchObjectException {
        HivePartition firstPartition;
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (partitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(partitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, UnpartitionedPartition.UNPARTITIONED_PARTITION));
        }
        Iterable<List<HivePartition>> partitionNameBatches = HiveClient.partitionExponentially(partitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, (Function)new Function<List<HivePartition>, List<HivePartitionMetadata>>(){

            public List<HivePartitionMetadata> apply(List<HivePartition> partitionBatch) {
                Throwable exception = null;
                for (int attempt = 0; attempt < 10; ++attempt) {
                    try {
                        Map<String, Partition> partitions = HiveClient.this.metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform(partitionBatch, ConnectorPartition::getPartitionId));
                        Preconditions.checkState((partitionBatch.size() == partitions.size() ? 1 : 0) != 0, (String)"expected %s partitions but found %s", (Object[])new Object[]{partitionBatch.size(), partitions.size()});
                        ImmutableList.Builder results = ImmutableList.builder();
                        for (HivePartition hivePartition : partitionBatch) {
                            Partition partition = partitions.get(hivePartition.getPartitionId());
                            Preconditions.checkState((partition != null ? 1 : 0) != 0, (String)"Partition %s was not loaded", (Object[])new Object[]{hivePartition.getPartitionId()});
                            String protectMode = (String)partition.getParameters().get(ProtectMode.PARAMETER_NAME);
                            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues());
                            if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                                throw new PartitionOfflineException(tableName, partName);
                            }
                            String prestoOffline = (String)partition.getParameters().get(HiveClient.PRESTO_OFFLINE);
                            if (!Strings.isNullOrEmpty((String)prestoOffline)) {
                                throw new PartitionOfflineException(tableName, partName, String.format("Partition '%s' is offline for Presto: %s", partName, prestoOffline));
                            }
                            List tableColumns = table.getSd().getCols();
                            List partitionColumns = partition.getSd().getCols();
                            for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
                                String partitionType;
                                String tableType = ((FieldSchema)tableColumns.get(i)).getType();
                                if (tableType.equals(partitionType = ((FieldSchema)partitionColumns.get(i)).getType())) continue;
                                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Table '%s' partition '%s' column '%s' type '%s' does not match table column type '%s'", tableName, partName, ((FieldSchema)partitionColumns.get(i)).getName(), partitionType, tableType));
                            }
                            results.add((Object)new HivePartitionMetadata(hivePartition, partition));
                        }
                        return results.build();
                    }
                    catch (PrestoException | IllegalArgumentException | IllegalStateException | NullPointerException | NoSuchObjectException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (RuntimeException | MetaException e) {
                        exception = e;
                        log.debug("getPartitions attempt %s failed, will retry. Exception: %s", new Object[]{attempt, e.getMessage()});
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate((Throwable)e2);
                        }
                    }
                }
                assert (exception != null);
                throw Throwables.propagate(exception);
            }
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof HiveTableHandle && ((HiveTableHandle)tableHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof HiveColumnHandle && ((HiveColumnHandle)columnHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof HiveSplit && ((HiveSplit)split).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorOutputTableHandle handle) {
        return handle instanceof HiveOutputTableHandle && ((HiveOutputTableHandle)handle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return HiveTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return HiveColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return HiveSplit.class;
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        return HiveOutputTableHandle.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldSchema field : Iterables.concat((Iterable)table.getSd().getCols(), (Iterable)table.getPartitionKeys())) {
            if (field.getComment() == null) continue;
            builder.put((Object)field.getName(), (Object)field.getComment());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveClient.lambda$columnMetadataGetter$5(typeManager, (Map)columnComment, arg_0);
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new AbstractIterator<List<T>>(){
                    private int currentSize;
                    private final Iterator<T> iterator;
                    {
                        this.currentSize = minBatchSize;
                        this.iterator = values.iterator();
                    }

                    protected List<T> computeNext() {
                        if (!this.iterator.hasNext()) {
                            return (List)this.endOfData();
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                            builder.add(this.iterator.next());
                        }
                        this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                        return builder.build();
                    }
                };
            }
        };
    }

    public static TupleDomain<HiveColumnHandle> toCompactTupleDomain(TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : effectivePredicate.getDomains().entrySet()) {
            HiveColumnHandle hiveColumnHandle = Types.checkType(entry.getKey(), HiveColumnHandle.class, "ColumnHandle");
            SortedRangeSet ranges = ((Domain)entry.getValue()).getRanges();
            if (!ranges.isNone()) {
                ranges = SortedRangeSet.of((Range)((Domain)entry.getValue()).getRanges().getSpan(), (Range[])new Range[0]);
            }
            builder.put((Object)hiveColumnHandle, (Object)new Domain(ranges, ((Domain)entry.getValue()).isNullAllowed()));
        }
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$5(TypeManager typeManager, Map map, HiveColumnHandle input) {
        return new ColumnMetadata(input.getName(), typeManager.getType(input.getTypeSignature()), input.getOrdinalPosition(), input.isPartitionKey(), (String)map.get(input.getName()), false);
    }
}

