/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TSocket;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransport;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransportException;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class HiveMetastoreClientFactory {
    private final HostAndPort socksProxy;
    private final int timeoutMillis;

    public HiveMetastoreClientFactory(@Nullable HostAndPort socksProxy, Duration timeout) {
        this.socksProxy = socksProxy;
        this.timeoutMillis = Ints.checkedCast((long)timeout.toMillis());
    }

    @Inject
    public HiveMetastoreClientFactory(HiveClientConfig config) {
        this(config.getMetastoreSocksProxy(), config.getMetastoreTimeout());
    }

    public HiveMetastoreClient create(String host, int port) throws TTransportException {
        TTransportWrapper transport;
        if (this.socksProxy == null) {
            transport = new TTransportWrapper((TTransport)new TSocket(host, port, this.timeoutMillis), host);
            transport.open();
        } else {
            Socket socks = HiveMetastoreClientFactory.createSocksSocket(this.socksProxy);
            try {
                socks.connect(InetSocketAddress.createUnresolved(host, port), this.timeoutMillis);
                socks.setSoTimeout(this.timeoutMillis);
            }
            catch (IOException e) {
                throw HiveMetastoreClientFactory.rewriteException(new TTransportException((Throwable)e), host);
            }
            try {
                transport = new TTransportWrapper((TTransport)new TSocket(socks), host);
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, host);
            }
        }
        return new HiveMetastoreClient(transport);
    }

    private static Socket createSocksSocket(HostAndPort proxy) {
        InetSocketAddress address = InetSocketAddress.createUnresolved(proxy.getHostText(), proxy.getPort());
        return new Socket(new Proxy(Proxy.Type.SOCKS, address));
    }

    private static TTransportException rewriteException(TTransportException e, String host) {
        return new TTransportException(e.getType(), String.format("%s: %s", host, e.getMessage()), e.getCause());
    }

    private static class TTransportWrapper
    extends TTransport {
        private final TTransport transport;
        private final String host;

        TTransportWrapper(TTransport transport, String host) {
            this.transport = transport;
            this.host = host;
        }

        public boolean isOpen() {
            return this.transport.isOpen();
        }

        public boolean peek() {
            return this.transport.peek();
        }

        public byte[] getBuffer() {
            return this.transport.getBuffer();
        }

        public int getBufferPosition() {
            return this.transport.getBufferPosition();
        }

        public int getBytesRemainingInBuffer() {
            return this.transport.getBytesRemainingInBuffer();
        }

        public void consumeBuffer(int len) {
            this.transport.consumeBuffer(len);
        }

        public void close() {
            this.transport.close();
        }

        public void open() throws TTransportException {
            try {
                this.transport.open();
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }

        public int readAll(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.readAll(bytes, off, len);
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }

        public int read(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.read(bytes, off, len);
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }

        public void write(byte[] bytes) throws TTransportException {
            try {
                this.transport.write(bytes);
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }

        public void write(byte[] bytes, int off, int len) throws TTransportException {
            try {
                this.transport.write(bytes, off, len);
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }

        public void flush() throws TTransportException {
            try {
                this.transport.flush();
            }
            catch (TTransportException e) {
                throw HiveMetastoreClientFactory.rewriteException(e, this.host);
            }
        }
    }
}

