/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;

public final class NumberParser {
    private NumberParser() {
    }

    public static long parseLong(byte[] bytes, int start, int length) {
        int sign;
        int limit = start + length;
        int n = sign = bytes[start] == 45 ? -1 : 1;
        if (sign == -1 || bytes[start] == 43) {
            ++start;
        }
        long value = bytes[start] - 48;
        ++start;
        while (start < limit) {
            value = value * 10L + (long)(bytes[start] - 48);
            ++start;
        }
        return value * (long)sign;
    }

    public static double parseDouble(byte[] bytes, int start, int length) {
        char[] chars = new char[length];
        for (int pos = 0; pos < length; ++pos) {
            chars[pos] = (char)bytes[start + pos];
        }
        String string = new String(chars);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
        }
    }
}

