/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.shaded.com.google.common.io.Closeables;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import parquet.column.Dictionary;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

class ParquetHiveRecordCursor
extends HiveRecordCursor {
    private final ParquetRecordReader<Void> recordReader;
    private final String[] names;
    private final com.facebook.presto.spi.type.Type[] types;
    private final boolean[] isPartitionColumn;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final boolean[] nulls;
    private final boolean[] nullsRowDefault;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public ParquetHiveRecordCursor(Configuration configuration, Path path, long start, long length, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, TypeManager typeManager) {
        Preconditions.checkNotNull((Object)configuration, (Object)"jobConf is null");
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        this.recordReader = this.createParquetRecordReader(configuration, path, start, length, columns);
        this.totalBytes = length;
        int size = columns.size();
        this.names = new String[size];
        this.types = new com.facebook.presto.spi.type.Type[size];
        this.isPartitionColumn = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.nulls = new boolean[size];
        this.nullsRowDefault = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            this.names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.isPartitionColumn[i] = column.isPartitionKey();
            this.nullsRowDefault[i] = !column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
            String name = this.names[columnIndex];
            com.facebook.presto.spi.type.Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nullsRowDefault[columnIndex] = true;
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException ignored) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public com.facebook.presto.spi.type.Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            System.arraycopy(this.nullsRowDefault, 0, this.nulls, 0, this.isPartitionColumn.length);
            if (this.closed || !this.recordReader.nextKeyValue()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        return this.booleans[fieldId];
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        return this.longs[fieldId];
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        return this.doubles[fieldId];
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        return this.slices[fieldId];
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        return this.nulls[fieldId];
    }

    private void validateType(int fieldId, Class<?> javaType) {
        if (this.types[fieldId].getJavaType() != javaType) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", javaType.getName(), this.types[fieldId].getJavaType().getName(), fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ParquetRecordReader<Void> createParquetRecordReader(Configuration configuration, Path path, long start, long length, List<HiveColumnHandle> columns) {
        try {
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
            List blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            PrestoReadSupport readSupport = new PrestoReadSupport(columns, parquetMetadata.getFileMetaData().getSchema());
            ReadSupport.ReadContext readContext = readSupport.init(configuration, fileMetaData.getKeyValueMetaData(), fileMetaData.getSchema());
            ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
            long splitStart = start;
            long splitLength = length;
            for (BlockMetaData block : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
                splitGroup.add(block);
            }
            ParquetInputSplit split = new ParquetInputSplit(path, splitStart, splitLength, null, splitGroup, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
            TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)configuration, (TaskAttemptID)new TaskAttemptID());
            PrestoParquetRecordReader realReader = new PrestoParquetRecordReader(readSupport);
            realReader.initialize((InputSplit)split, taskContext);
            return realReader;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static JsonConverter createJsonConverter(String columnName, String fieldName, Type type) {
        if (type.isPrimitive()) {
            return new ParquetPrimitiveJsonConverter(fieldName);
        }
        if (type.getOriginalType() == OriginalType.LIST) {
            return new ParquetListJsonConverter(columnName, fieldName, type.asGroupType());
        }
        if (type.getOriginalType() == OriginalType.MAP) {
            return new ParquetMapJsonConverter(columnName, fieldName, type.asGroupType());
        }
        if (type.getOriginalType() == null) {
            return new ParquetStructJsonConverter(columnName, fieldName, type.asGroupType());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static void writeFieldNameIfSet(JsonGenerator generator, String fieldName) throws IOException {
        if (fieldName != null) {
            generator.writeFieldName(fieldName);
        }
    }

    private static class ParquetMapKeyJsonConverter
    extends PrimitiveConverter
    implements JsonConverter {
        private JsonGenerator generator;
        private boolean wroteValue;

        private ParquetMapKeyJsonConverter() {
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.generator = generator;
            this.wroteValue = false;
        }

        @Override
        public void afterValue() {
            Preconditions.checkState((boolean)this.wroteValue, (Object)"Null map keys are not allowed");
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            try {
                this.generator.writeFieldName(String.valueOf(value));
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addDouble(double value) {
            try {
                this.generator.writeFieldName(String.valueOf(value));
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addLong(long value) {
            try {
                this.generator.writeFieldName(String.valueOf(value));
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addBinary(Binary value) {
            try {
                this.generator.writeFieldName(value.toStringUsingUTF8());
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addFloat(float value) {
            try {
                this.generator.writeFieldName(String.valueOf(value));
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addInt(int value) {
            try {
                this.generator.writeFieldName(String.valueOf(value));
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class ParquetPrimitiveJsonConverter
    extends PrimitiveConverter
    implements JsonConverter {
        private final String fieldName;
        private JsonGenerator generator;
        private boolean wroteValue;

        public ParquetPrimitiveJsonConverter(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.generator = generator;
            this.wroteValue = false;
        }

        @Override
        public void afterValue() {
            if (this.wroteValue) {
                return;
            }
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeNull();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeBoolean(value);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addDouble(double value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeNumber(value);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addLong(long value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeNumber(value);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addBinary(Binary value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                byte[] bytes = value.getBytes();
                this.generator.writeUTF8String(value.getBytes(), 0, bytes.length);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addFloat(float value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeNumber(value);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addInt(int value) {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeNumber(value);
                this.wroteValue = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class ParquetMapEntryJsonConverter
    extends GroupConverter
    implements JsonConverter {
        private final JsonConverter keyConverter;
        private final JsonConverter valueConverter;

        public ParquetMapEntryJsonConverter(String columnName, GroupType entryType) {
            GroupType entryGroupType;
            if (entryType.getOriginalType() != null) {
                Preconditions.checkArgument((entryType.getOriginalType() == OriginalType.MAP_KEY_VALUE ? 1 : 0) != 0, (String)"Expected MAP column '%s' field to be type %s, but is %s", (Object[])new Object[]{columnName, OriginalType.MAP_KEY_VALUE, entryType});
            }
            Preconditions.checkArgument(((entryGroupType = entryType.asGroupType()).getFieldCount() == 2 ? 1 : 0) != 0, (String)"Expected MAP column '%s' entry to have two fields, but has %s fields", (Object[])new Object[]{columnName, entryGroupType.getFieldCount()});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(0).equals("key"), (String)"Expected MAP column '%s' entry field 0 to be named 'key', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(0)});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(1).equals("value"), (String)"Expected MAP column '%s' entry field 1 to be named 'value', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(1)});
            Preconditions.checkArgument((boolean)entryGroupType.getType(0).isPrimitive(), (String)"Expected MAP column '%s' entry field 0 to be primitive, but is named %s", (Object[])new Object[]{columnName, entryGroupType.getType(0)});
            this.keyConverter = new ParquetMapKeyJsonConverter();
            this.valueConverter = ParquetHiveRecordCursor.createJsonConverter(columnName + ".value", null, (Type)entryGroupType.getFields().get(1));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.keyConverter;
            }
            if (fieldIndex == 1) {
                return (Converter)this.valueConverter;
            }
            throw new IllegalArgumentException("Map entry field must be 0 or 1 not " + fieldIndex);
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.keyConverter.beforeValue(generator);
            this.valueConverter.beforeValue(generator);
        }

        public void start() {
        }

        public void end() {
        }

        @Override
        public void afterValue() {
            this.keyConverter.afterValue();
            this.valueConverter.afterValue();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.keyConverter);
            Closeables.closeQuietly((Closeable)this.valueConverter);
        }
    }

    private static class ParquetMapJsonConverter
    extends GroupedJsonConverter {
        private final ParquetMapEntryJsonConverter entryConverter;
        private final String fieldName;
        private JsonGenerator generator;

        public ParquetMapJsonConverter(String columnName, String fieldName, GroupType mapType) {
            this.fieldName = fieldName;
            Preconditions.checkArgument((mapType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected MAP column '%s' to only have one field, but has %s fields", (Object[])new Object[]{mapType.getName(), mapType.getFieldCount()});
            Type entryType = (Type)mapType.getFields().get(0);
            if (mapType.getOriginalType() != OriginalType.MAP_KEY_VALUE) {
                Preconditions.checkArgument((entryType.getOriginalType() == OriginalType.MAP_KEY_VALUE ? 1 : 0) != 0, (String)"Expected MAP column '%s' field to be type %s, but is %s", (Object[])new Object[]{mapType.getName(), OriginalType.MAP_KEY_VALUE, entryType});
            }
            this.entryConverter = new ParquetMapEntryJsonConverter(columnName + ".entry", entryType.asGroupType());
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.generator = generator;
            this.entryConverter.beforeValue(generator);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.entryConverter;
            }
            throw new IllegalArgumentException("Map field must be 0 not " + fieldIndex);
        }

        public void start() {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeStartObject();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void end() {
            try {
                this.generator.writeEndObject();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void afterValue() {
            this.entryConverter.afterValue();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.entryConverter);
        }
    }

    private static class ParquetListEntryJsonConverter
    extends GroupConverter
    implements JsonConverter {
        private final JsonConverter elementConverter;

        public ParquetListEntryJsonConverter(String columnName, GroupType elementType) {
            Preconditions.checkArgument((elementType.getOriginalType() == null ? 1 : 0) != 0, (String)"Expected LIST column '%s' field to be type STRUCT, but is %s", (Object[])new Object[]{columnName, elementType});
            Preconditions.checkArgument((elementType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' element to have one field, but has %s fields", (Object[])new Object[]{columnName, elementType.getFieldCount()});
            Preconditions.checkArgument((boolean)elementType.getFieldName(0).equals("array_element"), (String)"Expected LIST column '%s' entry field 0 to be named 'array_element', but is named %s", (Object[])new Object[]{columnName, elementType.getFieldName(0)});
            this.elementConverter = ParquetHiveRecordCursor.createJsonConverter(columnName + ".element", null, elementType.getType(0));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST entry field must be 0 or 1 not " + fieldIndex);
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.elementConverter.beforeValue(generator);
        }

        public void start() {
        }

        public void end() {
        }

        @Override
        public void afterValue() {
            this.elementConverter.afterValue();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.elementConverter);
        }
    }

    private static class ParquetListJsonConverter
    extends GroupedJsonConverter {
        private final JsonConverter elementConverter;
        private final String fieldName;
        private JsonGenerator generator;

        public ParquetListJsonConverter(String columnName, String fieldName, GroupType listType) {
            this.fieldName = fieldName;
            Preconditions.checkArgument((listType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' to only have one field, but has %s fields", (Object[])new Object[]{columnName, listType.getFieldCount()});
            this.elementConverter = new ParquetListEntryJsonConverter(fieldName, listType.getType(0).asGroupType());
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.generator = generator;
            this.elementConverter.beforeValue(generator);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST field must be 0 not " + fieldIndex);
        }

        public void start() {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeStartArray();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void end() {
            try {
                this.generator.writeEndArray();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void afterValue() {
            this.elementConverter.afterValue();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.elementConverter);
        }
    }

    private static class ParquetStructJsonConverter
    extends GroupedJsonConverter {
        private final String fieldName;
        private final List<JsonConverter> converters;
        private JsonGenerator generator;

        public ParquetStructJsonConverter(String columnName, String fieldName, GroupType entryType) {
            this.fieldName = fieldName;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (Type fieldType : entryType.getFields()) {
                converters.add((Object)ParquetHiveRecordCursor.createJsonConverter(columnName + "." + fieldType.getName(), null, fieldType));
            }
            this.converters = converters.build();
        }

        public Converter getConverter(int fieldIndex) {
            return (Converter)this.converters.get(fieldIndex);
        }

        @Override
        public void beforeValue(JsonGenerator generator) {
            this.generator = generator;
            for (JsonConverter converter : this.converters) {
                converter.beforeValue(generator);
            }
        }

        public void start() {
            try {
                ParquetHiveRecordCursor.writeFieldNameIfSet(this.generator, this.fieldName);
                this.generator.writeStartArray();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void end() {
            try {
                this.generator.writeEndArray();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void afterValue() {
            for (JsonConverter converter : this.converters) {
                converter.afterValue();
            }
        }

        @Override
        public void close() throws IOException {
            for (JsonConverter converter : this.converters) {
                Closeables.closeQuietly((Closeable)converter);
            }
        }
    }

    private static abstract class GroupedJsonConverter
    extends GroupConverter
    implements JsonConverter {
        private GroupedJsonConverter() {
        }
    }

    private static interface JsonConverter
    extends Closeable {
        public void beforeValue(JsonGenerator var1);

        public void afterValue();
    }

    public class ParquetJsonColumnConverter
    extends GroupConverter
    implements Closeable {
        private final DynamicSliceOutput out = new DynamicSliceOutput(1024);
        private final GroupedJsonConverter jsonConverter;
        private final int fieldIndex;
        private JsonGenerator generator;

        public ParquetJsonColumnConverter(GroupedJsonConverter jsonConverter, int fieldIndex) {
            this.jsonConverter = jsonConverter;
            this.fieldIndex = fieldIndex;
        }

        public Converter getConverter(int fieldIndex) {
            return this.jsonConverter.getConverter(fieldIndex);
        }

        public void start() {
            try {
                this.out.reset();
                this.generator = new JsonFactory().createGenerator((OutputStream)this.out);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.jsonConverter.beforeValue(this.generator);
            this.jsonConverter.start();
        }

        public void end() {
            this.jsonConverter.end();
            this.jsonConverter.afterValue();
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            try {
                this.generator.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = this.out.copySlice();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.jsonConverter);
        }
    }

    private class ParquetPrimitiveColumnConverter
    extends PrimitiveConverter {
        private final int fieldIndex;

        private ParquetPrimitiveColumnConverter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).booleans[this.fieldIndex] = value;
        }

        public void addDouble(double value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addLong(long value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }

        public void addBinary(Binary value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = Slices.wrappedBuffer((byte[])value.getBytes());
        }

        public void addFloat(float value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addInt(int value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }
    }

    public static class ParquetGroupConverter
    extends GroupConverter {
        private final List<Converter> converters;

        public ParquetGroupConverter(List<Converter> converters) {
            this.converters = converters;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters.get(fieldIndex);
        }

        public void start() {
        }

        public void end() {
        }
    }

    private static class ParquetRecordConverter
    extends RecordMaterializer<Void> {
        private final ParquetGroupConverter groupConverter;

        public ParquetRecordConverter(List<Converter> converters) {
            this.groupConverter = new ParquetGroupConverter(converters);
        }

        public Void getCurrentRecord() {
            return null;
        }

        public GroupConverter getRootConverter() {
            return this.groupConverter;
        }
    }

    public class PrestoReadSupport
    extends ReadSupport<Void>
    implements Closeable {
        private final List<HiveColumnHandle> columns;
        private final List<Converter> converters;
        private final List<Closeable> converterCloseables;

        public PrestoReadSupport(List<HiveColumnHandle> columns, MessageType messageType) {
            this.columns = columns;
            ImmutableList.Builder converters = ImmutableList.builder();
            ImmutableList.Builder closeableBuilder = ImmutableList.builder();
            block5: for (int i = 0; i < columns.size(); ++i) {
                HiveColumnHandle column = columns.get(i);
                if (column.isPartitionKey() || column.getHiveColumnIndex() >= messageType.getFieldCount()) continue;
                Type parquetType = (Type)messageType.getFields().get(column.getHiveColumnIndex());
                if (parquetType.isPrimitive()) {
                    converters.add((Object)new ParquetPrimitiveColumnConverter(i));
                    continue;
                }
                GroupType groupType = parquetType.asGroupType();
                switch (groupType.getOriginalType()) {
                    case LIST: {
                        ParquetJsonColumnConverter listConverter = new ParquetJsonColumnConverter(new ParquetListJsonConverter(groupType.getName(), null, groupType), i);
                        converters.add((Object)listConverter);
                        closeableBuilder.add((Object)listConverter);
                        continue block5;
                    }
                    case MAP: 
                    case MAP_KEY_VALUE: {
                        ParquetJsonColumnConverter mapConverter = new ParquetJsonColumnConverter(new ParquetMapJsonConverter(groupType.getName(), null, groupType), i);
                        converters.add((Object)mapConverter);
                        closeableBuilder.add((Object)mapConverter);
                        continue block5;
                    }
                    case UTF8: 
                    case ENUM: {
                        throw new IllegalArgumentException("Group column " + groupType.getName() + " type " + groupType.getOriginalType() + " not supported");
                    }
                }
            }
            this.converters = converters.build();
            this.converterCloseables = closeableBuilder.build();
        }

        public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType messageType) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (HiveColumnHandle column : this.columns) {
                if (column.isPartitionKey() || column.getHiveColumnIndex() >= messageType.getFieldCount()) continue;
                fields.add((Object)messageType.getType(column.getName()));
            }
            MessageType requestedProjection = new MessageType(messageType.getName(), (List)fields.build());
            return new ReadSupport.ReadContext(requestedProjection);
        }

        public RecordMaterializer<Void> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
            return new ParquetRecordConverter(this.converters);
        }

        @Override
        public void close() throws IOException {
            for (Closeable closeable : this.converterCloseables) {
                Closeables.closeQuietly((Closeable)closeable);
            }
        }
    }

    public class PrestoParquetRecordReader
    extends ParquetRecordReader<Void> {
        private final PrestoReadSupport readSupport;

        public PrestoParquetRecordReader(PrestoReadSupport readSupport) {
            super((ReadSupport)readSupport);
            this.readSupport = readSupport;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.readSupport.close();
            }
        }
    }
}

