/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class InMemoryHiveMetastore
implements HiveMetastore {
    private final ConcurrentHashMap<String, Database> databases = new ConcurrentHashMap();
    private final ConcurrentHashMap<SchemaTableName, Table> relations = new ConcurrentHashMap();
    private final ConcurrentHashMap<SchemaTableName, Table> views = new ConcurrentHashMap();

    public void createDatabase(Database database) {
        Preconditions.checkNotNull((Object)database, (Object)"database is null");
        File file = new File(URI.create(database.getLocationUri()));
        file.mkdirs();
        if (this.databases.putIfAbsent(database.getName(), database) != null) {
            throw new IllegalArgumentException("Database " + database.getName() + " already exists");
        }
    }

    @Override
    public List<String> getAllDatabases() {
        return ImmutableList.copyOf((Collection)this.databases.keySet());
    }

    @Override
    public void createTable(Table table) {
        SchemaTableName schemaTableName = new SchemaTableName(table.getDbName(), table.getTableName());
        Table tableCopy = table.deepCopy();
        if (tableCopy.getSd() == null) {
            tableCopy.setSd(new StorageDescriptor());
        }
        if (this.relations.putIfAbsent(schemaTableName, tableCopy) != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        if (tableCopy.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            this.views.put(schemaTableName, tableCopy);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName) {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        if (this.relations.remove(schemaTableName) == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        this.views.remove(schemaTableName);
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        SchemaTableName oldTable = new SchemaTableName(databaseName, tableName);
        Table table = this.relations.get(oldTable);
        if (table == null) {
            throw new TableNotFoundException(oldTable);
        }
        SchemaTableName newTable = new SchemaTableName(newDatabaseName, newTableName);
        if (this.relations.putIfAbsent(newTable, table) != null) {
            throw new TableAlreadyExistsException(newTable);
        }
        this.relations.remove(oldTable);
    }

    @Override
    public List<String> getAllTables(String databaseName) throws NoSuchObjectException {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.relations.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return tables.build();
    }

    @Override
    public List<String> getAllViews(String databaseName) throws NoSuchObjectException {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.views.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return tables.build();
    }

    @Override
    public Database getDatabase(String databaseName) throws NoSuchObjectException {
        Database database = this.databases.get(databaseName);
        if (database == null) {
            throw new NoSuchObjectException();
        }
        return database;
    }

    @Override
    public List<String> getPartitionNames(String databaseName, String tableName) throws NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) throws NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table getTable(String databaseName, String tableName) throws NoSuchObjectException {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Table table = this.relations.get(schemaTableName);
        if (table == null) {
            throw new NoSuchObjectException();
        }
        return table;
    }

    @Override
    public void flushCache() {
    }
}

