/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;

public class HdfsOrcDataSource
implements OrcDataSource {
    private final FSDataInputStream inputStream;
    private final String path;
    private final long size;
    private final DataSize maxMergeDistance;
    private long readTimeNanos;

    public HdfsOrcDataSource(String path, FSDataInputStream inputStream, long size, DataSize maxMergeDistance) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path is null");
        this.inputStream = (FSDataInputStream)Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream is null");
        this.size = size;
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size is negative");
        this.maxMergeDistance = (DataSize)Preconditions.checkNotNull((Object)maxMergeDistance, (Object)"maxMergeDistance is null");
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getSize() {
        return this.size;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
    }

    public <K> Map<K, Slice> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Preconditions.checkNotNull(diskRanges, (Object)"diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        Iterable mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), (DataSize)this.maxMergeDistance);
        LinkedHashMap<DiskRange, byte[]> buffers = new LinkedHashMap<DiskRange, byte[]>();
        for (DiskRange mergedRange : mergedRanges) {
            byte[] buffer = new byte[mergedRange.getLength()];
            this.readFully(mergedRange.getOffset(), buffer);
            buffers.put(mergedRange, buffer);
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            slices.put(entry.getKey(), (Object)OrcDataSourceUtils.getDiskRangeSlice((DiskRange)entry.getValue(), buffers));
        }
        return slices.build();
    }

    public String toString() {
        return this.path;
    }
}

