/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.rcfile.RcFileBlockLoader;
import com.facebook.presto.hive.rcfile.RcFilePageSource;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazyFixedWidthBlock;
import com.facebook.presto.spi.block.LazySliceArrayBlock;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.ByteArrays;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableUtils;
import org.joda.time.DateTimeZone;

public class RcBinaryBlockLoader
implements RcFileBlockLoader {
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final byte HIVE_EMPTY_STRING_BYTE = -65;
    private final DateTimeZone sessionTimeZone;

    public RcBinaryBlockLoader(DateTimeZone sessionTimeZone) {
        this.sessionTimeZone = sessionTimeZone;
    }

    @Override
    public LazyBlockLoader<LazyFixedWidthBlock> fixedWidthBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, HiveType hiveType) {
        if (HiveType.HIVE_BOOLEAN.equals(hiveType)) {
            return new LazyBooleanBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_BYTE.equals(hiveType)) {
            return new LazyByteBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_SHORT.equals(hiveType)) {
            return new LazyShortBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_INT.equals(hiveType)) {
            return new LazyIntBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_LONG.equals(hiveType)) {
            return new LazyLongBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_DATE.equals(hiveType)) {
            return new LazyDateBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_TIMESTAMP.equals(hiveType)) {
            return new LazyTimestampBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_FLOAT.equals(hiveType)) {
            return new LazyFloatBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_DOUBLE.equals(hiveType)) {
            return new LazyDoubleBlockLoader(batch, fieldId);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + hiveType);
    }

    @Override
    public LazyBlockLoader<LazySliceArrayBlock> variableWidthBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, HiveType hiveType, ObjectInspector fieldInspector) {
        if (HiveType.HIVE_STRING.equals(hiveType) || HiveType.HIVE_BINARY.equals(hiveType)) {
            return new LazySliceBlockLoader(batch, fieldId);
        }
        if (HiveUtil.isStructuralType(hiveType)) {
            return new LazyJsonSliceBlockLoader(batch, fieldId, fieldInspector, this.sessionTimeZone);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + hiveType);
    }

    private static long readVInt(byte[] bytes, int start, int length) {
        long value = 0L;
        for (int i = 1; i < length; ++i) {
            value <<= 8;
            value |= (long)(bytes[start + i] & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)bytes[start]) ? value ^ 0xFFFFFFFFFFFFFFFFL : value;
    }

    private static final class LazyJsonSliceBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private final ObjectInspector fieldInspector;
        private final DateTimeZone sessionTimeZone;
        private boolean loaded;

        private LazyJsonSliceBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, ObjectInspector fieldInspector, DateTimeZone sessionTimeZone) {
            this.batch = batch;
            this.fieldId = fieldId;
            this.fieldInspector = fieldInspector;
            this.sessionTimeZone = sessionTimeZone;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                Slice[] vector = new Slice[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length <= 0) continue;
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    LazyBinaryObject lazyObject = LazyBinaryFactory.createLazyBinaryObject((ObjectInspector)this.fieldInspector);
                    ByteArrayRef byteArrayRef = new ByteArrayRef();
                    byteArrayRef.setData(bytes);
                    lazyObject.init(byteArrayRef, start, length);
                    vector[i] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, lazyObject.getObject(), this.fieldInspector));
                }
                block.setValues(vector);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazySliceBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazySliceBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                Slice[] vector = new Slice[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length <= 0) continue;
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    vector[i] = length == 1 && bytes[start] == -65 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])Arrays.copyOfRange(bytes, start, start + length));
                }
                block.setValues(vector);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyDoubleBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyDoubleBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                double[] vector = new double[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        Preconditions.checkState((length == 8 ? 1 : 0) != 0, (Object)"Double should be 8 bytes");
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        long longBits = ByteArrays.getLong((byte[])bytes, (int)start);
                        vector[i] = Double.longBitsToDouble(Long.reverseBytes(longBits));
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedDoubleArray((double[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyFloatBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyFloatBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                double[] vector = new double[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        Preconditions.checkState((length == 4 ? 1 : 0) != 0, (Object)"Float should be 4 bytes");
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        int intBits = ByteArrays.getInt((byte[])bytes, (int)start);
                        vector[i] = Float.intBitsToFloat(Integer.reverseBytes(intBits));
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedDoubleArray((double[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyTimestampBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyTimestampBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        long seconds = TimestampWritable.getSeconds((byte[])bytes, (int)start);
                        long nanos = TimestampWritable.getNanos((byte[])bytes, (int)(start + 4));
                        vector[i] = seconds * 1000L + nanos / 1000000L;
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyDateBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyDateBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int positionCount = block.getPositionCount();
                boolean[] isNull = new boolean[positionCount];
                long[] vector = new long[positionCount];
                for (int i = 0; i < positionCount; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        long daysSinceEpoch;
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        vector[i] = daysSinceEpoch = RcBinaryBlockLoader.readVInt(bytes, start, length);
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyLongBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyLongBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0) {
                        isNull[i] = true;
                        continue;
                    }
                    vector[i] = length == 1 ? (long)bytes[start] : RcBinaryBlockLoader.readVInt(bytes, start, length);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyIntBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyIntBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0) {
                        isNull[i] = true;
                        continue;
                    }
                    vector[i] = length == 1 ? (long)bytes[start] : RcBinaryBlockLoader.readVInt(bytes, start, length);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyShortBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyShortBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        Preconditions.checkState((length == 2 ? 1 : 0) != 0, (Object)"Short should be 2 bytes");
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        vector[i] = Short.reverseBytes(ByteArrays.getShort((byte[])bytes, (int)start));
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyByteBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyByteBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        byte[] bytes = writable.getData();
                        int start = writable.getStart();
                        vector[i] = bytes[start];
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyBooleanBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        public LazyBooleanBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int positionCount = block.getPositionCount();
                boolean[] isNull = new boolean[positionCount];
                boolean[] vector = new boolean[positionCount];
                for (int i = 0; i < positionCount; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    int length = writable.getLength();
                    if (length != 0) {
                        int start;
                        byte[] bytes = writable.getData();
                        vector[i] = bytes[start = writable.getStart()] != 0;
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedBooleanArray((boolean[])vector, (int)0, (int)positionCount));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

