/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.util.FileStatusCallback;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.stats.TimeStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class AsyncWalker {
    private final FileSystem fileSystem;
    private final Executor executor;
    private final DirectoryLister directoryLister;
    private final NamenodeStats namenodeStats;
    private final boolean recursive;

    public AsyncWalker(FileSystem fileSystem, Executor executor, DirectoryLister directoryLister, NamenodeStats namenodeStats, boolean recursive) {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem, (Object)"fileSystem is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.directoryLister = (DirectoryLister)Preconditions.checkNotNull((Object)directoryLister, (Object)"directoryLister is null");
        this.namenodeStats = (NamenodeStats)Preconditions.checkNotNull((Object)namenodeStats, (Object)"namenodeStats is null");
        this.recursive = recursive;
    }

    public ListenableFuture<Void> beginWalk(Path path, FileStatusCallback callback) {
        SettableFuture future = SettableFuture.create();
        this.recursiveWalk(path, callback, new AtomicLong(), (SettableFuture<Void>)future);
        return future;
    }

    private void recursiveWalk(final Path path, final FileStatusCallback callback, final AtomicLong taskCount, final SettableFuture<Void> future) {
        taskCount.incrementAndGet();
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncWalker.this.doWalk(path, callback, taskCount, (SettableFuture<Void>)future);
                }
            });
        }
        catch (Throwable t) {
            future.setException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWalk(Path path, FileStatusCallback callback, AtomicLong taskCount, SettableFuture<Void> future) {
        try (SetThreadName ignored = new SetThreadName("HiveHdfsWalker", new Object[0]);){
            RemoteIterator<LocatedFileStatus> iterator = this.getLocatedFileStatusRemoteIterator(path);
            while (true) {
                if (iterator.hasNext()) {
                    LocatedFileStatus status = this.getLocatedFileStatus(iterator);
                    String fileName = status.getPath().getName();
                    if (fileName.startsWith("_") || fileName.startsWith(".")) continue;
                    if (!HadoopFileStatus.isDirectory((FileStatus)status)) {
                        callback.process((FileStatus)status, status.getBlockLocations());
                    } else if (this.recursive) {
                        this.recursiveWalk(status.getPath(), callback, taskCount, future);
                    }
                    if (!future.isDone()) continue;
                    return;
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            future.setException((Throwable)new FileNotFoundException("Partition location does not exist: " + path));
        }
        catch (Throwable t) {
            future.setException(t);
        }
        finally {
            if (taskCount.decrementAndGet() == 0L) {
                future.set(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteIterator<LocatedFileStatus> getLocatedFileStatusRemoteIterator(Path path) throws IOException {
        try (TimeStat.BlockTimer timer = this.namenodeStats.getListLocatedStatus().time();){
            RemoteIterator<LocatedFileStatus> remoteIterator = this.directoryLister.list(this.fileSystem, path);
            return remoteIterator;
        }
        catch (IOException | RuntimeException e) {
            this.namenodeStats.getListLocatedStatus().recordException(e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocatedFileStatus getLocatedFileStatus(RemoteIterator<LocatedFileStatus> iterator) throws IOException {
        try (TimeStat.BlockTimer timer = this.namenodeStats.getRemoteIteratorNext().time();){
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)iterator.next();
            return locatedFileStatus;
        }
        catch (IOException | RuntimeException e) {
            this.namenodeStats.getRemoteIteratorNext().recordException(e);
            throw e;
        }
    }
}

