/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.jets3t.service.io;

import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.BytesProgressWatcher;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.OutputStreamWrapper;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressMonitoredOutputStream
extends OutputStream
implements OutputStreamWrapper {
    private OutputStream outputStream = null;
    private BytesProgressWatcher progressWatcher = null;

    public ProgressMonitoredOutputStream(OutputStream outputStream, BytesProgressWatcher progressWatcher) {
        if (outputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredOutputStream cannot run with a null OutputStream");
        }
        this.outputStream = outputStream;
        this.progressWatcher = progressWatcher;
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        this.progressWatcher.updateBytesTransferred(bytesTransmitted);
    }

    public void resetProgressMonitor() {
        this.progressWatcher.resetWatcher();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.sendNotificationUpdate(1L);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.sendNotificationUpdate(len - off);
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b.length);
        this.sendNotificationUpdate(b.length);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public OutputStream getWrappedOutputStream() {
        return this.outputStream;
    }
}

