/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.GZipInflatingOutputStream;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.model.S3Object;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.security.EncryptionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class DownloadPackage {
    private static final Log log = LogFactory.getLog(DownloadPackage.class);
    private S3Object object = null;
    private String signedUrl = null;
    private File outputFile = null;
    private boolean isUnzipping = false;
    private EncryptionUtil encryptionUtil = null;
    private boolean appendToFile = false;

    public DownloadPackage(S3Object object, File outputFile) {
        this(object, outputFile, false, null);
    }

    public DownloadPackage(S3Object object, File outputFile, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputFile = outputFile;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public DownloadPackage(String signedUrl, File outputFile, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.signedUrl = signedUrl;
        this.outputFile = outputFile;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public S3Object getObject() {
        return this.object;
    }

    public File getDataFile() {
        return this.outputFile;
    }

    public String getSignedUrl() {
        return this.signedUrl;
    }

    public void setSignedUrl(String url) {
        this.signedUrl = url;
    }

    public boolean isSignedDownload() {
        return this.signedUrl != null;
    }

    public boolean isAppendToFile() {
        return this.appendToFile;
    }

    public void setAppendToFile(boolean appendToFile) {
        this.appendToFile = appendToFile;
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
        OutputStream outputStream = new FileOutputStream(this.outputFile, this.appendToFile);
        if (this.isUnzipping) {
            log.debug("Inflating gzipped data for object: " + this.object.getKey());
            outputStream = new GZipInflatingOutputStream(outputStream);
        }
        if (this.encryptionUtil != null) {
            log.debug("Decrypting encrypted data for object: " + this.object.getKey());
            outputStream = this.encryptionUtil.decrypt(outputStream);
        }
        return outputStream;
    }
}

