/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread;

import com.facebook.presto.hadoop.shaded.org.jets3t.service.model.S3Object;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.ServiceEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.ThreadWatcher;

public class UpdateACLEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private UpdateACLEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static UpdateACLEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static UpdateACLEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static UpdateACLEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static UpdateACLEvent newCompletedEvent(Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(2, uniqueOperationId);
        return event;
    }

    public static UpdateACLEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static UpdateACLEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getObjectsWithUpdatedACL() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

