/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.Map;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.CyclicIteration;

class DecommissionManager {
    static final Log LOG = LogFactory.getLog(DecommissionManager.class);
    private final FSNamesystem fsnamesystem;

    DecommissionManager(FSNamesystem namesystem) {
        this.fsnamesystem = namesystem;
    }

    class Monitor
    implements Runnable {
        private final long recheckInterval;
        private final int numNodesPerCheck;
        private String firstkey = "";

        Monitor(int recheckIntervalInSecond, int numNodesPerCheck) {
            this.recheckInterval = (long)recheckIntervalInSecond * 1000L;
            this.numNodesPerCheck = numNodesPerCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DecommissionManager.this.fsnamesystem.isRunning()) {
                FSNamesystem fSNamesystem = DecommissionManager.this.fsnamesystem;
                synchronized (fSNamesystem) {
                    this.check();
                }
                try {
                    Thread.sleep(this.recheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.info("Interrupted " + this.getClass().getSimpleName(), ie);
                }
            }
        }

        private void check() {
            int count = 0;
            for (Map.Entry<String, DatanodeDescriptor> entry : new CyclicIteration<String, DatanodeDescriptor>(((DecommissionManager)DecommissionManager.this).fsnamesystem.datanodeMap, this.firstkey)) {
                DatanodeDescriptor d = entry.getValue();
                this.firstkey = entry.getKey();
                if (!d.isDecommissionInProgress()) continue;
                try {
                    DecommissionManager.this.fsnamesystem.checkDecommissionStateInternal(d);
                }
                catch (Exception e) {
                    LOG.warn("entry=" + entry, e);
                }
                if (++count != this.numNodesPerCheck) continue;
                return;
            }
        }
    }
}

