/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import javax.net.SocketFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.znerd.xmlenc.XMLOutputter;

public class FileChecksumServlets {

    public static class GetServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            String filename = this.getFilename(request, response);
            XMLOutputter xml = new XMLOutputter((Writer)out, "UTF-8");
            xml.declaration();
            final Configuration conf = new Configuration(DataNode.getDataNode().getConf());
            int socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
            SocketFactory socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
            try {
                ClientProtocol nnproxy = this.getUGI(request, conf).doAs(new PrivilegedExceptionAction<ClientProtocol>(){

                    @Override
                    public ClientProtocol run() throws IOException {
                        return DFSClient.createNamenode(conf);
                    }
                });
                MD5MD5CRC32FileChecksum checksum = DFSClient.getFileChecksum(filename, nnproxy, socketFactory, socketTimeout);
                MD5MD5CRC32FileChecksum.write(xml, checksum);
            }
            catch (IOException ioe) {
                this.writeXml(ioe, filename, xml);
            }
            catch (InterruptedException e) {
                this.writeXml(e, filename, xml);
            }
            xml.endDocument();
        }
    }

    public static class RedirectServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletContext context = this.getServletContext();
            Configuration conf = (Configuration)context.getAttribute("current.conf");
            UserGroupInformation ugi = this.getUGI(request, conf);
            String tokenString = request.getParameter("delegation");
            NameNode namenode = (NameNode)context.getAttribute("name.node");
            DatanodeDescriptor datanode = namenode.getNamesystem().getRandomDatanode();
            try {
                URI uri = this.createRedirectUri("/getFileChecksum", ugi, datanode, request, tokenString);
                response.sendRedirect(uri.toURL().toString());
            }
            catch (URISyntaxException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IOException e) {
                response.sendError(400, e.getMessage());
            }
        }
    }
}

