/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Krb5AndCertsSslSocketConnector;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;
import org.mortbay.jetty.servlet.Context;

public class SecondaryNameNode
implements Runnable {
    public static final Log LOG;
    private final long starttime = System.currentTimeMillis();
    private volatile long lastCheckpointTime = 0L;
    private String fsName;
    private CheckpointStorage checkpointImage;
    private NamenodeProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private volatile boolean shouldRun;
    private HttpServer infoServer;
    private int infoPort;
    private int imagePort;
    private String infoBindAddress;
    private Collection<File> checkpointDirs;
    private Collection<File> checkpointEditsDirs;
    private long checkpointPeriod;
    private long checkpointSize;

    public String toString() {
        return this.getClass().getSimpleName() + " Status" + "\nName Node Address    : " + this.nameNodeAddr + "\nStart Time           : " + new Date(this.starttime) + "\nLast Checkpoint Time : " + (this.lastCheckpointTime == 0L ? "--" : new Date(this.lastCheckpointTime)) + "\nCheckpoint Period    : " + this.checkpointPeriod + " seconds" + "\nCheckpoint Size      : " + StringUtils.byteDesc(this.checkpointSize) + " (= " + this.checkpointSize + " bytes)" + "\nCheckpoint Dirs      : " + this.checkpointDirs + "\nCheckpoint Edits Dirs: " + this.checkpointEditsDirs;
    }

    FSImage getFSImage() {
        return this.checkpointImage;
    }

    public SecondaryNameNode(Configuration conf) throws IOException {
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.secondary.info.bindAddress", "dfs.secondary.info.port", "dfs.secondary.http.address");
        return NetUtils.createSocketAddr(infoAddr);
    }

    private void initialize(Configuration conf) throws IOException {
        int editsTolerationLength = conf.getInt("dfs.namenode.edits.toleration.length", 0);
        if (editsTolerationLength >= 0) {
            LOG.info("dfs.namenode.edits.toleration.length is set to " + editsTolerationLength + ".  Override it with -1, i.e. disable it.");
            conf.setInt("dfs.namenode.edits.toleration.length", -1);
        }
        InetSocketAddress infoSocAddr = SecondaryNameNode.getHttpAddress(conf);
        this.infoBindAddress = infoSocAddr.getHostName();
        if (UserGroupInformation.isSecurityEnabled()) {
            SecurityUtil.login(conf, "dfs.secondary.namenode.keytab.file", "dfs.secondary.namenode.kerberos.principal", this.infoBindAddress);
        }
        JvmMetricsSource.create("SecondaryNameNode", conf.get("session.id"));
        this.shouldRun = true;
        this.nameNodeAddr = NameNode.getServiceAddress(conf, true);
        this.conf = conf;
        this.namenode = (NamenodeProtocol)RPC.waitForProxy(NamenodeProtocol.class, 3L, this.nameNodeAddr, conf);
        this.fsName = this.getInfoServer();
        this.checkpointDirs = FSImage.getCheckpointDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointEditsDirs = FSImage.getCheckpointEditsDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointImage = new CheckpointStorage();
        this.checkpointImage.recoverCreate(this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointPeriod = conf.getLong("fs.checkpoint.period", 3600L);
        this.checkpointSize = conf.getLong("fs.checkpoint.size", 0x400000L);
        if (SecurityUtil.useKsslAuth()) {
            this.initializeKsslWebServer(infoSocAddr);
        } else {
            this.initializeHttpWebServer(infoSocAddr);
        }
        LOG.info("Web server init done");
        this.infoPort = this.infoServer.getPort();
        if (!SecurityUtil.useKsslAuth()) {
            this.imagePort = this.infoPort;
        }
        conf.set("dfs.secondary.http.address", this.infoBindAddress + ":" + this.infoPort);
        LOG.info("Secondary Web-server up at: " + this.infoBindAddress + ":" + this.infoPort);
        LOG.warn("Checkpoint Period   :" + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)");
        LOG.warn("Log Size Trigger    :" + this.checkpointSize + " bytes " + "(" + this.checkpointSize / 1024L + " KB)");
    }

    private void initializeHttpWebServer(final InetSocketAddress infoSocAddr) throws IOException {
        int tmpInfoPort;
        this.infoServer = new HttpServer("secondary", this.infoBindAddress, tmpInfoPort, (tmpInfoPort = infoSocAddr.getPort()) == 0, this.conf, SecurityUtil.getAdminAcls(this.conf, "dfs.cluster.administrators")){
            {
                super(x0, x1, x2, x3, x4, x5);
                if (UserGroupInformation.isSecurityEnabled()) {
                    String httpKeytab;
                    HashMap<String, String> params = new HashMap<String, String>();
                    String principalInConf = SecondaryNameNode.this.conf.get("dfs.secondary.namenode.kerberos.internal.spnego.principal");
                    if (principalInConf != null && !principalInConf.isEmpty()) {
                        params.put("kerberos.principal", SecurityUtil.getServerPrincipal(principalInConf, infoSocAddr.getHostName()));
                    }
                    if (null == (httpKeytab = SecondaryNameNode.this.conf.get("dfs.web.authentication.kerberos.keytab"))) {
                        httpKeytab = SecondaryNameNode.this.conf.get("dfs.secondary.namenode.keytab.file");
                    }
                    if (httpKeytab != null && !httpKeytab.isEmpty()) {
                        params.put("kerberos.keytab", httpKeytab);
                    }
                    params.put("type", "kerberos");
                    this.defineFilter((Context)this.webAppContext, "SpnegoFilter", AuthenticationFilter.class.getName(), params, null);
                }
            }
        };
        this.infoServer.setAttribute("secondary.name.node", this);
        this.infoServer.setAttribute("name.system.image", this.checkpointImage);
        this.infoServer.setAttribute("current.conf", this.conf);
        this.infoServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class, true, false);
        this.infoServer.start();
    }

    private void initializeKsslWebServer(final InetSocketAddress infoSocAddr) throws IOException {
        UserGroupInformation httpUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI(SecurityUtil.getServerPrincipal(this.conf.get("dfs.secondary.namenode.kerberos.https.principal"), this.infoBindAddress), this.conf.get("dfs.secondary.namenode.keytab.file"));
        try {
            this.infoServer = httpUGI.doAs(new PrivilegedExceptionAction<HttpServer>(){

                @Override
                public HttpServer run() throws IOException, InterruptedException {
                    LOG.info("Starting web server as: " + UserGroupInformation.getCurrentUser().getUserName());
                    int tmpInfoPort = infoSocAddr.getPort();
                    SecondaryNameNode.this.infoServer = new HttpServer("secondary", SecondaryNameNode.this.infoBindAddress, tmpInfoPort, tmpInfoPort == 0, SecondaryNameNode.this.conf, SecurityUtil.getAdminAcls(SecondaryNameNode.this.conf, "dfs.cluster.administrators"));
                    System.setProperty("https.cipherSuites", Krb5AndCertsSslSocketConnector.KRB5_CIPHER_SUITES.get(0));
                    InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(SecondaryNameNode.this.infoBindAddress + ":" + SecondaryNameNode.this.conf.getInt("dfs.secondary.https.port", 50490));
                    SecondaryNameNode.this.imagePort = secInfoSocAddr.getPort();
                    SecondaryNameNode.this.infoServer.addSslListener(secInfoSocAddr, SecondaryNameNode.this.conf, false, true);
                    SecondaryNameNode.this.infoServer.setAttribute("name.system.image", SecondaryNameNode.this.checkpointImage);
                    SecondaryNameNode.this.infoServer.setAttribute("current.conf", SecondaryNameNode.this.conf);
                    SecondaryNameNode.this.infoServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class, true, true);
                    SecondaryNameNode.this.infoServer.start();
                    return SecondaryNameNode.this.infoServer;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.shouldRun = false;
        try {
            if (this.infoServer != null) {
                this.infoServer.stop();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception shutting down SecondaryNameNode", e);
        }
        try {
            if (this.checkpointImage != null) {
                this.checkpointImage.close();
            }
        }
        catch (IOException e) {
            LOG.warn(StringUtils.stringifyException(e));
        }
    }

    @Override
    public void run() {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error(StringUtils.stringifyException(e));
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
            ugi.doAs(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SecondaryNameNode.this.doWork();
                    return null;
                }
            });
        } else {
            this.doWork();
        }
    }

    public void doWork() {
        long period = 300L;
        if (this.checkpointPeriod < period) {
            period = this.checkpointPeriod;
        }
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                if (UserGroupInformation.isSecurityEnabled()) {
                    UserGroupInformation.getCurrentUser().reloginFromKeytab();
                }
                long now = System.currentTimeMillis();
                long size = this.namenode.getEditLogSize();
                if (size < this.checkpointSize && now < this.lastCheckpointTime + 1000L * this.checkpointPeriod) continue;
                this.doCheckpoint();
                this.lastCheckpointTime = now;
            }
            catch (IOException e) {
                LOG.error("Exception in doCheckpoint: ");
                LOG.error(StringUtils.stringifyException(e));
                e.printStackTrace();
            }
            catch (Throwable e) {
                LOG.error("Throwable Exception in doCheckpoint: ");
                LOG.error(StringUtils.stringifyException(e));
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
        }
    }

    private void downloadCheckpointFiles(final CheckpointSignature sig) throws IOException {
        try {
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ((SecondaryNameNode)SecondaryNameNode.this).checkpointImage.cTime = sig.cTime;
                    ((SecondaryNameNode)SecondaryNameNode.this).checkpointImage.checkpointTime = sig.checkpointTime;
                    String fileid = "getimage=1";
                    File[] srcNames = SecondaryNameNode.this.checkpointImage.getImageFiles();
                    assert (srcNames.length > 0) : "No checkpoint targets.";
                    TransferFsImage.getFileClient(SecondaryNameNode.this.fsName, fileid, srcNames, false);
                    LOG.info("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes.");
                    fileid = "getedit=1";
                    srcNames = SecondaryNameNode.this.checkpointImage.getEditsFiles();
                    assert (srcNames.length > 0) : "No checkpoint targets.";
                    TransferFsImage.getFileClient(SecondaryNameNode.this.fsName, fileid, srcNames, false);
                    LOG.info("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes.");
                    SecondaryNameNode.this.checkpointImage.checkpointUploadDone();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void putFSImage(CheckpointSignature sig) throws IOException {
        String fileid = "putimage=1&port=" + this.imagePort + "&machine=" + this.infoBindAddress + "&token=" + sig.toString() + "&newChecksum=" + this.getNewChecksum();
        LOG.info("Posted URL " + this.fsName + fileid);
        TransferFsImage.getFileClient(this.fsName, fileid, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MD5Hash getNewChecksum() throws IOException {
        FilterInputStream imageIn = null;
        try {
            MessageDigest digester = MD5Hash.getDigester();
            imageIn = new DigestInputStream(new FileInputStream(this.checkpointImage.getFsImageName()), digester);
            byte[] in = new byte[FSConstants.BUFFER_SIZE];
            int totalRead = 0;
            int read = 0;
            while ((read = imageIn.read(in)) > 0) {
                LOG.debug("Computing fsimage checksum. Read " + (totalRead += read) + " bytes so far.");
            }
            MD5Hash mD5Hash = new MD5Hash(digester.digest());
            return mD5Hash;
        }
        finally {
            if (imageIn != null) {
                imageIn.close();
            }
        }
    }

    private String getInfoServer() throws IOException {
        String infoAddr = NameNode.getInfoServer(this.conf);
        if (infoAddr == null) {
            throw new IOException("This is not a DFS");
        }
        LOG.debug("infoAddr = " + infoAddr);
        return infoAddr;
    }

    void doCheckpoint() throws IOException {
        this.startCheckpoint();
        CheckpointSignature sig = this.namenode.rollEditLog();
        if (ErrorSimulator.getErrorSimulation(0)) {
            throw new IOException("Simulating error0 after creating edits.new");
        }
        this.downloadCheckpointFiles(sig);
        this.doMerge(sig);
        this.putFSImage(sig);
        if (ErrorSimulator.getErrorSimulation(1)) {
            throw new IOException("Simulating error1 after uploading new image to NameNode");
        }
        this.namenode.rollFsImage();
        this.checkpointImage.endCheckpoint();
        LOG.info("Checkpoint done. New Image Size: " + this.checkpointImage.getFsImageName().length());
    }

    private void startCheckpoint() throws IOException {
        this.checkpointImage.unlockAll();
        this.checkpointImage.getEditLog().close();
        this.checkpointImage.recoverCreate(this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointImage.startCheckpoint();
    }

    private void doMerge(CheckpointSignature sig) throws IOException {
        FSNamesystem namesystem = new FSNamesystem(this.checkpointImage, this.conf);
        assert (namesystem.dir.fsImage == this.checkpointImage);
        this.checkpointImage.doMerge(sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processArgs(String[] argv) throws Exception {
        int exitCode;
        block18: {
            String cmd;
            if (argv.length < 1) {
                this.printUsage("");
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-geteditsize".equals(cmd = argv[i++])) {
                if (argv.length != 1) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            } else if ("-checkpoint".equals(cmd)) {
                if (argv.length != 1 && argv.length != 2) {
                    this.printUsage(cmd);
                    return exitCode;
                }
                if (argv.length == 2 && !"force".equals(argv[i])) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            }
            exitCode = 0;
            try {
                if ("-checkpoint".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    if (size >= this.checkpointSize || argv.length == 2 && "force".equals(argv[i])) {
                        this.doCheckpoint();
                    } else {
                        System.err.println("EditLog size " + size + " bytes is " + "smaller than configured checkpoint " + "size " + this.checkpointSize + " bytes.");
                        System.err.println("Skipping checkpoint.");
                    }
                    break block18;
                }
                if ("-geteditsize".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    System.out.println("EditLog size is " + size + " bytes");
                    break block18;
                }
                exitCode = -1;
                LOG.error(cmd.substring(1) + ": Unknown command");
                this.printUsage("");
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    LOG.error(cmd.substring(1) + ": " + content[0]);
                }
                catch (Exception ex) {
                    LOG.error(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                }
            }
            catch (IOException e) {
                exitCode = -1;
                LOG.error(cmd.substring(1) + ": " + e.getLocalizedMessage());
            }
        }
        return exitCode;
    }

    private void printUsage(String cmd) {
        if ("-geteditsize".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-geteditsize]");
        } else if ("-checkpoint".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]]");
        } else {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]] [-geteditsize] ");
        }
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(SecondaryNameNode.class, argv, LOG);
        Configuration tconf = new Configuration();
        if (argv.length >= 1) {
            SecondaryNameNode secondary = new SecondaryNameNode(tconf);
            int ret = secondary.processArgs(argv);
            System.exit(ret);
        }
        Daemon checkpointThread = new Daemon(new SecondaryNameNode(tconf));
        checkpointThread.start();
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        LOG = LogFactory.getLog(SecondaryNameNode.class.getName());
    }

    static class CheckpointStorage
    extends FSImage {
        CheckpointStorage() throws IOException {
        }

        @Override
        public boolean isConversionNeeded(Storage.StorageDirectory sd) {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recoverCreate(Collection<File> dataDirs, Collection<File> editsDirs) throws IOException {
            ArrayList<File> tempDataDirs = new ArrayList<File>(dataDirs);
            ArrayList<File> tempEditsDirs = new ArrayList<File>(editsDirs);
            this.storageDirs = new ArrayList();
            this.setStorageDirectories(tempDataDirs, tempEditsDirs);
            Iterator<Storage.StorageDirectory> it = this.dirIterator();
            block9: while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                boolean isAccessible = true;
                try {
                    if (sd.getRoot().mkdirs()) {
                        // empty if block
                    }
                }
                catch (SecurityException se) {
                    isAccessible = false;
                }
                if (!isAccessible) {
                    throw new InconsistentFSStateException(sd.getRoot(), "cannot access checkpoint directory.");
                }
                try {
                    Storage.StorageState curState = sd.analyzeStorage(HdfsConstants.StartupOption.REGULAR);
                    switch (curState) {
                        case NON_EXISTENT: {
                            throw new InconsistentFSStateException(sd.getRoot(), "checkpoint directory does not exist or is not accessible.");
                        }
                        case NOT_FORMATTED: {
                            continue block9;
                        }
                        case NORMAL: {
                            continue block9;
                        }
                    }
                    sd.doRecover(curState);
                }
                catch (IOException ioe) {
                    sd.unlock();
                    throw ioe;
                }
            }
            return;
        }

        void startCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                this.moveCurrent(sd);
            }
        }

        void endCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                this.moveLastCheckpoint(sd);
            }
        }

        private void doMerge(CheckpointSignature sig) throws IOException {
            this.getEditLog().open();
            Storage.StorageDirectory sdName = null;
            Storage.StorageDirectory sdEdits = null;
            Iterator<Storage.StorageDirectory> it = null;
            it = this.dirIterator(FSImage.NameNodeDirType.IMAGE);
            if (it.hasNext()) {
                sdName = it.next();
            }
            if ((it = this.dirIterator(FSImage.NameNodeDirType.EDITS)).hasNext()) {
                sdEdits = it.next();
            }
            if (sdName == null || sdEdits == null) {
                throw new IOException("Could not locate checkpoint directories");
            }
            this.loadFSImage(FSImage.getImageFile(sdName, FSImage.NameNodeFile.IMAGE));
            this.loadFSEdits(sdEdits, null);
            sig.validateStorageInfo(this);
            this.saveNamespace(false);
        }
    }

    static class ErrorSimulator {
        private static boolean[] simulation = null;

        ErrorSimulator() {
        }

        static void initializeErrorSimulationEvent(int numberOfEvents) {
            simulation = new boolean[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                ErrorSimulator.simulation[i] = false;
            }
        }

        static boolean getErrorSimulation(int index) {
            if (simulation == null) {
                return false;
            }
            assert (index < simulation.length);
            return simulation[index];
        }

        static void setErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = true;
        }

        static void clearErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = false;
        }
    }
}

