/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.security.UserGroupInformation;

public class StreamFile
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    public static final String CONTENT_LENGTH = "Content-Length";
    static InetSocketAddress nameNodeAddr;
    static DataNode datanode;

    protected DFSClient getDFSClient(HttpServletRequest request) throws IOException, InterruptedException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        return JspHelper.getDFSClient(ugi, nameNodeAddr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DFSClient dfs;
        String filename;
        String string = filename = request.getPathInfo() != null ? request.getPathInfo() : "/";
        if (filename == null || filename.length() == 0) {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.print("Invalid input");
            return;
        }
        try {
            dfs = this.getDFSClient(request);
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
            return;
        }
        DFSClient.DFSInputStream in = dfs.open(filename);
        ServletOutputStream os = response.getOutputStream();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
        response.setHeader(CONTENT_LENGTH, "" + in.getFileLength());
        byte[] buf = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("response.isCommitted()=" + response.isCommitted(), e);
            }
            throw e;
        }
        finally {
            try {
                in.close();
                os.close();
            }
            finally {
                dfs.close();
            }
        }
    }

    static {
        datanode = null;
        datanode = DataNode.getDataNode();
        if (datanode != null) {
            nameNodeAddr = datanode.getNameNodeAddr();
        }
    }
}

