/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.util.ReflectionUtils;

public class CodecPool {
    private static final Log LOG = LogFactory.getLog(CodecPool.class);
    private static final Map<Class<Compressor>, List<Compressor>> compressorPool = new HashMap<Class<Compressor>, List<Compressor>>();
    private static final Map<Class<Decompressor>, List<Decompressor>> decompressorPool = new HashMap<Class<Decompressor>, List<Decompressor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T borrow(Map<Class<T>, List<T>> pool, Class<? extends T> codecClass) {
        T codec = null;
        Map<Class<T>, List<T>> map = pool;
        synchronized (map) {
            List<T> codecList;
            if (pool.containsKey(codecClass) && (codecList = pool.get(codecClass)) != null) {
                List<T> list = codecList;
                synchronized (list) {
                    if (!codecList.isEmpty()) {
                        codec = codecList.remove(codecList.size() - 1);
                    }
                }
            }
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void payback(Map<Class<T>, List<T>> pool, T codec) {
        if (codec != null) {
            Class<T> codecClass = ReflectionUtils.getClass(codec);
            Map<Class<T>, List<T>> map = pool;
            synchronized (map) {
                List<T> codecList;
                if (!pool.containsKey(codecClass)) {
                    pool.put(codecClass, new ArrayList());
                }
                List<T> list = codecList = pool.get(codecClass);
                synchronized (list) {
                    codecList.add(codec);
                }
            }
        }
    }

    public static Compressor getCompressor(CompressionCodec codec, Configuration conf) {
        Compressor compressor = CodecPool.borrow(compressorPool, codec.getCompressorType());
        if (compressor == null) {
            compressor = codec.createCompressor();
            LOG.info("Got brand-new compressor");
        } else {
            compressor.reinit(conf);
            LOG.debug("Got recycled compressor");
        }
        return compressor;
    }

    public static Compressor getCompressor(CompressionCodec codec) {
        return CodecPool.getCompressor(codec, null);
    }

    public static Decompressor getDecompressor(CompressionCodec codec) {
        Decompressor decompressor = CodecPool.borrow(decompressorPool, codec.getDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createDecompressor();
            LOG.info("Got brand-new decompressor");
        } else {
            LOG.debug("Got recycled decompressor");
        }
        return decompressor;
    }

    public static void returnCompressor(Compressor compressor) {
        if (compressor == null) {
            return;
        }
        if (compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        compressor.reset();
        CodecPool.payback(compressorPool, compressor);
    }

    public static void returnDecompressor(Decompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        decompressor.reset();
        CodecPool.payback(decompressorPool, decompressor);
    }
}

