/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;

class ConnectionHeader
implements Writable {
    public static final Log LOG = LogFactory.getLog(ConnectionHeader.class);
    private String protocol;
    private UserGroupInformation ugi = null;
    private SaslRpcServer.AuthMethod authMethod;

    public ConnectionHeader() {
    }

    public ConnectionHeader(String protocol, UserGroupInformation ugi, SaslRpcServer.AuthMethod authMethod) {
        this.protocol = protocol;
        this.ugi = ugi;
        this.authMethod = authMethod;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean ugiUsernamePresent;
        this.protocol = Text.readString(in);
        if (this.protocol.isEmpty()) {
            this.protocol = null;
        }
        if (ugiUsernamePresent = in.readBoolean()) {
            String username = in.readUTF();
            boolean realUserNamePresent = in.readBoolean();
            if (realUserNamePresent) {
                String realUserName = in.readUTF();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(realUserName);
                this.ugi = UserGroupInformation.createProxyUser(username, realUserUgi);
            } else {
                this.ugi = UserGroupInformation.createRemoteUser(username);
            }
        } else {
            this.ugi = null;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.protocol == null ? "" : this.protocol);
        if (this.ugi != null) {
            if (this.authMethod == SaslRpcServer.AuthMethod.KERBEROS) {
                out.writeBoolean(true);
                out.writeUTF(this.ugi.getUserName());
                out.writeBoolean(false);
            } else if (this.authMethod == SaslRpcServer.AuthMethod.DIGEST) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.ugi.getUserName());
                if (this.ugi.getRealUser() != null) {
                    out.writeBoolean(true);
                    out.writeUTF(this.ugi.getRealUser().getUserName());
                } else {
                    out.writeBoolean(false);
                }
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public String toString() {
        return this.protocol + "-" + this.ugi;
    }
}

