/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.security.UserGroupInformation;

public class CleanupQueue {
    public static final Log LOG = LogFactory.getLog(CleanupQueue.class);
    private static final PathCleanupThread cleanupThread = new PathCleanupThread();
    private static final CleanupQueue inst = new CleanupQueue();

    public static CleanupQueue getInstance() {
        return inst;
    }

    protected CleanupQueue() {
    }

    public void addToQueue(PathDeletionContext ... contexts) {
        cleanupThread.addToQueue(contexts);
    }

    protected boolean isQueueEmpty() {
        return cleanupThread.queue.size() == 0;
    }

    private static class PathCleanupThread
    extends Thread {
        private LinkedBlockingQueue<PathDeletionContext> queue = new LinkedBlockingQueue();

        public PathCleanupThread() {
            this.setName("Directory/File cleanup thread");
            this.setDaemon(true);
            this.start();
        }

        void addToQueue(PathDeletionContext[] contexts) {
            for (PathDeletionContext context : contexts) {
                try {
                    this.queue.put(context);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + " started.");
            }
            PathDeletionContext context = null;
            while (true) {
                try {
                    while (true) {
                        context = this.queue.take();
                        context.deletePath();
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("DELETED " + context);
                    }
                }
                catch (InterruptedException t) {
                    LOG.warn("Interrupted deletion of " + context);
                    return;
                }
                catch (Throwable e) {
                    LOG.warn("Error deleting path " + context, e);
                    continue;
                }
                break;
            }
        }
    }

    static class PathDeletionContext {
        final Path fullPath;
        final Configuration conf;
        final UserGroupInformation ugi;
        final JobID jobIdTokenRenewalToCancel;

        public PathDeletionContext(Path fullPath, Configuration conf) {
            this(fullPath, conf, null, null);
        }

        public PathDeletionContext(Path fullPath, Configuration conf, UserGroupInformation ugi) {
            this(fullPath, conf, ugi, null);
        }

        public PathDeletionContext(Path fullPath, Configuration conf, UserGroupInformation ugi, JobID jobIdTokenRenewalToCancel) {
            this.fullPath = fullPath;
            this.conf = conf;
            this.ugi = ugi;
            this.jobIdTokenRenewalToCancel = jobIdTokenRenewalToCancel;
        }

        protected Path getPathForCleanup() {
            return this.fullPath;
        }

        protected void deletePath() throws IOException, InterruptedException {
            final Path p = this.getPathForCleanup();
            (this.ugi == null ? UserGroupInformation.getLoginUser() : this.ugi).doAs(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException {
                    FileSystem fs = p.getFileSystem(PathDeletionContext.this.conf);
                    try {
                        fs.delete(p, true);
                        Object var2_2 = null;
                        return var2_2;
                    }
                    finally {
                        if (PathDeletionContext.this.ugi != null) {
                            fs.close();
                        }
                    }
                }
            });
            if (this.jobIdTokenRenewalToCancel != null && this.conf.getBoolean("mapreduce.job.complete.cancel.delegation.tokens", true)) {
                DelegationTokenRenewal.removeDelegationTokenRenewalForJob(this.jobIdTokenRenewalToCancel);
            }
        }

        public String toString() {
            Path p = this.getPathForCleanup();
            return null == p ? "undefined" : p.toString();
        }
    }
}

