/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.CompletedJobStatusStore;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HDFSMonitorThread;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.InfoMap;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMXBean;
import org.apache.hadoop.mapred.JobTrackerNotYetInitializedException;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.SafeModeException;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskGraphServlet;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

public class JobTracker
implements MRConstants,
InterTrackerProtocol,
JobSubmissionProtocol,
TaskTrackerManager,
RefreshUserMappingsProtocol,
RefreshAuthorizationPolicyProtocol,
AdminOperationsProtocol,
JobTrackerMXBean {
    static long TASKTRACKER_EXPIRY_INTERVAL;
    static long RETIRE_JOB_INTERVAL;
    static long RETIRE_JOB_CHECK_INTERVAL;
    private final long DELEGATION_TOKEN_GC_INTERVAL = 3600000L;
    private final DelegationTokenSecretManager secretManager;
    private static double MAX_BLACKLIST_FRACTION;
    private double AVERAGE_BLACKLIST_THRESHOLD = 0.5;
    private int TRACKER_FAULT_THRESHOLD;
    private int TRACKER_FAULT_TIMEOUT_WINDOW;
    private int TRACKER_FAULT_BUCKET_WIDTH;
    private long TRACKER_FAULT_BUCKET_WIDTH_MSECS;
    private int NUM_FAULT_BUCKETS;
    long MAX_JOBCONF_SIZE = 0x500000L;
    public static final String MAX_USER_JOBCONF_SIZE_KEY = "mapred.user.jobconf.limit";
    public static final String DELEGATION_KEY_UPDATE_INTERVAL_KEY = "mapreduce.cluster.delegation.key.update-interval";
    public static final long DELEGATION_KEY_UPDATE_INTERVAL_DEFAULT = 86400000L;
    public static final String DELEGATION_TOKEN_RENEW_INTERVAL_KEY = "mapreduce.cluster.delegation.token.renew-interval";
    public static final long DELEGATION_TOKEN_RENEW_INTERVAL_DEFAULT = 86400000L;
    public static final String DELEGATION_TOKEN_MAX_LIFETIME_KEY = "mapreduce.cluster.delegation.token.max-lifetime";
    public static final long DELEGATION_TOKEN_MAX_LIFETIME_DEFAULT = 604800000L;
    static final String JT_HEARTBEATS_IN_SECOND = "mapred.heartbeats.in.second";
    private int NUM_HEARTBEATS_IN_SECOND;
    private static final int DEFAULT_NUM_HEARTBEATS_IN_SECOND = 100;
    private static final int MIN_NUM_HEARTBEATS_IN_SECOND = 1;
    static final String JT_HEARTBEATS_SCALING_FACTOR = "mapreduce.jobtracker.heartbeats.scaling.factor";
    private float HEARTBEATS_SCALING_FACTOR;
    private final float MIN_HEARTBEATS_SCALING_FACTOR = 0.01f;
    private final float DEFAULT_HEARTBEATS_SCALING_FACTOR = 1.0f;
    static final String JT_INIT_CONFIG_KEY_FOR_TESTS = "mapreduce.jobtracker.init.for.tests";
    volatile State state = State.INITIALIZING;
    private static final int FS_ACCESS_RETRY_PERIOD = 1000;
    static final String JOB_INFO_FILE = "job-info";
    private DNSToSwitchMapping dnsToSwitchMapping;
    private NetworkTopology clusterMap;
    private int numTaskCacheLevels;
    private boolean isNodeGroupAware;
    private Set<Node> nodesAtMaxLevel = Collections.newSetFromMap(new ConcurrentHashMap());
    private final TaskScheduler taskScheduler;
    private final List<JobInProgressListener> jobInProgressListeners = new CopyOnWriteArrayList<JobInProgressListener>();
    private List<ServicePlugin> plugins;
    private static final LocalDirAllocator lDirAlloc;
    static final FsPermission SYSTEM_DIR_PERMISSION;
    static final FsPermission SYSTEM_FILE_PERMISSION;
    private Clock clock;
    private final JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    final int MAX_COMPLETE_USER_JOBS_IN_MEMORY;
    static final int MIN_TIME_BEFORE_RETIRE = 0;
    private int nextJobId = 1;
    public static final Log LOG;
    static final String CONF_VERSION_KEY = "mapreduce.jobtracker.conf.version";
    static final String CONF_VERSION_DEFAULT = "default";
    static final String JT_HDFS_MONITOR_ENABLE = "mapreduce.jt.hdfs.monitor.enable";
    static final boolean DEFAULT_JT_HDFS_MONITOR_THREAD_ENABLE = false;
    static final String JT_HDFS_MONITOR_THREAD_INTERVAL = "mapreduce.jt.hdfs.monitor.interval.ms";
    static final int DEFAULT_JT_HDFS_MONITOR_THREAD_INTERVAL_MS = 5000;
    private Thread hdfsMonitor;
    private JobTrackerInstrumentation myInstrumentation;
    int port;
    String localMachine;
    private String trackerIdentifier;
    long startTime;
    int totalSubmissions = 0;
    private int totalMapTaskCapacity;
    private int totalReduceTaskCapacity;
    private HostsFileReader hostsReader;
    private volatile boolean hasRestarted = false;
    private volatile boolean hasRecovered = false;
    private volatile long recoveryDuration;
    Map<JobID, JobInProgress> jobs = Collections.synchronizedMap(new TreeMap());
    TreeMap<String, ArrayList<JobInProgress>> userToJobsMap = new TreeMap();
    Map<String, Set<JobID>> trackerToJobsToCleanup = new HashMap<String, Set<JobID>>();
    Map<String, Set<TaskAttemptID>> trackerToTasksToCleanup = new HashMap<String, Set<TaskAttemptID>>();
    Map<TaskAttemptID, TaskInProgress> taskidToTIPMap = new TreeMap<TaskAttemptID, TaskInProgress>();
    Map<String, Set<TaskTracker>> hostnameToTaskTracker = Collections.synchronizedMap(new TreeMap());
    TreeMap<TaskAttemptID, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    Map<String, Node> hostnameToNodeMap = Collections.synchronizedMap(new TreeMap());
    int numResolved;
    private FaultyTrackersInfo faultyTrackers = new FaultyTrackersInfo();
    private JobTrackerStatistics statistics = new JobTrackerStatistics();
    int totalMaps = 0;
    int totalReduces = 0;
    private int occupiedMapSlots = 0;
    private int occupiedReduceSlots = 0;
    private int reservedMapSlots = 0;
    private int reservedReduceSlots = 0;
    private HashMap<String, TaskTracker> taskTrackers = new HashMap();
    Map<String, Integer> uniqueHostsMap = new ConcurrentHashMap<String, Integer>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    Thread retireJobsThread = null;
    final int retiredJobsCacheSize;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    CompletedJobStatusStore completedJobStatusStore = null;
    Thread completedJobsStoreThread = null;
    RecoveryManager recoveryManager;
    JobHistoryServer jobHistoryServer;
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    final HttpServer infoServer;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    final LocalFileSystem localFs;
    FileSystem fs = null;
    Path systemDir = null;
    JobConf conf;
    private final ACLsManager aclsManager;
    long limitMaxMemForMapTasks;
    long limitMaxMemForReduceTasks;
    long memSizeForMapSlotOnJT;
    long memSizeForReduceSlotOnJT;
    private QueueManager queueManager;
    public static final String JT_USER_NAME = "mapreduce.jobtracker.kerberos.principal";
    public static final String JT_KEYTAB_FILE = "mapreduce.jobtracker.keytab.file";
    AtomicBoolean initDone = new AtomicBoolean(true);
    Object initDoneLock = new Object();
    private static final Counters EMPTY_COUNTERS;
    private static final TaskReport[] EMPTY_TASK_REPORTS;
    public static final String MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.map.memory.mb";
    public static final String MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.reduce.memory.mb";
    public static final String MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.max.map.memory.mb";
    public static final String MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.max.reduce.memory.mb";
    private static final String[] EMPTY_TASK_DIAGNOSTICS;
    private AtomicBoolean safeMode = new AtomicBoolean(false);
    private AtomicBoolean adminSafeMode = new AtomicBoolean(false);
    private String adminSafeModeUser = "";

    JobTokenSecretManager getJobTokenSecretManager() {
        return this.jobTokenSecretManager;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static JobTracker startTracker(JobConf conf) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, JobTracker.generateNewIdentifier());
    }

    public static JobTracker startTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, identifier, false);
    }

    public static JobTracker startTracker(JobConf conf, String identifier, boolean initialize) throws IOException, InterruptedException {
        DefaultMetricsSystem.initialize("JobTracker");
        JobTracker result = null;
        while (true) {
            try {
                result = new JobTracker(conf, identifier);
                result.taskScheduler.setTaskTrackerManager(result);
            }
            catch (RPC.VersionMismatch e) {
                throw e;
            }
            catch (BindException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (IOException e) {
                LOG.warn("Error starting tracker: " + StringUtils.stringifyException(e));
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        if (result != null) {
            JobEndNotifier.startNotifier();
            MBeans.register("JobTracker", "JobTrackerInfo", result);
            if (initialize) {
                result.setSafeModeInternal(SafeModeAction.SAFEMODE_ENTER);
                result.initializeFilesystem();
                result.setSafeModeInternal(SafeModeAction.SAFEMODE_LEAVE);
                result.initialize();
            }
        }
        return result;
    }

    public void stopTracker() throws IOException {
        JobEndNotifier.stopNotifier();
        this.close();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 31L;
        }
        if (protocol.equals(JobSubmissionProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(AdminOperationsProtocol.class.getName())) {
            return 3L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    public DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.secretManager;
    }

    synchronized void historyFileCopied(JobID jobid, String historyFile) {
        JobInProgress job = this.getJob(jobid);
        if (job != null) {
            if (historyFile != null) {
                job.setHistoryFile(historyFile);
            }
            return;
        }
        RetireJobInfo jobInfo = this.retireJobs.get(jobid);
        if (jobInfo != null && historyFile != null) {
            jobInfo.setHistoryFile(historyFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerStatus> getStatusesOnHost(String hostName) {
        ArrayList<TaskTrackerStatus> statuses = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!hostName.equals(status.getHost())) continue;
                statuses.add(status);
            }
        }
        return statuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumTaskTrackersOnHost(String hostName) {
        int numTrackers = 0;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!hostName.equals(status.getHost())) continue;
                ++numTrackers;
            }
        }
        return numTrackers;
    }

    private void createInstrumentation() {
        JobTrackerInstrumentation tmp;
        Class<? extends JobTrackerInstrumentation> metricsInst = JobTracker.getInstrumentationClass(this.conf);
        LOG.debug("instrumentation class=" + metricsInst);
        if (metricsInst == null) {
            this.myInstrumentation = JobTrackerInstrumentation.create(this, this.conf);
            return;
        }
        try {
            Constructor<? extends JobTrackerInstrumentation> c = metricsInst.getConstructor(JobTracker.class, JobConf.class);
            tmp = c.newInstance(this, this.conf);
        }
        catch (Exception e) {
            LOG.error("failed to initialize job tracker metrics", e);
            tmp = JobTrackerInstrumentation.create(this, this.conf);
        }
        this.myInstrumentation = tmp;
    }

    JobTracker(JobConf conf) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier());
    }

    JobTracker(JobConf conf, QueueManager qm) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier(), new Clock(), qm);
    }

    JobTracker(JobConf conf, Clock clock) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier(), clock);
    }

    JobTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        this(conf, identifier, new Clock());
    }

    JobTracker(JobConf conf, String identifier, Clock clock) throws IOException, InterruptedException {
        this(conf, identifier, clock, new QueueManager(new Configuration(conf)));
    }

    private void initJTConf(JobConf conf) {
        if (conf.getBoolean("dfs.client.retry.policy.enabled", false)) {
            LOG.warn("dfs.client.retry.policy.enabled is enabled, disabling it");
            conf.setBoolean("dfs.client.retry.policy.enabled", false);
        }
    }

    @InterfaceAudience.Private
    void initializeFilesystem() throws IOException, InterruptedException {
        while (!Thread.currentThread().isInterrupted() && this.fs == null) {
            try {
                this.fs = this.getMROwner().doAs(new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws IOException {
                        return FileSystem.get(JobTracker.this.conf);
                    }
                });
            }
            catch (IOException ie) {
                this.fs = null;
                LOG.info("Problem connecting to HDFS Namenode... re-trying", ie);
                Thread.sleep(1000L);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if ("hdfs".equalsIgnoreCase(this.fs.getUri().getScheme())) {
            while (!DistributedFileSystem.isHealthy(this.fs.getUri())) {
                LOG.info("HDFS initialized but not 'healthy' yet, waiting...");
                Thread.sleep(1000L);
            }
        }
    }

    @InterfaceAudience.Private
    void initialize() throws IOException, InterruptedException {
        final JobTracker jtFinal = this;
        this.getMROwner().doAs(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                JobHistory.init(jtFinal, JobTracker.this.conf, jtFinal.localMachine, jtFinal.startTime);
                return true;
            }
        });
        this.recoveryManager = new RecoveryManager();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.systemDir == null) {
                    this.systemDir = new Path(this.getSystemDir());
                }
                try {
                    FileStatus systemDirStatus = this.fs.getFileStatus(this.systemDir);
                    if (!systemDirStatus.getOwner().equals(this.getMROwner().getShortUserName())) {
                        throw new AccessControlException("The systemdir " + this.systemDir + " is not owned by " + this.getMROwner().getShortUserName());
                    }
                    if (!systemDirStatus.getPermission().equals(SYSTEM_DIR_PERMISSION)) {
                        LOG.warn("Incorrect permissions on " + this.systemDir + ". Setting it to " + SYSTEM_DIR_PERMISSION);
                        this.fs.setPermission(this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                    }
                }
                catch (FileNotFoundException fnf) {
                    // empty catch block
                }
                FileStatus[] systemDirData = this.fs.listStatus(this.systemDir);
                if (this.conf.getBoolean("mapred.jobtracker.restart.recover", false) && systemDirData != null) {
                    for (FileStatus status : systemDirData) {
                        try {
                            this.recoveryManager.checkAndAddJob(status);
                        }
                        catch (Throwable t) {
                            LOG.warn("Failed to add the job " + status.getPath().getName(), t);
                        }
                    }
                    this.hasRestarted = this.recoveryManager.shouldRecover();
                    if (this.hasRestarted) break;
                }
                LOG.info("Cleaning up the system directory");
                this.fs.delete(this.systemDir, true);
                if (FileSystem.mkdirs(this.fs, this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION))) break;
                LOG.error("Mkdirs failed to create " + this.systemDir);
            }
            catch (AccessControlException ace) {
                LOG.warn("Failed to operate on mapred.system.dir (" + this.systemDir + ") because of permissions.");
                LOG.warn("Manually delete the mapred.system.dir (" + this.systemDir + ") and then start the JobTracker.");
                LOG.warn("Bailing out ... ", ace);
                throw ace;
            }
            catch (IOException ie) {
                LOG.info("problem cleaning system directory: " + this.systemDir, ie);
            }
            Thread.sleep(1000L);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (!this.hasRestarted) {
            this.conf.deleteLocalFiles(SUBDIR);
        }
        FileSystem historyFS = this.getMROwner().doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                JobHistory.initDone(JobTracker.this.conf, JobTracker.this.fs);
                String historyLogDir = JobHistory.getCompletedJobHistoryLocation().toString();
                JobTracker.this.infoServer.setAttribute("historyLogDir", historyLogDir);
                JobTracker.this.infoServer.setAttribute("serialNumberDirectoryDigits", JobHistory.serialNumberDirectoryDigits());
                JobTracker.this.infoServer.setAttribute("serialNumberTotalDigits", JobHistory.serialNumberTotalDigits());
                return new Path(historyLogDir).getFileSystem(JobTracker.this.conf);
            }
        });
        this.infoServer.setAttribute("fileSys", historyFS);
        this.infoServer.setAttribute("jobConf", this.conf);
        this.infoServer.setAttribute("aclManager", this.aclsManager);
        if (JobHistoryServer.isEmbedded(this.conf)) {
            LOG.info("History server being initialized in embedded mode");
            this.jobHistoryServer = new JobHistoryServer(this.conf, this.aclsManager, this.infoServer);
            this.jobHistoryServer.start();
            LOG.info("Job History Server web address: " + JobHistoryServer.getAddress(this.conf));
        }
        this.completedJobStatusStore = new CompletedJobStatusStore(this.conf, this.aclsManager);
        if (this.conf.getBoolean(JT_HDFS_MONITOR_ENABLE, false)) {
            this.hdfsMonitor = new HDFSMonitorThread(this.conf, this, this.fs);
            this.hdfsMonitor.start();
        }
    }

    JobTracker(JobConf conf, String identifier, Clock clock, QueueManager qm) throws IOException, InterruptedException {
        this.initJTConf(conf);
        this.queueManager = qm;
        this.clock = clock;
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        UserGroupInformation.setConfiguration(conf);
        SecurityUtil.login(conf, JT_KEYTAB_FILE, JT_USER_NAME, this.localMachine);
        long secretKeyInterval = conf.getLong(DELEGATION_KEY_UPDATE_INTERVAL_KEY, 86400000L);
        long tokenMaxLifetime = conf.getLong(DELEGATION_TOKEN_MAX_LIFETIME_KEY, 604800000L);
        long tokenRenewInterval = conf.getLong(DELEGATION_TOKEN_RENEW_INTERVAL_KEY, 86400000L);
        this.secretManager = new DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
        this.secretManager.startThreads();
        this.MAX_JOBCONF_SIZE = conf.getLong(MAX_USER_JOBCONF_SIZE_KEY, this.MAX_JOBCONF_SIZE);
        TASKTRACKER_EXPIRY_INTERVAL = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        RETIRE_JOB_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.interval", 86400000L);
        RETIRE_JOB_CHECK_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.check", 60000L);
        this.retiredJobsCacheSize = conf.getInt("mapred.job.tracker.retiredjobs.cache.size", 1000);
        this.MAX_COMPLETE_USER_JOBS_IN_MEMORY = conf.getInt("mapred.jobtracker.completeuserjobs.maximum", 100);
        this.TRACKER_FAULT_TIMEOUT_WINDOW = conf.getInt("mapred.jobtracker.blacklist.fault-timeout-window", 180);
        this.TRACKER_FAULT_BUCKET_WIDTH = conf.getInt("mapred.jobtracker.blacklist.fault-bucket-width", 15);
        this.TRACKER_FAULT_THRESHOLD = conf.getInt("mapred.max.tracker.blacklists", 4);
        if (this.TRACKER_FAULT_BUCKET_WIDTH > this.TRACKER_FAULT_TIMEOUT_WINDOW) {
            this.TRACKER_FAULT_BUCKET_WIDTH = this.TRACKER_FAULT_TIMEOUT_WINDOW;
        }
        this.TRACKER_FAULT_BUCKET_WIDTH_MSECS = (long)this.TRACKER_FAULT_BUCKET_WIDTH * 60L * 1000L;
        this.NUM_FAULT_BUCKETS = (this.TRACKER_FAULT_TIMEOUT_WINDOW + this.TRACKER_FAULT_BUCKET_WIDTH - 1) / this.TRACKER_FAULT_BUCKET_WIDTH;
        this.NUM_HEARTBEATS_IN_SECOND = conf.getInt(JT_HEARTBEATS_IN_SECOND, 100);
        if (this.NUM_HEARTBEATS_IN_SECOND < 1) {
            this.NUM_HEARTBEATS_IN_SECOND = 100;
        }
        this.HEARTBEATS_SCALING_FACTOR = conf.getFloat(JT_HEARTBEATS_SCALING_FACTOR, 1.0f);
        if (this.HEARTBEATS_SCALING_FACTOR < 0.01f) {
            this.HEARTBEATS_SCALING_FACTOR = 1.0f;
        }
        this.AVERAGE_BLACKLIST_THRESHOLD = conf.getFloat("mapred.cluster.average.blacklist.threshold", 0.5f);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.initializeTaskMemoryRelatedConfig();
        this.hostsReader = new HostsFileReader(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        this.aclsManager = new ACLsManager(conf, new JobACLsManager(conf), this.queueManager);
        LOG.info("Starting jobtracker with owner as " + this.getMROwner().getShortUserName());
        this.clusterMap = ReflectionUtils.newInstance(conf.getClass("net.topology.impl", NetworkTopology.class, NetworkTopology.class), conf);
        Class<TaskScheduler> schedulerClass = conf.getClass("mapred.jobtracker.taskScheduler", JobQueueTaskScheduler.class, TaskScheduler.class);
        this.taskScheduler = ReflectionUtils.newInstance(schedulerClass, conf);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            PolicyProvider policyProvider = ReflectionUtils.newInstance(conf.getClass("hadoop.security.authorization.policyprovider", MapReducePolicyProvider.class, PolicyProvider.class), conf);
            ServiceAuthorizationManager.refresh(conf, policyProvider);
        }
        int handlerCount = conf.getInt("mapred.job.tracker.handler.count", 10);
        this.interTrackerServer = RPC.getServer(this, addr.getHostName(), addr.getPort(), handlerCount, false, conf, this.secretManager);
        if (LOG.isDebugEnabled()) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                LOG.debug("Property '" + string + "' is " + val);
            }
        }
        String infoAddr = NetUtils.getServerAddress(conf, "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.job.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String string = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.startTime = clock.getTime();
        this.infoServer = new HttpServer("job", string, tmpInfoPort, tmpInfoPort == 0, (Configuration)conf, this.aclsManager.getAdminsAcl());
        this.infoServer.setAttribute("job.tracker", this);
        this.infoServer.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.infoServer.start();
        this.trackerIdentifier = identifier;
        this.createInstrumentation();
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapred.job.tracker", this.localMachine + ":" + this.port);
        this.localFs = FileSystem.getLocal(conf);
        LOG.info("JobTracker up at: " + this.port);
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapred.job.tracker.http.address", string + ":" + this.infoPort);
        LOG.info("JobTracker webserver: " + this.infoServer.getPort());
        this.dnsToSwitchMapping = ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        this.numTaskCacheLevels = conf.getInt("mapred.task.cache.levels", 2);
        this.isNodeGroupAware = conf.getBoolean("mapred.jobtracker.nodegroup.aware", false);
        this.plugins = conf.getInstances("mapreduce.jobtracker.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start(this);
                LOG.info("Started plug-in " + p + " of type " + p.getClass());
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin " + p + " of type " + p.getClass() + " could not be started", t);
            }
        }
        this.initDone.set(conf.getBoolean(JT_INIT_CONFIG_KEY_FOR_TESTS, true));
    }

    private static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmm");
    }

    private static String generateNewIdentifier() {
        return JobTracker.getDateFormat().format(new Date());
    }

    static boolean validateIdentifier(String id) {
        try {
            JobTracker.getDateFormat().parse(id);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    static boolean validateJobNumber(String id) {
        try {
            Integer.parseInt(id);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean hasRestarted() {
        return this.hasRestarted;
    }

    public boolean hasRecovered() {
        return this.hasRecovered;
    }

    public long getRecoveryDuration() {
        return this.hasRestarted() ? this.recoveryDuration : 0L;
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    LocalFileSystem getLocalFileSystem() throws IOException {
        return this.localFs;
    }

    static Class<? extends JobTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapred.jobtracker.instrumentation", null, JobTrackerInstrumentation.class);
    }

    static void setInstrumentationClass(Configuration conf, Class<? extends JobTrackerInstrumentation> t) {
        conf.setClass("mapred.jobtracker.instrumentation", t, JobTrackerInstrumentation.class);
    }

    JobTrackerInstrumentation getInstrumentation() {
        return this.myInstrumentation;
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr(jobTrackerStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws InterruptedException, IOException {
        this.interTrackerServer.start();
        this.setSafeModeInternal(SafeModeAction.SAFEMODE_ENTER);
        this.initializeFilesystem();
        this.setSafeModeInternal(SafeModeAction.SAFEMODE_LEAVE);
        this.initialize();
        while (true) {
            try {
                this.recoveryManager.updateRestartCount();
            }
            catch (IOException ioe) {
                LOG.warn("Failed to initialize recovery manager. ", ioe);
                Thread.sleep(1000L);
                LOG.warn("Retrying...");
                continue;
            }
            break;
        }
        this.taskScheduler.start();
        try {
            this.recoveryManager.recover();
        }
        catch (Throwable t) {
            LOG.warn("Recovery manager crashed! Ignoring.", t);
        }
        this.refreshHosts();
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
        this.retireJobsThread = new Thread((Runnable)this.retireJobs, "retireJobs");
        this.retireJobsThread.start();
        this.expireLaunchingTaskThread.start();
        if (this.completedJobStatusStore.isActive()) {
            this.completedJobsStoreThread = new Thread((Runnable)this.completedJobStatusStore, "completedjobsStore-housekeeper");
            this.completedJobsStoreThread.start();
        }
        this.waitForInit();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            this.state = State.RUNNING;
        }
        LOG.info("Starting RUNNING");
        this.interTrackerServer.join();
        LOG.info("Stopped interTrackerServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInit() {
        Object object = this.initDoneLock;
        synchronized (object) {
            while (!this.initDone.get()) {
                try {
                    LOG.debug("About to wait since initDone = false");
                    this.initDoneLock.wait();
                }
                catch (InterruptedException ie) {
                    LOG.debug("Ignoring ", ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitDone(boolean done) {
        Object object = this.initDoneLock;
        synchronized (object) {
            this.initDone.set(done);
            this.initDoneLock.notify();
        }
    }

    void close() throws IOException {
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                    LOG.info("Stopped plug-in " + p + " of type " + p.getClass());
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin " + p + " of type " + p.getClass() + " could not be stopped", t);
                }
            }
        }
        if (this.infoServer != null) {
            LOG.info("Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                LOG.warn("Exception shutting down JobTracker", ex);
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info("Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        if (this.expireTrackersThread != null && this.expireTrackersThread.isAlive()) {
            LOG.info("Stopping expireTrackers");
            this.expireTrackersThread.interrupt();
            try {
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.retireJobsThread != null && this.retireJobsThread.isAlive()) {
            LOG.info("Stopping retirer");
            this.retireJobsThread.interrupt();
            try {
                this.retireJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.taskScheduler != null) {
            this.taskScheduler.terminate();
        }
        if (this.expireLaunchingTaskThread != null && this.expireLaunchingTaskThread.isAlive()) {
            LOG.info("Stopping expireLaunchingTasks");
            this.expireLaunchingTaskThread.interrupt();
            try {
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.completedJobsStoreThread != null && this.completedJobsStoreThread.isAlive()) {
            LOG.info("Stopping completedJobsStore thread");
            this.completedJobsStoreThread.interrupt();
            try {
                this.completedJobsStoreThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.jobHistoryServer != null) {
            LOG.info("Stopping job history server");
            try {
                this.jobHistoryServer.shutdown();
            }
            catch (Exception ex) {
                LOG.warn("Exception shutting down Job History server", ex);
            }
        }
        DelegationTokenRenewal.close();
        LOG.info("stopped all jobtracker services");
    }

    void createTaskEntry(TaskAttemptID taskid, String taskTracker, TaskInProgress tip) {
        LOG.info("Adding task (" + (Object)((Object)tip.getAttemptType(taskid)) + ") " + "'" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'");
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<TaskAttemptID> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(TaskAttemptID taskid) {
        Set<TaskAttemptID> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        if (this.taskidToTIPMap.remove(taskid) != null) {
            LOG.info("Removing task '" + taskid + "'");
        }
    }

    void markCompletedTaskAttempt(String taskTracker, TaskAttemptID taskid) {
        Set<TaskAttemptID> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Marked '" + taskid + "' from '" + taskTracker + "'");
        }
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getTasks(TaskType.JOB_SETUP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.MAP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.REDUCE)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
    }

    private void removeMarkedTasks(String taskTracker) {
        Set<TaskAttemptID> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (TaskAttemptID taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Removed marked completed task '" + taskid + "' from '" + taskTracker + "'");
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    synchronized void removeJobTasks(JobInProgress job) {
        for (TaskType type : TaskType.values()) {
            for (TaskInProgress tip : job.getTasks(type)) {
                for (TaskAttemptID id : tip.getAllTaskAttemptIDs()) {
                    this.removeTaskEntry(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        JobID id = job.getStatus().getJobID();
        if (job.hasRestarted()) {
            try {
                JobHistory.JobInfo.finalizeRecovery(id, job.getJobConf());
            }
            catch (IOException ioe) {
                LOG.info("Failed to finalize the log file recovery for job " + id, ioe);
            }
        }
        try {
            JobHistory.JobInfo.markCompleted(id);
        }
        catch (IOException ioe) {
            LOG.info("Failed to mark job " + id + " as completed!", ioe);
        }
        JobTrackerInstrumentation metrics = this.getInstrumentation();
        metrics.finalizeJob(this.conf, id);
        long now = this.clock.getTime();
        this.addJobForCleanup(id);
        if (job.getStatus().getRunState() == 2 && job.getNoOfBlackListedTrackers() > 0) {
            for (String hostName : job.getBlackListedTrackers()) {
                this.faultyTrackers.incrementFaults(hostName);
            }
        }
        String jobUser = job.getProfile().getUser();
        TreeMap<String, ArrayList<JobInProgress>> treeMap = this.userToJobsMap;
        synchronized (treeMap) {
            ArrayList<JobInProgress> userJobs = this.userToJobsMap.get(jobUser);
            if (userJobs == null) {
                userJobs = new ArrayList();
                this.userToJobsMap.put(jobUser, userJobs);
            }
            userJobs.add(job);
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public String getTrackerIdentifier() {
        return this.trackerIdentifier;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 3 && status.getRunState() != 5) continue;
            v.add(jip);
        }
        return v;
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 2) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<TaskTrackerStatus> taskTrackers() {
        ArrayList<TaskTrackerStatus> ttStatuses;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            ttStatuses = new ArrayList<TaskTrackerStatus>(this.taskTrackers.values().size());
            for (TaskTracker tt : this.taskTrackers.values()) {
                ttStatuses.add(tt.getStatus());
            }
        }
        return ttStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<TaskTrackerStatus> activeTaskTrackers() {
        ArrayList<TaskTrackerStatus> activeTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                activeTrackers.add(status);
            }
        }
        return activeTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<List<String>> taskTrackerNames() {
        ArrayList<String> activeTrackers = new ArrayList<String>();
        ArrayList<String> blacklistedTrackers = new ArrayList<String>();
        ArrayList<String> graylistedTrackers = new ArrayList<String>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                String hostName = status.getHost();
                String trackerName = status.getTrackerName();
                if (!this.faultyTrackers.isBlacklisted(hostName)) {
                    activeTrackers.add(trackerName);
                } else {
                    blacklistedTrackers.add(trackerName);
                }
                if (!this.faultyTrackers.isGraylisted(hostName)) continue;
                graylistedTrackers.add(trackerName);
            }
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(3);
        result.add(activeTrackers);
        result.add(blacklistedTrackers);
        result.add(graylistedTrackers);
        return result;
    }

    public Collection<TaskTrackerStatus> blacklistedTaskTrackers() {
        return this.blackOrGraylistedTaskTrackers(false);
    }

    public Collection<TaskTrackerStatus> graylistedTaskTrackers() {
        return this.blackOrGraylistedTaskTrackers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<TaskTrackerStatus> blackOrGraylistedTaskTrackers(boolean gray) {
        ArrayList<TaskTrackerStatus> listedTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                boolean listed = gray ? this.faultyTrackers.isGraylisted(status.getHost()) : this.faultyTrackers.isBlacklisted(status.getHost());
                if (!listed) continue;
                listedTrackers.add(status);
            }
        }
        return listedTrackers;
    }

    synchronized int getFaultCount(String hostName) {
        return this.faultyTrackers.getFaultCount(hostName);
    }

    int getBlacklistedTrackerCount() {
        return this.faultyTrackers.numBlacklistedTrackers;
    }

    int getGraylistedTrackerCount() {
        return this.faultyTrackers.numGraylistedTrackers;
    }

    public synchronized boolean isBlacklisted(String trackerID) {
        TaskTrackerStatus status = this.getTaskTrackerStatus(trackerID);
        if (status != null) {
            return this.faultyTrackers.isBlacklisted(status.getHost());
        }
        return false;
    }

    public synchronized boolean isGraylisted(String trackerID) {
        TaskTrackerStatus status = this.getTaskTrackerStatus(trackerID);
        if (status != null) {
            return this.faultyTrackers.isGraylisted(status.getHost());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTrackerStatus getTaskTrackerStatus(String trackerID) {
        TaskTracker taskTracker;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            taskTracker = this.taskTrackers.get(trackerID);
        }
        return taskTracker == null ? null : taskTracker.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTracker getTaskTracker(String trackerID) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    JobTrackerStatistics getStatistics() {
        return this.statistics;
    }

    private void addNewTracker(TaskTracker taskTracker) throws UnknownHostException {
        Set<TaskTracker> trackers;
        TaskTrackerStatus status = taskTracker.getStatus();
        this.trackerExpiryQueue.add(status);
        String hostname = status.getHost();
        if (this.getNode(status.getTrackerName()) == null) {
            this.resolveAndAddToTopology(hostname);
        }
        if ((trackers = this.hostnameToTaskTracker.get(hostname)) == null) {
            trackers = Collections.synchronizedSet(new HashSet());
            this.hostnameToTaskTracker.put(hostname, trackers);
        }
        this.statistics.taskTrackerAdded(status.getTrackerName());
        this.getInstrumentation().addTrackers(1);
        LOG.info("Adding tracker " + status.getTrackerName() + " to host " + hostname);
        trackers.add(taskTracker);
    }

    public Node resolveAndAddToTopology(String name) throws UnknownHostException {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(name);
        List<String> rNameList = this.dnsToSwitchMapping.resolve(tmpList);
        String rName = rNameList.get(0);
        String networkLoc = NodeBase.normalize(rName);
        return this.addHostToNodeMapping(name, networkLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node addHostToNodeMapping(String host, String networkLoc) {
        Node node = null;
        Set<Node> set = this.nodesAtMaxLevel;
        synchronized (set) {
            node = this.clusterMap.getNode(networkLoc + "/" + host);
            if (node == null) {
                node = new NodeBase(host, networkLoc);
                this.clusterMap.add(node);
                if (node.getLevel() < this.getNumTaskCacheLevels()) {
                    LOG.fatal("Got a host whose level is: " + node.getLevel() + "." + " Should get at least a level of value: " + this.getNumTaskCacheLevels());
                    try {
                        this.stopTracker();
                    }
                    catch (IOException ie) {
                        LOG.warn("Exception encountered during shutdown: " + StringUtils.stringifyException(ie));
                        System.exit(-1);
                    }
                }
                this.hostnameToNodeMap.put(host, node);
                this.nodesAtMaxLevel.add(JobTracker.getParentNode(node, this.getNumTaskCacheLevels() - 1));
            }
        }
        return node;
    }

    public Collection<Node> getNodesAtMaxLevel() {
        return this.nodesAtMaxLevel;
    }

    public static Node getParentNode(Node node, int level) {
        for (int i = 0; i < level; ++i) {
            node = node.getParent();
        }
        return node;
    }

    public Node getNode(String name) {
        return this.hostnameToNodeMap.get(name);
    }

    public int getNumTaskCacheLevels() {
        return this.numTaskCacheLevels;
    }

    public int getNumResolvedTaskTrackers() {
        return this.numResolved;
    }

    @Override
    public int getNumberOfUniqueHosts() {
        return this.uniqueHostsMap.size();
    }

    public boolean isNodeGroupAware() {
        return this.isNodeGroupAware;
    }

    @Override
    public void addJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.add(listener);
    }

    @Override
    public void removeJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.remove(listener);
    }

    private void updateJobInProgressListeners(JobChangeEvent event) {
        for (JobInProgressListener listener : this.jobInProgressListeners) {
            listener.jobUpdated(event);
        }
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public String getVIVersion() throws IOException {
        return VersionInfo.getVersion();
    }

    @Override
    public String getBuildVersion() throws IOException {
        return VersionInfo.getBuildVersion();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean restarted, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> commitTasksList;
        List<TaskTrackerAction> killJobsList;
        List<TaskTrackerAction> killTasksList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got heartbeat from: " + status.getTrackerName() + " (restarted: " + restarted + " initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId);
        }
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        long now = this.clock.getTime();
        if (restarted) {
            this.faultyTrackers.markTrackerHealthy(status.getHost());
        } else {
            this.faultyTrackers.checkTrackerFaultTimeout(status.getHost(), now);
        }
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        boolean addRestartInfo = false;
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                if (!this.hasRestarted()) {
                    LOG.warn("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker");
                    return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
                }
                addRestartInfo = true;
                this.recoveryManager.unMarkTracker(trackerName);
            } else if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info("Ignoring 'duplicate' heartbeat from '" + trackerName + "'; resending the previous 'lost' response");
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        status.setLastSeen(now);
        if (!this.processHeartbeat(status, initialContact, now)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        boolean isBlacklisted = this.faultyTrackers.isBlacklisted(status.getHost());
        if (this.recoveryManager.shouldSchedule() && acceptNewTasks && !isBlacklisted) {
            TaskTrackerStatus taskTrackerStatus = this.getTaskTrackerStatus(trackerName);
            if (taskTrackerStatus == null) {
                LOG.warn("Unknown task tracker polling; ignoring: " + trackerName);
            } else {
                List<Task> tasks = this.getSetupAndCleanupTasks(taskTrackerStatus);
                if (tasks == null) {
                    tasks = this.taskScheduler.assignTasks(this.taskTrackers.get(trackerName));
                }
                if (tasks != null) {
                    for (Task task : tasks) {
                        this.expireLaunchingTasks.addNewTask(task.getTaskID());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(trackerName + " -> LaunchTask: " + task.getTaskID());
                        }
                        actions.add(new LaunchTaskAction(task));
                    }
                }
            }
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        if ((killJobsList = this.getJobsForCleanup(trackerName)) != null) {
            actions.addAll(killJobsList);
        }
        if ((commitTasksList = this.getTasksToSave(status)) != null) {
            actions.addAll(commitTasksList);
        }
        int nextInterval = this.getNextHeartbeatInterval();
        response.setHeartbeatInterval(nextInterval);
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        if (addRestartInfo) {
            response.setRecoveredJobs(this.recoveryManager.getJobsToRecover());
        }
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    @Override
    public int getNextHeartbeatInterval() {
        int clusterSize = this.getClusterStatus().getTaskTrackers();
        int heartbeatInterval = Math.max((int)((double)(1000.0f * this.HEARTBEATS_SCALING_FACTOR) * ((double)clusterSize / (double)this.NUM_HEARTBEATS_IN_SECOND)), 300);
        return heartbeatInterval;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    private boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        int reduceSlots2;
        int mapSlots;
        TaskTrackerStatus oldStatus;
        TaskTracker tt = this.getTaskTracker(trackerName);
        TaskTrackerStatus taskTrackerStatus = oldStatus = tt == null ? null : tt.getStatus();
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            this.occupiedMapSlots -= oldStatus.countOccupiedMapSlots();
            this.occupiedReduceSlots -= oldStatus.countOccupiedReduceSlots();
            this.getInstrumentation().decRunningMaps(oldStatus.countMapTasks());
            this.getInstrumentation().decRunningReduces(oldStatus.countReduceTasks());
            this.getInstrumentation().decOccupiedMapSlots(oldStatus.countOccupiedMapSlots());
            this.getInstrumentation().decOccupiedReduceSlots(oldStatus.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(oldStatus.getHost())) {
                mapSlots = oldStatus.getMaxMapSlots();
                this.totalMapTaskCapacity -= mapSlots;
                reduceSlots2 = oldStatus.getMaxReduceSlots();
                this.totalReduceTaskCapacity -= reduceSlots2;
            }
            if (status == null) {
                this.taskTrackers.remove(trackerName);
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(oldStatus.getHost());
                if (numTaskTrackersInHost != null) {
                    Integer reduceSlots2 = numTaskTrackersInHost;
                    Integer n = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost - 1);
                    if (numTaskTrackersInHost > 0) {
                        this.uniqueHostsMap.put(oldStatus.getHost(), numTaskTrackersInHost);
                    } else {
                        this.uniqueHostsMap.remove(oldStatus.getHost());
                    }
                }
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            this.occupiedMapSlots += status.countOccupiedMapSlots();
            this.occupiedReduceSlots += status.countOccupiedReduceSlots();
            this.getInstrumentation().addRunningMaps(status.countMapTasks());
            this.getInstrumentation().addRunningReduces(status.countReduceTasks());
            this.getInstrumentation().addOccupiedMapSlots(status.countOccupiedMapSlots());
            this.getInstrumentation().addOccupiedReduceSlots(status.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                mapSlots = status.getMaxMapSlots();
                this.totalMapTaskCapacity += mapSlots;
                reduceSlots2 = status.getMaxReduceSlots();
                this.totalReduceTaskCapacity += reduceSlots2;
            }
            boolean alreadyPresent = false;
            TaskTracker taskTracker = this.taskTrackers.get(trackerName);
            if (taskTracker != null) {
                alreadyPresent = true;
            } else {
                taskTracker = new TaskTracker(trackerName);
            }
            taskTracker.setStatus(status);
            this.taskTrackers.put(trackerName, taskTracker);
            if (LOG.isDebugEnabled()) {
                int runningMaps = 0;
                int runningReduces = 0;
                int commitPendingMaps = 0;
                int commitPendingReduces = 0;
                int unassignedMaps = 0;
                int unassignedReduces = 0;
                int miscMaps = 0;
                int miscReduces = 0;
                List<TaskStatus> taskReports = status.getTaskReports();
                for (TaskStatus ts : taskReports) {
                    boolean isMap = ts.getIsMap();
                    TaskStatus.State state = ts.getRunState();
                    if (state == TaskStatus.State.RUNNING) {
                        if (isMap) {
                            ++runningMaps;
                            continue;
                        }
                        ++runningReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.UNASSIGNED) {
                        if (isMap) {
                            ++unassignedMaps;
                            continue;
                        }
                        ++unassignedReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.COMMIT_PENDING) {
                        if (isMap) {
                            ++commitPendingMaps;
                            continue;
                        }
                        ++commitPendingReduces;
                        continue;
                    }
                    if (isMap) {
                        ++miscMaps;
                        continue;
                    }
                    ++miscReduces;
                }
                LOG.debug(trackerName + ": Status -" + " running(m) = " + runningMaps + " unassigned(m) = " + unassignedMaps + " commit_pending(m) = " + commitPendingMaps + " misc(m) = " + miscMaps + " running(r) = " + runningReduces + " unassigned(r) = " + unassignedReduces + " commit_pending(r) = " + commitPendingReduces + " misc(r) = " + miscReduces);
            }
            if (!alreadyPresent) {
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(status.getHost());
                if (numTaskTrackersInHost == null) {
                    numTaskTrackersInHost = 0;
                }
                Integer n = numTaskTrackersInHost;
                Integer n2 = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost + 1);
                this.uniqueHostsMap.put(status.getHost(), numTaskTrackersInHost);
            }
        }
        this.getInstrumentation().setMapSlots(this.totalMapTaskCapacity);
        this.getInstrumentation().setReduceSlots(this.totalReduceTaskCapacity);
        return oldStatus != null;
    }

    void incrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots += reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots += reservedSlots;
        }
    }

    void decrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots -= reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots -= reservedSlots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeHealthStatus(TaskTrackerStatus trackerStatus, long timeStamp) {
        TaskTrackerStatus.TaskTrackerHealthStatus status = trackerStatus.getHealthStatus();
        FaultyTrackersInfo faultyTrackersInfo = this.faultyTrackers;
        synchronized (faultyTrackersInfo) {
            this.faultyTrackers.setNodeHealthStatus(trackerStatus.getHost(), status.isNodeHealthy(), status.getHealthReport(), timeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact, long timeStamp) throws UnknownHostException {
        this.getInstrumentation().heartbeat();
        String trackerName = trackerStatus.getTrackerName();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                TaskTracker taskTracker = this.getTaskTracker(trackerName);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(taskTracker);
                    }
                } else if (!seenBefore) {
                    LOG.warn("Status from unknown Tracker : " + trackerName);
                    this.updateTaskTrackerStatus(trackerName, null);
                    return false;
                }
                if (initialContact) {
                    if (this.isBlacklisted(trackerName)) {
                        this.faultyTrackers.incrBlacklistedTrackers(1);
                    }
                    this.addNewTracker(taskTracker);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        this.updateNodeHealthStatus(trackerStatus, timeStamp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<TaskAttemptID> taskIds = this.trackerToTaskMap.get(taskTracker);
        ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
        if (taskIds != null) {
            for (TaskAttemptID killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (tip == null || !tip.shouldClose(killTaskId) || tip.getJob().isComplete()) continue;
                killList.add(new KillTaskAction(killTaskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(taskTracker + " -> KillTaskAction: " + killTaskId);
            }
        }
        Map<String, Set<TaskAttemptID>> map = this.trackerToTasksToCleanup;
        synchronized (map) {
            Set<TaskAttemptID> set = this.trackerToTasksToCleanup.remove(taskTracker);
            if (set != null) {
                for (TaskAttemptID id : set) {
                    killList.add(new KillTaskAction(id));
                }
            }
        }
        return killList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJobForCleanup(JobID id) {
        for (String taskTracker : this.taskTrackers.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Marking job " + id + " for cleanup by tracker " + taskTracker);
            }
            Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
            synchronized (map) {
                Set<JobID> jobsToKill = this.trackerToJobsToCleanup.get(taskTracker);
                if (jobsToKill == null) {
                    jobsToKill = new HashSet<JobID>();
                    this.trackerToJobsToCleanup.put(taskTracker, jobsToKill);
                }
                jobsToKill.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerAction> getJobsForCleanup(String taskTracker) {
        Set<JobID> jobs = null;
        Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            jobs = this.trackerToJobsToCleanup.remove(taskTracker);
        }
        if (jobs != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            for (JobID killJobId : jobs) {
                killList.add(new KillJobAction(killJobId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(taskTracker + " -> KillJobAction: " + killJobId);
            }
            return killList;
        }
        return null;
    }

    private synchronized List<TaskTrackerAction> getTasksToSave(TaskTrackerStatus tts) {
        List<TaskStatus> taskStatuses = tts.getTaskReports();
        if (taskStatuses != null) {
            ArrayList<TaskTrackerAction> saveList = new ArrayList<TaskTrackerAction>();
            for (TaskStatus taskStatus : taskStatuses) {
                TaskAttemptID taskId;
                TaskInProgress tip;
                if (taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING || (tip = this.taskidToTIPMap.get(taskId = taskStatus.getTaskID())) == null || !tip.shouldCommit(taskId)) continue;
                saveList.add(new CommitTaskAction(taskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(tts.getTrackerName() + " -> CommitTaskAction: " + taskId);
            }
            return saveList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<Task> getSetupAndCleanupTasks(TaskTrackerStatus taskTracker) throws IOException {
        if (this.isInSafeMode()) {
            return null;
        }
        int maxMapTasks = taskTracker.getMaxMapSlots();
        int maxReduceTasks = taskTracker.getMaxReduceSlots();
        int numMaps = taskTracker.countOccupiedMapSlots();
        int numReduces = taskTracker.countOccupiedReduceSlots();
        int numTaskTrackers = this.getClusterStatus().getTaskTrackers();
        int numUniqueHosts = this.getNumberOfUniqueHosts();
        Task t = null;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            if (numMaps < maxMapTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
            if (numReduces < maxReduceTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        if (this.fs == null) {
            throw new IllegalStateException("FileSystem object not available yet");
        }
        return this.fs.getUri().toString();
    }

    public JobConf getConf() {
        return this.conf;
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn("Report from " + taskTracker + ": " + errorMessage);
    }

    static String getJobUniqueString(String jobid) {
        return jobid.substring(4);
    }

    @Override
    public synchronized JobID getNewJobId() throws IOException {
        this.checkJobTrackerState();
        return new JobID(this.getTrackerIdentifier(), this.nextJobId++);
    }

    @Override
    public JobStatus submitJob(JobID jobId, String jobSubmitDir, Credentials ts) throws IOException {
        this.checkJobTrackerState();
        return this.submitJob(jobId, jobSubmitDir, null, ts, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobStatus submitJob(JobID jobId, String jobSubmitDir, UserGroupInformation ugi, Credentials ts, boolean recovered) throws IOException {
        this.checkSafeMode();
        JobInfo jobInfo = null;
        if (ugi == null) {
            ugi = UserGroupInformation.getCurrentUser();
        }
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            if (this.jobs.containsKey(jobId)) {
                return this.jobs.get(jobId).getStatus();
            }
            jobInfo = new JobInfo(jobId, new Text(ugi.getShortUserName()), new Path(jobSubmitDir));
        }
        if (!recovered) {
            Path jobDir = this.getSystemDirectoryForJob(jobId);
            FileSystem.mkdirs(this.fs, jobDir, new FsPermission(SYSTEM_DIR_PERMISSION));
            FSDataOutputStream out = this.fs.create(this.getSystemFileForJob(jobId));
            jobInfo.write(out);
            out.close();
        }
        JobInProgress job = null;
        try {
            if (ts == null) {
                ts = new Credentials();
            }
            this.generateAndStoreJobTokens(jobId, ts);
            job = new JobInProgress(this, this.conf, jobInfo, 0, ts);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (recovered && !job.getJobConf().getBoolean("mapreduce.job.restart.recover", true)) {
            LOG.info("Job " + jobId.toString() + " is not enable for recovery, cleaning up job files");
            job.cleanupJob();
            return null;
        }
        JobTracker jobTracker2 = this;
        synchronized (jobTracker2) {
            JobStatus status2;
            String queue = job.getProfile().getQueueName();
            if (!this.queueManager.isRunning(queue)) {
                throw new IOException("Queue \"" + queue + "\" is not running");
            }
            try {
                this.aclsManager.checkAccess(job, ugi, Operation.SUBMIT_JOB);
            }
            catch (IOException ioe) {
                LOG.warn("Access denied for user " + job.getJobConf().getUser() + ". Ignoring job " + jobId, ioe);
                job.fail();
                throw ioe;
            }
            this.checkMemoryRequirements(job);
            try {
                this.taskScheduler.checkJobSubmission(job);
            }
            catch (IOException ioe) {
                LOG.error("Problem in submitting job " + jobId, ioe);
                throw ioe;
            }
            try {
                status2 = this.addJob(jobId, job);
            }
            catch (IOException ioe) {
                LOG.info("Job " + jobId + " submission failed!", ioe);
                JobStatus status2 = job.getStatus();
                status2.setFailureInfo(StringUtils.stringifyException(ioe));
                this.failJob(job);
                throw ioe;
            }
            return status2;
        }
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        this.checkSafeMode();
        try {
            final String user = UserGroupInformation.getCurrentUser().getShortUserName();
            return this.getMROwner().doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return JobTracker.this.getStagingAreaDirInternal(user);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private String getStagingAreaDirInternal(String user) throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        FileSystem fs = stagingRootDir.getFileSystem(this.conf);
        return fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JobStatus addJob(JobID jobId, JobInProgress job) throws IOException {
        ++this.totalSubmissions;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                this.jobs.put(job.getProfile().getJobID(), job);
                for (JobInProgressListener listener : this.jobInProgressListeners) {
                    listener.jobAdded(job);
                }
            }
        }
        this.myInstrumentation.submitJob(job.getJobConf(), jobId);
        job.getQueueMetrics().submitJob(job.getJobConf(), jobId);
        LOG.info("Job " + jobId + " added successfully for user '" + job.getJobConf().getUser() + "' to queue '" + job.getJobConf().getQueueName() + "'");
        AuditLogger.logSuccess(job.getUser(), Operation.SUBMIT_JOB.name(), jobId.toString());
        return job.getStatus();
    }

    boolean areACLsEnabled() {
        return this.conf.getBoolean("mapred.acls.enabled", false);
    }

    @Override
    @Deprecated
    public synchronized ClusterStatus getClusterStatus() {
        return this.getClusterStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClusterStatus getClusterStatus(boolean detailed) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            if (detailed) {
                List<List<String>> trackerNames = this.taskTrackerNames();
                return new ClusterStatus((Collection<String>)trackerNames.get(0), (Collection<String>)trackerNames.get(1), (Collection<String>)trackerNames.get(2), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
            }
            return new ClusterStatus(this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), this.getGraylistedTrackerCount(), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
        }
    }

    public synchronized ClusterMetrics getClusterMetrics() {
        return new ClusterMetrics(this.totalMaps, this.totalReduces, this.occupiedMapSlots, this.occupiedReduceSlots, this.reservedMapSlots, this.reservedReduceSlots, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.totalSubmissions, this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), this.getGraylistedTrackerCount(), this.getExcludedNodes().size());
    }

    @Override
    public synchronized void killJob(JobID jobid) throws IOException {
        if (null == jobid) {
            LOG.info("Null jobid object sent to JobTracker.killJob()");
            return;
        }
        this.checkJobTrackerState();
        this.checkSafeMode();
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info("killJob(): JobId " + jobid.toString() + " is not a valid job");
            return;
        }
        this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.KILL_JOB);
        this.killJob(job);
    }

    private synchronized void killJob(JobInProgress job) {
        LOG.info("Killing job " + job.getJobID());
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        job.kill();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState() && newStatus.getRunState() == 5) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        this.secretManager.cancelToken(token, user);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos authentication");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Text owner = new Text(ugi.getUserName());
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier(owner, renewer, realUser);
        return new Token<DelegationTokenIdentifier>(ident, this.secretManager);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos authentication");
        }
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        return this.secretManager.renewToken(token, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initJob(JobInProgress job) {
        block7: {
            if (null == job) {
                LOG.info("Init on null job is not valid");
                return;
            }
            try {
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                LOG.info("Initializing " + job.getJobID());
                job.initTasks();
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() == newStatus.getRunState()) break block7;
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                JobTracker jobTracker = this;
                synchronized (jobTracker) {
                    this.updateJobInProgressListeners(event);
                }
            }
            catch (JobInProgress.KillInterruptedException kie) {
                LOG.error("Job initialization interrupted:\n" + StringUtils.stringifyException(kie));
                this.killJob(job);
            }
            catch (Throwable t) {
                String failureInfo = "Job initialization failed:\n" + StringUtils.stringifyException(t);
                LOG.error(failureInfo);
                job.getStatus().setFailureInfo(failureInfo);
                this.failJob(job);
            }
        }
    }

    @Override
    public synchronized void failJob(JobInProgress job) {
        if (null == job) {
            LOG.info("Fail on null job is not valid");
            return;
        }
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        LOG.info("Failing job " + job.getJobID());
        job.fail();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState()) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public synchronized void setJobPriority(JobID jobid, String priority) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info("setJobPriority(): JobId " + jobid.toString() + " is not a valid job");
            return;
        }
        JobPriority newPriority = JobPriority.valueOf(priority);
        this.setJobPriority(jobid, newPriority);
    }

    void storeCompletedJob(JobInProgress job) {
        this.completedJobStatusStore.store(job);
    }

    private boolean isJobInited(JobInProgress job) {
        return job.inited();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobProfile getJobProfile(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getProfile();
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.profile;
            }
        }
        return this.completedJobStatusStore.readJobProfile(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        if (null == jobid) {
            LOG.warn("JobTracker.getJobStatus() cannot get status for null jobid");
            return null;
        }
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getStatus();
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.status;
            }
        }
        return this.completedJobStatusStore.readJobStatus(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getJobCounters(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                this.aclsManager.checkAccess(job, callerUGI, Operation.VIEW_JOB_COUNTERS);
                Counters counters = new Counters();
                if (this.isJobInited(job)) {
                    boolean isFine = job.getCounters(counters);
                    if (!isFine) {
                        throw new IOException("Counters Exceeded limit: " + Counters.MAX_COUNTER_LIMIT);
                    }
                    return counters;
                }
                return EMPTY_COUNTERS;
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.counters;
            }
        }
        return this.completedJobStatusStore.readCounters(jobid);
    }

    @Override
    public synchronized TaskReport[] getMapTaskReports(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getReduceTaskReports(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getCleanupTaskReports(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportCleanupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportCleanupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getSetupTaskReports(JobID jobid) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportSetupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportSetupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        this.checkJobTrackerState();
        JobInProgress job = this.jobs.get(jobid);
        if (null != job) {
            return this.isJobInited(job) ? job.getTaskCompletionEvents(fromEventId, maxEvents) : TaskCompletionEvent.EMPTY_ARRAY;
        }
        return this.completedJobStatusStore.readJobTaskCompletionEvents(jobid, fromEventId, maxEvents);
    }

    @Override
    public synchronized String[] getTaskDiagnostics(TaskAttemptID taskId) throws IOException {
        TaskInProgress tip;
        this.checkJobTrackerState();
        List<String> taskDiagnosticInfo = null;
        JobID jobId = taskId.getJobID();
        TaskID tipId = taskId.getTaskID();
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job != null && this.isJobInited(job) && (tip = job.getTaskInProgress(tipId)) != null) {
            taskDiagnosticInfo = tip.getDiagnosticInfo(taskId);
        }
        return taskDiagnosticInfo == null ? EMPTY_TASK_DIAGNOSTICS : taskDiagnosticInfo.toArray(new String[taskDiagnosticInfo.size()]);
    }

    TaskStatus[] getTaskStatuses(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(TaskAttemptID taskid) {
        TaskInProgress tip = this.getTip(taskid.getTaskID());
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    Counters getTipCounters(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? null : tip.getCounters();
    }

    TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public TaskInProgress getTip(TaskID tipid) {
        JobInProgress job = this.jobs.get(tipid.getJobID());
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    @Override
    public synchronized boolean killTask(TaskAttemptID taskid, boolean shouldFail) throws IOException {
        this.checkJobTrackerState();
        this.checkSafeMode();
        TaskInProgress tip = this.taskidToTIPMap.get(taskid);
        if (tip != null) {
            this.aclsManager.checkAccess(tip.getJob(), UserGroupInformation.getCurrentUser(), shouldFail ? Operation.FAIL_TASK : Operation.KILL_TASK);
            return tip.killTask(taskid, shouldFail);
        }
        LOG.info("Kill task attempt failed since task " + taskid + " was not found");
        return false;
    }

    public synchronized String getAssignedTracker(TaskAttemptID taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return this.getJobStatus(this.jobs.values(), true);
    }

    @Override
    public JobStatus[] getAllJobs() {
        ArrayList<JobStatus> list = new ArrayList<JobStatus>();
        list.addAll(Arrays.asList(this.getJobStatus(this.jobs.values(), false)));
        list.addAll(this.retireJobs.getAllJobStatus());
        return list.toArray(new JobStatus[list.size()]);
    }

    @Override
    public String getSystemDir() {
        if (this.isInSafeMode()) {
            return null;
        }
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        AccessControlList acl = this.queueManager.getQueueACL(queueName, QueueManager.QueueACL.ADMINISTER_JOBS);
        if (acl == null) {
            acl = new AccessControlList(" ");
        }
        return acl;
    }

    @Override
    public JobInProgress getJob(JobID jobid) {
        return this.jobs.get(jobid);
    }

    Path getSystemDirectoryForJob(JobID id) {
        return new Path(this.getSystemDir(), id.toString());
    }

    Path getSystemFileForJob(JobID id) {
        return new Path(this.getSystemDirectoryForJob(id), JOB_INFO_FILE);
    }

    Path getTokenFileForJob(JobID id) {
        return new Path(this.getSystemDirectoryForJob(id), "jobToken");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setJobPriority(JobID jobId, JobPriority priority) throws AccessControlException, IOException {
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.SET_JOB_PRIORITY);
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                JobStatus oldStatus = (JobStatus)job.getStatus().clone();
                job.setPriority(priority);
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.PRIORITY_CHANGED, oldStatus, newStatus);
                this.updateJobInProgressListeners(event);
            }
        } else {
            LOG.warn("Trying to change the priority of an unknown job: " + jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskStatuses(TaskTrackerStatus status) {
        String trackerName = status.getTrackerName();
        for (TaskStatus report : status.getTaskReports()) {
            List<TaskAttemptID> failedFetchMaps;
            Map<String, Set<ID>> map;
            JobInProgress job;
            report.setTaskTracker(trackerName);
            TaskAttemptID taskId = report.getTaskID();
            if (report.getRunState() != TaskStatus.State.UNASSIGNED) {
                this.expireLaunchingTasks.removeTask(taskId);
            }
            if ((job = this.getJob(taskId.getJobID())) == null) {
                map = this.trackerToJobsToCleanup;
                synchronized (map) {
                    Set<JobID> jobs = this.trackerToJobsToCleanup.get(trackerName);
                    if (jobs == null) {
                        jobs = new HashSet<JobID>();
                        this.trackerToJobsToCleanup.put(trackerName, jobs);
                    }
                    jobs.add(taskId.getJobID());
                    continue;
                }
            }
            if (!job.inited()) {
                map = this.trackerToTasksToCleanup;
                synchronized (map) {
                    Set<TaskAttemptID> tasks = this.trackerToTasksToCleanup.get(trackerName);
                    if (tasks == null) {
                        tasks = new HashSet<TaskAttemptID>();
                        this.trackerToTasksToCleanup.put(trackerName, tasks);
                    }
                    tasks.add(taskId);
                    continue;
                }
            }
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip != null || this.hasRestarted()) {
                if (tip == null) {
                    tip = job.getTaskInProgress(taskId.getTaskID());
                    job.addRunningTaskToTIP(tip, taskId, status, false);
                }
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                job.updateTaskStatus(tip, (TaskStatus)report.clone());
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() != newStatus.getRunState()) {
                    JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                    this.updateJobInProgressListeners(event);
                }
            } else {
                LOG.info("Serious problem.  While updating status, cannot find taskid " + report.getTaskID());
            }
            if ((failedFetchMaps = report.getFetchFailedMaps()) == null) continue;
            for (TaskAttemptID mapTaskId : failedFetchMaps) {
                TaskInProgress failedFetchMap = this.taskidToTIPMap.get(mapTaskId);
                if (failedFetchMap == null) continue;
                String failedFetchTrackerName = this.getAssignedTracker(mapTaskId);
                if (failedFetchTrackerName == null) {
                    failedFetchTrackerName = "Lost task tracker";
                }
                failedFetchMap.getJob().fetchFailureNotification(failedFetchMap, mapTaskId, failedFetchTrackerName, taskId, trackerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lostTaskTracker(TaskTracker taskTracker) {
        String trackerName = taskTracker.getTrackerName();
        LOG.info("Lost tracker '" + trackerName + "'");
        Map<String, Set<ID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            this.trackerToJobsToCleanup.remove(trackerName);
        }
        map = this.trackerToTasksToCleanup;
        synchronized (map) {
            this.trackerToTasksToCleanup.remove(trackerName);
        }
        this.recoveryManager.unMarkTracker(trackerName);
        Set<TaskAttemptID> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (TaskAttemptID taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                JobInProgress job = tip.getJob();
                if (!tip.isComplete() || tip.isMapTask() && !tip.isJobSetupTask() && job.desiredReduces() != 0) {
                    if (job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4) continue;
                    TaskStatus.State killState = tip.isRunningTask(taskId) && !tip.isJobSetupTask() && !tip.isJobCleanupTask() ? TaskStatus.State.KILLED_UNCLEAN : TaskStatus.State.KILLED;
                    job.failedTask(tip, taskId, "Lost task tracker: " + trackerName, tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, killState, trackerName);
                    jobsWithFailures.add(job);
                    continue;
                }
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName, taskTracker);
            }
            taskTracker.cancelAllReservations();
            this.removeMarkedTasks(trackerName);
        }
    }

    @Override
    public synchronized void refreshNodes() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.aclsManager.isMRAdmin(UserGroupInformation.getCurrentUser())) {
            AuditLogger.logFailure(user, "REFRESH_NODES", this.aclsManager.getAdminsAcl().toString(), "JobTracker", "Unauthorized user");
            throw new AccessControlException(user + " is not authorized to refresh nodes.");
        }
        AuditLogger.logSuccess(user, "REFRESH_NODES", "JobTracker");
        this.refreshHosts();
    }

    UserGroupInformation getMROwner() {
        return this.aclsManager.getMROwner();
    }

    private synchronized void refreshHosts() throws IOException {
        LOG.info("Refreshing hosts information");
        Configuration conf = new Configuration();
        this.hostsReader.updateFileNames(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        this.hostsReader.refresh();
        HashSet<String> excludeSet = new HashSet<String>();
        for (Map.Entry<String, TaskTracker> eSet : this.taskTrackers.entrySet()) {
            String trackerName = eSet.getKey();
            TaskTrackerStatus status = eSet.getValue().getStatus();
            if (this.inHostsList(status) && !this.inExcludedHostsList(status)) continue;
            excludeSet.add(status.getHost());
        }
        this.decommissionNodes(excludeSet);
    }

    private void removeTracker(TaskTracker tracker) {
        String trackerName = tracker.getTrackerName();
        String hostName = JobInProgress.convertTrackerNameToHostName(trackerName);
        this.lostTaskTracker(tracker);
        if (this.isBlacklisted(trackerName)) {
            LOG.info("Removing " + hostName + " from blacklist");
            this.faultyTrackers.decrBlacklistedTrackers(1);
        }
        if (this.isGraylisted(trackerName)) {
            LOG.info("Removing " + hostName + " from graylist");
            this.faultyTrackers.decrGraylistedTrackers(1);
        }
        this.updateTaskTrackerStatus(trackerName, null);
        this.statistics.taskTrackerRemoved(trackerName);
        this.getInstrumentation().decTrackers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decommissionNodes(Set<String> hosts) throws IOException {
        LOG.info("Decommissioning " + hosts.size() + " nodes");
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                int trackersDecommissioned = 0;
                for (String host : hosts) {
                    LOG.info("Decommissioning host " + host);
                    Set<TaskTracker> trackers = this.hostnameToTaskTracker.remove(host);
                    if (trackers != null) {
                        for (TaskTracker tracker : trackers) {
                            LOG.info("Decommission: Losing tracker " + tracker.getTrackerName() + " on host " + host);
                            this.removeTracker(tracker);
                        }
                        trackersDecommissioned += trackers.size();
                    }
                    LOG.info("Host " + host + " is ready for decommissioning");
                }
                this.getInstrumentation().setDecommissionedTrackers(trackersDecommissioned);
            }
        }
    }

    Collection<String> getExcludedNodes() {
        return this.hostsReader.getExcludedHosts();
    }

    public static String getLocalJobFilePath(JobID jobId) {
        return JobHistory.JobInfo.getLocalJobFilePath(jobId);
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        StringUtils.startupShutdownMessage(JobTracker.class, argv, LOG);
        try {
            if (argv.length == 0) {
                JobTracker tracker = JobTracker.startTracker(new JobConf());
                tracker.offerService();
            } else if ("-dumpConfiguration".equals(argv[0]) && argv.length == 1) {
                JobTracker.dumpConfiguration(new PrintWriter(System.out));
            } else {
                System.out.println("usage: JobTracker [-dumpConfiguration]");
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            LOG.fatal(StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    private static void dumpConfiguration(Writer writer) throws IOException {
        Configuration.dumpConfiguration(new JobConf(), writer);
        writer.write("\n");
        QueueManager.dumpConfiguration(writer);
        writer.write("\n");
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return this.queueManager.getJobQueueInfos();
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return this.queueManager.getJobQueueInfo(queue);
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        Collection<JobInProgress> jips = this.taskScheduler.getJobs(queue);
        return this.getJobStatus(jips, false);
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return this.queueManager.getQueueAcls(UserGroupInformation.getCurrentUser());
    }

    private synchronized JobStatus[] getJobStatus(Collection<JobInProgress> jips, boolean toComplete) {
        if (jips == null || jips.isEmpty()) {
            return new JobStatus[0];
        }
        ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
        for (JobInProgress jip : jips) {
            JobStatus status = jip.getStatus();
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            if (toComplete) {
                if (status.getRunState() != 1 && status.getRunState() != 4) continue;
                jobStatusList.add(status);
                continue;
            }
            jobStatusList.add(status);
        }
        return jobStatusList.toArray(new JobStatus[jobStatusList.size()]);
    }

    int getMaxTasksPerJob() {
        return this.conf.getInt("mapred.jobtracker.maxtasks.per.job", -1);
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        if (!this.conf.getBoolean("hadoop.security.authorization", false)) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        ServiceAuthorizationManager.refresh(this.conf, new MapReducePolicyProvider());
    }

    private void initializeTaskMemoryRelatedConfig() {
        this.memSizeForMapSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY, -1L));
        this.memSizeForReduceSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY, -1L));
        if (this.conf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn(JobConf.deprecatedString("mapred.task.limit.maxvmem") + " instead use " + MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY + " and " + MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY);
            this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapred.task.limit.maxvmem", -1L));
            if (this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForMapTasks >= 0L) {
                this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = this.limitMaxMemForMapTasks / 0x100000L;
            }
        } else {
            this.limitMaxMemForMapTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY, -1L));
            this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        LOG.info(new StringBuilder().append("Scheduler configured with ").append("(memSizeForMapSlotOnJT, memSizeForReduceSlotOnJT,").append(" limitMaxMemForMapTasks, limitMaxMemForReduceTasks) (").append(this.memSizeForMapSlotOnJT).append(", ").append(this.memSizeForReduceSlotOnJT).append(", ").append(this.limitMaxMemForMapTasks).append(", ").append(this.limitMaxMemForReduceTasks).append(")"));
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info("Refreshing superuser proxy groups mapping ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info("Refreshing all user-to-groups mappings. Requested by user: " + UserGroupInformation.getCurrentUser().getShortUserName());
        Groups.getUserToGroupsMappingService().refresh();
    }

    private boolean perTaskMemoryConfigurationSetOnJT() {
        return this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForReduceTasks != -1L && this.memSizeForMapSlotOnJT != -1L && this.memSizeForReduceSlotOnJT != -1L;
    }

    private void checkMemoryRequirements(JobInProgress job) throws IOException {
        if (!this.perTaskMemoryConfigurationSetOnJT()) {
            LOG.debug("Per-Task memory configuration is not set on JT. Not checking the job for invalid memory requirements.");
            return;
        }
        boolean invalidJob = false;
        String msg = "";
        long maxMemForMapTask = job.getMemoryForMapTask();
        long maxMemForReduceTask = job.getMemoryForReduceTask();
        if (maxMemForMapTask == -1L || maxMemForReduceTask == -1L) {
            invalidJob = true;
            msg = "Invalid job requirements.";
        }
        if (maxMemForMapTask > this.limitMaxMemForMapTasks || maxMemForReduceTask > this.limitMaxMemForReduceTasks) {
            invalidJob = true;
            msg = "Exceeds the cluster's max-memory-limit.";
        }
        if (invalidJob) {
            StringBuilder jobStr = new StringBuilder().append(job.getJobID().toString()).append("(").append(maxMemForMapTask).append(" memForMapTasks ").append(maxMemForReduceTask).append(" memForReduceTasks): ");
            LOG.warn(jobStr.toString() + msg);
            throw new IOException(jobStr.toString() + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshQueues() throws IOException {
        LOG.info("Refreshing queue information. requested by : " + UserGroupInformation.getCurrentUser().getShortUserName());
        this.queueManager.refreshQueues(new Configuration());
        TaskScheduler taskScheduler = this.taskScheduler;
        synchronized (taskScheduler) {
            this.taskScheduler.refresh();
        }
    }

    public String getReasonsForBlacklisting(String host) {
        return this.getReasonsForBlackOrGraylisting(host, false);
    }

    public String getReasonsForGraylisting(String host) {
        return this.getReasonsForBlackOrGraylisting(host, true);
    }

    private synchronized String getReasonsForBlackOrGraylisting(String host, boolean gray) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, gray);
        if (fi == null) {
            return "";
        }
        return fi.getTrackerBlackOrGraylistReport(gray);
    }

    synchronized Set<ReasonForBlackListing> getReasonForBlackList(String host) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, false);
        if (fi == null) {
            return new HashSet<ReasonForBlackListing>();
        }
        return fi.getReasonForBlacklisting(false);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    JobACLsManager getJobACLsManager() {
        return this.aclsManager.getJobACLsManager();
    }

    ACLsManager getACLsManager() {
        return this.aclsManager;
    }

    @Override
    public String getHostname() {
        return StringUtils.simpleHostname(this.getJobTrackerMachine());
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getConfigVersion() {
        return this.conf.get(CONF_VERSION_KEY, CONF_VERSION_DEFAULT);
    }

    @Override
    public int getThreadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getSummaryJson() {
        return this.getSummary().toJson();
    }

    InfoMap getSummary() {
        final ClusterMetrics metrics = this.getClusterMetrics();
        InfoMap map = new InfoMap();
        map.put("nodes", metrics.getTaskTrackerCount() + this.getBlacklistedTrackerCount());
        map.put("alive", metrics.getTaskTrackerCount());
        map.put("blacklisted", this.getBlacklistedTrackerCount());
        map.put("graylisted", this.getGraylistedTrackerCount());
        map.put("slots", new InfoMap(){
            {
                this.put("map_slots", metrics.getMapSlotCapacity());
                this.put("map_slots_used", metrics.getOccupiedMapSlots());
                this.put("reduce_slots", metrics.getReduceSlotCapacity());
                this.put("reduce_slots_used", metrics.getOccupiedReduceSlots());
            }
        });
        map.put("jobs", metrics.getTotalJobSubmissions());
        return map;
    }

    @Override
    public String getAliveNodesInfoJson() {
        return JSON.toString(this.getAliveNodesInfo());
    }

    List<InfoMap> getAliveNodesInfo() {
        ArrayList<InfoMap> info = new ArrayList<InfoMap>();
        for (final TaskTrackerStatus tts : this.activeTaskTrackers()) {
            final int mapSlots = tts.getMaxMapSlots();
            final int redSlots = tts.getMaxReduceSlots();
            info.add(new InfoMap(){
                {
                    this.put("hostname", tts.getHost());
                    this.put("last_seen", tts.getLastSeen());
                    this.put("health", tts.getHealthStatus().isNodeHealthy() ? "OK" : "");
                    this.put("slots", new InfoMap(){
                        {
                            this.put("map_slots", mapSlots);
                            this.put("map_slots_used", mapSlots - tts.getAvailableMapSlots());
                            this.put("reduce_slots", redSlots);
                            this.put("reduce_slots_used", redSlots - tts.getAvailableReduceSlots());
                        }
                    });
                    this.put("failures", tts.getTaskFailures());
                    this.put("dir_failures", tts.getDirFailures());
                }
            });
        }
        return info;
    }

    @Override
    public String getBlacklistedNodesInfoJson() {
        return JSON.toString(this.getUnhealthyNodesInfo(this.blacklistedTaskTrackers()));
    }

    @Override
    public String getGraylistedNodesInfoJson() {
        return JSON.toString(this.getUnhealthyNodesInfo(this.graylistedTaskTrackers()));
    }

    List<InfoMap> getUnhealthyNodesInfo(Collection<TaskTrackerStatus> list) {
        ArrayList<InfoMap> info = new ArrayList<InfoMap>();
        for (final TaskTrackerStatus tts : list) {
            info.add(new InfoMap(){
                {
                    this.put("hostname", tts.getHost());
                    this.put("last_seen", tts.getLastSeen());
                    this.put("reason", tts.getHealthStatus().getHealthReport());
                }
            });
        }
        return info;
    }

    @Override
    public String getQueueInfoJson() {
        return this.getQueueInfo().toJson();
    }

    InfoMap getQueueInfo() {
        InfoMap map = new InfoMap();
        try {
            for (final JobQueueInfo q : this.getQueues()) {
                map.put(q.getQueueName(), new InfoMap(){
                    {
                        this.put("state", q.getQueueState());
                        this.put("info", q.getSchedulingInfo());
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Getting queue info", e);
        }
        return map;
    }

    @Override
    public boolean setSafeMode(SafeModeAction safeModeAction) throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (safeModeAction == SafeModeAction.SAFEMODE_GET) {
            boolean safeMode = this.safeMode.get();
            LOG.info("Getting safemode information: safemode=" + safeMode + ". " + "Requested by : " + UserGroupInformation.getCurrentUser().getShortUserName());
            AuditLogger.logSuccess(user, "GET_SAFEMODE", "JobTracker");
            return safeMode;
        }
        if (!this.aclsManager.isMRAdmin(UserGroupInformation.getCurrentUser())) {
            AuditLogger.logFailure(user, "SET_SAFEMODE", this.aclsManager.getAdminsAcl().toString(), "JobTracker", "Unauthorized user");
            throw new AccessControlException(user + " is not authorized to set " + " JobTracker safemode.");
        }
        AuditLogger.logSuccess(user, "SET_SAFEMODE", "JobTracker");
        boolean currSafeMode = this.setSafeModeInternal(safeModeAction);
        this.adminSafeMode.set(currSafeMode);
        this.adminSafeModeUser = user;
        return currSafeMode;
    }

    boolean isInAdminSafeMode() {
        return this.adminSafeMode.get();
    }

    boolean setSafeModeInternal(SafeModeAction safeModeAction) throws IOException {
        if (safeModeAction != SafeModeAction.SAFEMODE_GET) {
            boolean safeMode = false;
            if (safeModeAction == SafeModeAction.SAFEMODE_ENTER) {
                safeMode = true;
            } else if (safeModeAction == SafeModeAction.SAFEMODE_LEAVE) {
                safeMode = false;
            }
            LOG.info("Setting safe mode to " + safeMode + ". Requested by : " + UserGroupInformation.getCurrentUser().getShortUserName());
            this.safeMode.set(safeMode);
        }
        return this.safeMode.get();
    }

    @Override
    public boolean isInSafeMode() {
        return this.safeMode.get();
    }

    String getSafeModeText() {
        if (!this.isInSafeMode()) {
            return "OFF";
        }
        String safeModeInfo = this.adminSafeMode.get() ? "Set by admin <strong>" + this.adminSafeModeUser + "</strong>" : "HDFS unavailable";
        return "<em>ON - " + safeModeInfo + "</em>";
    }

    private void checkSafeMode() throws SafeModeException {
        if (this.isInSafeMode()) {
            SafeModeException sme = new SafeModeException(this.isInAdminSafeMode() ? this.adminSafeModeUser : null);
            LOG.info("JobTracker in safe-mode, aborting operation: ", sme);
            throw sme;
        }
    }

    private void checkJobTrackerState() throws JobTrackerNotYetInitializedException {
        if (this.state != State.RUNNING) {
            JobTrackerNotYetInitializedException jtnyie = new JobTrackerNotYetInitializedException();
            LOG.info("JobTracker not yet in RUNNING state, aborting operation: ", jtnyie);
            throw jtnyie;
        }
    }

    private void generateAndStoreJobTokens(final JobID jobId, final Credentials tokenStorage) throws IOException {
        try {
            this.getMROwner().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Path jobDir = JobTracker.this.getSystemDirectoryForJob(jobId);
                    Path keysFile = new Path(jobDir, "jobToken");
                    JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(jobId.toString()));
                    Token<JobTokenIdentifier> token = new Token<JobTokenIdentifier>(identifier, JobTracker.this.getJobTokenSecretManager());
                    token.setService(identifier.getJobId());
                    TokenCache.setJobToken(token, tokenStorage);
                    tokenStorage.writeTokenStorageFile(keysFile, JobTracker.this.getConf());
                    LOG.info("jobToken generated and stored with users keys in " + keysFile.toUri().getPath());
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
        TASKTRACKER_EXPIRY_INTERVAL = 600000L;
        MAX_BLACKLIST_FRACTION = 0.5;
        lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
        SYSTEM_FILE_PERMISSION = FsPermission.createImmutable((short)448);
        LOG = LogFactory.getLog(JobTracker.class);
        EMPTY_COUNTERS = new Counters();
        EMPTY_TASK_REPORTS = new TaskReport[0];
        EMPTY_TASK_DIAGNOSTICS = new String[0];
    }

    public static enum SafeModeAction {
        SAFEMODE_LEAVE,
        SAFEMODE_ENTER,
        SAFEMODE_GET;

    }

    class RecoveryManager {
        Set<JobID> jobsToRecover;
        private int totalEventsRecovered = 0;
        private int restartCount = 0;
        private boolean shouldRecover = false;
        Set<String> recoveredTrackers = Collections.synchronizedSet(new HashSet());

        public RecoveryManager() {
            this.jobsToRecover = new TreeSet<JobID>();
        }

        public boolean contains(JobID id) {
            return this.jobsToRecover.contains(id);
        }

        void addJobForRecovery(JobID id) {
            this.jobsToRecover.add(id);
        }

        public boolean shouldRecover() {
            return this.shouldRecover;
        }

        public boolean shouldSchedule() {
            return this.recoveredTrackers.isEmpty();
        }

        private void markTracker(String trackerName) {
            this.recoveredTrackers.add(trackerName);
        }

        void unMarkTracker(String trackerName) {
            this.recoveredTrackers.remove(trackerName);
        }

        Set<JobID> getJobsToRecover() {
            return this.jobsToRecover;
        }

        private boolean isJobNameValid(String str) {
            if (str == null) {
                return false;
            }
            String[] parts = str.split("_");
            if (parts.length == 3 && parts[0].equals("job")) {
                return JobTracker.validateIdentifier(parts[1]) && JobTracker.validateJobNumber(parts[2]);
            }
            return false;
        }

        public void checkAndAddJob(FileStatus status) throws IOException {
            String fileName = status.getPath().getName();
            if (this.isJobNameValid(fileName) && this.isJobDirValid(JobID.forName(fileName))) {
                JobTracker.this.recoveryManager.addJobForRecovery(JobID.forName(fileName));
                this.shouldRecover = true;
            }
        }

        private boolean isJobDirValid(JobID jobId) throws IOException {
            JobConf job;
            boolean ret = false;
            Path jobInfoFile = JobTracker.this.getSystemFileForJob(jobId);
            Path jobTokenFile = JobTracker.this.getTokenFileForJob(jobId);
            if (jobTokenFile.getFileSystem(job = new JobConf()).exists(jobTokenFile) && jobInfoFile.getFileSystem(job).exists(jobInfoFile)) {
                ret = true;
            } else {
                LOG.warn("Job " + jobId + " does not have valid info/token file so ignoring for recovery");
            }
            return ret;
        }

        Path getRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info");
        }

        Path getTempRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info.recover");
        }

        void updateRestartCount() throws IOException {
            Path restartFile = this.getRestartCountFile();
            Path tmpRestartFile = this.getTempRestartCountFile();
            FsPermission filePerm = new FsPermission(SYSTEM_FILE_PERMISSION);
            if (JobTracker.this.fs.exists(restartFile)) {
                JobTracker.this.fs.delete(tmpRestartFile, false);
            } else if (JobTracker.this.fs.exists(tmpRestartFile)) {
                JobTracker.this.fs.rename(tmpRestartFile, restartFile);
            } else {
                this.shouldRecover = true;
                try {
                    FSDataOutputStream out = FileSystem.create(JobTracker.this.fs, restartFile, filePerm);
                    out.writeInt(0);
                    out.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Writing to file " + restartFile + " failed!");
                    LOG.warn("FileSystem is not ready yet!");
                    JobTracker.this.fs.delete(restartFile, false);
                    throw ioe;
                }
                return;
            }
            FSDataInputStream in = JobTracker.this.fs.open(restartFile);
            try {
                this.restartCount = in.readInt();
                ++this.restartCount;
            }
            catch (IOException ioe) {
                LOG.warn("System directory is garbled. Failed to read file " + restartFile);
                LOG.warn("Jobtracker recovery is not possible with garbled system directory! Please delete the system directory and restart the jobtracker. Note that deleting the system directory will result in loss of all the running jobs.");
                throw new RuntimeException(ioe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            FSDataOutputStream out = FileSystem.create(JobTracker.this.fs, tmpRestartFile, filePerm);
            out.writeInt(this.restartCount);
            out.close();
            JobTracker.this.fs.delete(restartFile, false);
            JobTracker.this.fs.rename(tmpRestartFile, restartFile);
        }

        public void recover() {
            int recovered = 0;
            long recoveryProcessStartTime = JobTracker.this.clock.getTime();
            if (!this.shouldRecover()) {
                this.jobsToRecover.clear();
                return;
            }
            LOG.info("Starting the recovery process for " + this.jobsToRecover.size() + " jobs ...");
            for (JobID jobId : this.jobsToRecover) {
                LOG.info("Submitting job " + jobId);
                try {
                    Path jobInfoFile = JobTracker.this.getSystemFileForJob(jobId);
                    Path jobTokenFile = JobTracker.this.getTokenFileForJob(jobId);
                    FSDataInputStream in = JobTracker.this.fs.open(jobInfoFile);
                    final JobInfo token = new JobInfo();
                    token.readFields(in);
                    in.close();
                    JobConf job = new JobConf();
                    final Credentials ts = jobTokenFile.getFileSystem(job).exists(jobTokenFile) ? Credentials.readTokenStorageFile(jobTokenFile, job) : null;
                    final UserGroupInformation ugi = UserGroupInformation.createRemoteUser(token.getUser().toString());
                    JobStatus status = ugi.doAs(new PrivilegedExceptionAction<JobStatus>(){

                        @Override
                        public JobStatus run() throws IOException, InterruptedException {
                            return JobTracker.this.submitJob(JobID.downgrade(token.getJobID()), token.getJobSubmitDir().toString(), ugi, ts, true);
                        }
                    });
                    if (status == null) {
                        LOG.info("Job " + jobId + " was not recovered since it " + "disabled recovery on restart (" + "mapreduce.job.restart.recover" + " set to 'false').");
                        continue;
                    }
                    ++recovered;
                }
                catch (Exception e) {
                    LOG.warn("Could not recover job " + jobId, e);
                }
            }
            JobTracker.this.recoveryDuration = JobTracker.this.clock.getTime() - recoveryProcessStartTime;
            JobTracker.this.hasRecovered = true;
            LOG.info("Recovery done! Recoverd " + recovered + " of " + this.jobsToRecover.size() + " jobs.");
            LOG.info("Recovery Duration (ms):" + JobTracker.this.recoveryDuration);
        }

        int totalEventsRecovered() {
            return this.totalEventsRecovered;
        }
    }

    private class FaultyTrackersInfo {
        private Map<String, FaultInfo> potentiallyFaultyTrackers = new HashMap<String, FaultInfo>();
        private volatile int numBlacklistedTrackers = 0;
        private volatile int numGraylistedTrackers = 0;

        private FaultyTrackersInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementFaults(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                long now = JobTracker.this.clock.getTime();
                FaultInfo fi = this.getFaultInfo(hostName, true);
                fi.incrFaultCount(now);
                if (this.exceedsFaults(fi, now)) {
                    LOG.info("Adding " + hostName + " to the graylist across all jobs");
                    String reason = String.format("%d failures on the tracker", fi.getFaultCount(now));
                    this.blacklistTracker(hostName, reason, ReasonForBlackListing.EXCEEDING_FAILURES, true);
                }
            }
        }

        private boolean exceedsFaults(FaultInfo fi, long timeStamp) {
            int faultCount = fi.getFaultCount(timeStamp);
            if (faultCount >= JobTracker.this.TRACKER_FAULT_THRESHOLD) {
                long clusterSize = JobTracker.this.getClusterStatus().getTaskTrackers();
                long sum = 0L;
                for (FaultInfo f : this.potentiallyFaultyTrackers.values()) {
                    sum += (long)f.getFaultCount(timeStamp);
                }
                double avg = (double)sum / (double)clusterSize;
                long totalCluster = clusterSize + (long)this.numBlacklistedTrackers;
                if ((double)faultCount - avg > JobTracker.this.AVERAGE_BLACKLIST_THRESHOLD * avg && (double)this.numGraylistedTrackers < (double)totalCluster * MAX_BLACKLIST_FRACTION) {
                    return true;
                }
            }
            return false;
        }

        private void incrBlacklistedTrackers(int count) {
            LOG.info("Incrementing blacklisted trackers by " + count);
            this.numBlacklistedTrackers += count;
            JobTracker.this.getInstrumentation().addBlackListedTrackers(count);
        }

        private void decrBlacklistedTrackers(int count) {
            LOG.info("Decrementing blacklisted trackers by " + count);
            this.numBlacklistedTrackers -= count;
            JobTracker.this.getInstrumentation().decBlackListedTrackers(count);
        }

        private void incrGraylistedTrackers(int count) {
            LOG.info("Incrementing graylisted trackers by " + count);
            this.numGraylistedTrackers += count;
            JobTracker.this.getInstrumentation().addGrayListedTrackers(count);
        }

        private void decrGraylistedTrackers(int count) {
            LOG.info("Decrementing graylisted trackers by " + count);
            this.numGraylistedTrackers -= count;
            JobTracker.this.getInstrumentation().decGrayListedTrackers(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blacklistTracker(String hostName, String reason, ReasonForBlackListing rfb, boolean gray) {
            boolean listed;
            FaultInfo fi = this.getFaultInfo(hostName, true);
            String shade = gray ? "gray" : "black";
            boolean bl = listed = gray ? fi.isGraylisted() : fi.isBlacklisted();
            if (listed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding/overwriting reason for " + shade + "listed tracker : " + hostName + " Reason for " + shade + "listing is : " + (Object)((Object)rfb) + " Reason details : " + reason);
                }
                if (!fi.getReasonForBlacklisting(gray).contains((Object)rfb)) {
                    LOG.info("Adding new reason for " + shade + "listed tracker : " + hostName + " Reason for " + shade + "listing is : " + (Object)((Object)rfb) + " Reason details : " + reason);
                }
                fi.addBlacklistedReason(rfb, reason, gray);
            } else {
                LOG.info("Adding new " + shade + "listed tracker : " + hostName + " Reason for " + shade + "listing is : " + (Object)((Object)rfb) + " Reason details : " + reason);
                if (gray) {
                    this.incrGraylistedTrackers(JobTracker.this.getNumTaskTrackersOnHost(hostName));
                } else {
                    Set<TaskTracker> trackers;
                    Set<TaskTracker> set = trackers = JobTracker.this.hostnameToTaskTracker.get(hostName);
                    synchronized (set) {
                        for (TaskTracker tracker : trackers) {
                            tracker.cancelAllReservations();
                        }
                    }
                    this.removeHostCapacity(hostName);
                }
                fi.setBlacklist(rfb, reason, gray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkTrackerFaultTimeout(String hostName, long now) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null && fi.getFaultCount(now) < JobTracker.this.TRACKER_FAULT_THRESHOLD) {
                    this.unBlacklistTracker(hostName, ReasonForBlackListing.EXCEEDING_FAILURES, true, now);
                }
            }
        }

        private void unBlacklistTracker(String hostName, ReasonForBlackListing rfb, boolean gray, long timeStamp) {
            boolean listed;
            FaultInfo fi = this.getFaultInfo(hostName, false);
            if (fi == null) {
                return;
            }
            Set<ReasonForBlackListing> rfbSet = fi.getReasonForBlacklisting(gray);
            boolean bl = listed = gray ? fi.isGraylisted() : fi.isBlacklisted();
            if (listed && rfbSet.contains((Object)rfb) && fi.removeBlacklistedReason(rfb, gray) && fi.getReasonForBlacklisting(gray).isEmpty()) {
                LOG.info("Un" + (gray ? "gray" : "black") + "listing tracker : " + hostName);
                if (gray) {
                    this.decrGraylistedTrackers(JobTracker.this.getNumTaskTrackersOnHost(hostName));
                } else {
                    this.addHostCapacity(hostName);
                }
                fi.unBlacklist(gray);
                if (fi.getFaultCount(timeStamp) == 0) {
                    this.potentiallyFaultyTrackers.remove(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FaultInfo getFaultInfo(String hostName, boolean createIfNecessary) {
            FaultInfo fi = null;
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi == null && createIfNecessary) {
                    fi = new FaultInfo(JobTracker.this.clock.getTime(), JobTracker.this.NUM_FAULT_BUCKETS, JobTracker.this.TRACKER_FAULT_BUCKET_WIDTH_MSECS);
                    this.potentiallyFaultyTrackers.put(hostName, fi);
                }
            }
            return fi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markTrackerHealthy(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.remove(hostName);
                if (fi != null) {
                    if (fi.isGraylisted()) {
                        LOG.info("Marking " + hostName + " healthy from graylist");
                        this.decrGraylistedTrackers(JobTracker.this.getNumTaskTrackersOnHost(hostName));
                    }
                    if (fi.isBlacklisted()) {
                        LOG.info("Marking " + hostName + " healthy from blacklist");
                        this.addHostCapacity(hostName);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity -= mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity -= reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().addBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().addBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.remove(hostName);
                this.incrBlacklistedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity += mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity += reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().decBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().decBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.put(hostName, numTrackersOnHost);
                this.decrBlacklistedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isBlacklisted(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.isBlacklisted();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isGraylisted(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.isGraylisted();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getFaultCount(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getFaultCount(JobTracker.this.clock.getTime());
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNodeHealthStatus(String hostName, boolean isHealthy, String reason, long timeStamp) {
            FaultInfo fi = null;
            if (!isHealthy) {
                fi = this.getFaultInfo(hostName, true);
                Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
                synchronized (map) {
                    this.blacklistTracker(hostName, reason, ReasonForBlackListing.NODE_UNHEALTHY, false);
                }
            } else {
                fi = this.getFaultInfo(hostName, false);
                if (fi != null) {
                    this.unBlacklistTracker(hostName, ReasonForBlackListing.NODE_UNHEALTHY, false, timeStamp);
                }
            }
        }
    }

    private static class FaultInfo {
        static final String FAULT_FORMAT_STRING = "%d failures on the tracker";
        int[] numFaults;
        long lastRotated;
        boolean blacklisted;
        boolean graylisted;
        private int numFaultBuckets;
        private long bucketWidth;
        private HashMap<ReasonForBlackListing, String> blackRfbMap;
        private HashMap<ReasonForBlackListing, String> grayRfbMap;

        FaultInfo(long time, int numFaultBuckets, long bucketWidth) {
            this.numFaultBuckets = numFaultBuckets;
            this.bucketWidth = bucketWidth;
            this.numFaults = new int[numFaultBuckets];
            this.lastRotated = time / bucketWidth * bucketWidth;
            this.blacklisted = false;
            this.graylisted = false;
            this.blackRfbMap = new HashMap();
            this.grayRfbMap = new HashMap();
        }

        private void checkRotation(long timeStamp) {
            for (long diff = timeStamp - this.lastRotated; diff > this.bucketWidth; diff -= this.bucketWidth) {
                this.lastRotated += this.bucketWidth;
                int idx = (int)(this.lastRotated / this.bucketWidth % (long)this.numFaultBuckets);
                this.numFaults[idx] = 0;
            }
        }

        private int bucketIndex(long timeStamp) {
            return (int)(timeStamp / this.bucketWidth % (long)this.numFaultBuckets);
        }

        void incrFaultCount(long timeStamp) {
            this.checkRotation(timeStamp);
            int n = this.bucketIndex(timeStamp);
            this.numFaults[n] = this.numFaults[n] + 1;
        }

        int getFaultCount(long timeStamp) {
            this.checkRotation(timeStamp);
            int faultCount = 0;
            for (int faults : this.numFaults) {
                faultCount += faults;
            }
            return faultCount;
        }

        boolean isBlacklisted() {
            return this.blacklisted;
        }

        boolean isGraylisted() {
            return this.graylisted;
        }

        void setBlacklist(ReasonForBlackListing rfb, String trackerFaultReport, boolean gray) {
            if (gray) {
                this.graylisted = true;
                this.grayRfbMap.put(rfb, trackerFaultReport);
            } else {
                this.blacklisted = true;
                this.blackRfbMap.put(rfb, trackerFaultReport);
            }
        }

        public String getTrackerBlackOrGraylistReport(boolean gray) {
            StringBuffer sb = new StringBuffer();
            HashMap<ReasonForBlackListing, String> rfbMap = new HashMap<ReasonForBlackListing, String>();
            rfbMap.putAll(gray ? this.grayRfbMap : this.blackRfbMap);
            for (String reasons : rfbMap.values()) {
                sb.append(reasons);
                sb.append("\n");
            }
            return sb.toString();
        }

        Set<ReasonForBlackListing> getReasonForBlacklisting(boolean gray) {
            return gray ? this.grayRfbMap.keySet() : this.blackRfbMap.keySet();
        }

        public void unBlacklist(boolean gray) {
            if (gray) {
                this.graylisted = false;
                this.grayRfbMap.clear();
            } else {
                this.blacklisted = false;
                this.blackRfbMap.clear();
            }
        }

        public boolean removeBlacklistedReason(ReasonForBlackListing rfb, boolean gray) {
            String str = gray ? this.grayRfbMap.remove((Object)rfb) : this.blackRfbMap.remove((Object)rfb);
            return str != null;
        }

        public void addBlacklistedReason(ReasonForBlackListing rfb, String reason, boolean gray) {
            if (gray) {
                this.grayRfbMap.put(rfb, reason);
            } else {
                this.blackRfbMap.put(rfb, reason);
            }
        }
    }

    static enum ReasonForBlackListing {
        EXCEEDING_FAILURES,
        NODE_UNHEALTHY;

    }

    class RetireJobs
    implements Runnable {
        private final Map<JobID, RetireJobInfo> jobIDStatusMap = new HashMap<JobID, RetireJobInfo>();
        private final LinkedList<RetireJobInfo> jobRetireInfoQ = new LinkedList();

        synchronized void addToCache(JobInProgress job) {
            Counters counters = new Counters();
            boolean isFine = job.getCounters(counters);
            counters = isFine ? counters : new Counters();
            RetireJobInfo info = new RetireJobInfo(counters, job.getStatus(), job.getProfile(), job.getFinishTime(), job.getHistoryFile());
            this.jobRetireInfoQ.add(info);
            this.jobIDStatusMap.put(info.status.getJobID(), info);
            if (this.jobRetireInfoQ.size() > JobTracker.this.retiredJobsCacheSize) {
                RetireJobInfo removed = this.jobRetireInfoQ.remove();
                this.jobIDStatusMap.remove(removed.status.getJobID());
                LOG.info("Retired job removed from cache " + removed.status.getJobID());
            }
        }

        synchronized RetireJobInfo get(JobID jobId) {
            return this.jobIDStatusMap.get(jobId);
        }

        synchronized LinkedList<RetireJobInfo> getAll() {
            return (LinkedList)this.jobRetireInfoQ.clone();
        }

        synchronized LinkedList<JobStatus> getAllJobStatus() {
            LinkedList<JobStatus> list = new LinkedList<JobStatus>();
            for (RetireJobInfo info : this.jobRetireInfoQ) {
                list.add(info.status);
            }
            return list;
        }

        private boolean minConditionToRetire(JobInProgress job, long now) {
            return job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4 && job.getFinishTime() + 0L < now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Object jobUser;
                    Object object;
                    ArrayList<JobInProgress> retiredJobs;
                    do {
                        Thread.sleep(RETIRE_JOB_CHECK_INTERVAL);
                        retiredJobs = new ArrayList<JobInProgress>();
                        long now = JobTracker.this.clock.getTime();
                        long retireBefore = now - RETIRE_JOB_INTERVAL;
                        object = JobTracker.this.jobs;
                        synchronized (object) {
                            for (JobInProgress job : JobTracker.this.jobs.values()) {
                                if (!this.minConditionToRetire(job, now) || job.getFinishTime() >= retireBefore) continue;
                                retiredJobs.add(job);
                            }
                        }
                        object = JobTracker.this.userToJobsMap;
                        synchronized (object) {
                            Iterator<Map.Entry<String, ArrayList<JobInProgress>>> userToJobsMapIt = JobTracker.this.userToJobsMap.entrySet().iterator();
                            while (userToJobsMapIt.hasNext()) {
                                Map.Entry<String, ArrayList<JobInProgress>> entry = userToJobsMapIt.next();
                                ArrayList<JobInProgress> userJobs = entry.getValue();
                                Iterator<JobInProgress> it = userJobs.iterator();
                                while (it.hasNext()) {
                                    jobUser = it.next();
                                    if (!retiredJobs.contains(jobUser)) continue;
                                    LOG.info("Removing from userToJobsMap: " + ((JobInProgress)jobUser).getJobID());
                                    it.remove();
                                }
                                it = userJobs.iterator();
                                while (it.hasNext() && userJobs.size() > JobTracker.this.MAX_COMPLETE_USER_JOBS_IN_MEMORY) {
                                    jobUser = it.next();
                                    if (!this.minConditionToRetire((JobInProgress)jobUser, now)) continue;
                                    LOG.info("User limit exceeded. Marking job: " + ((JobInProgress)jobUser).getJobID() + " for retire.");
                                    retiredJobs.add((JobInProgress)jobUser);
                                    it.remove();
                                }
                                if (!userJobs.isEmpty()) continue;
                                userToJobsMapIt.remove();
                            }
                        }
                    } while (retiredJobs.isEmpty());
                    object = JobTracker.this;
                    synchronized (object) {
                        Map<JobID, JobInProgress> map = JobTracker.this.jobs;
                        synchronized (map) {
                            TaskScheduler taskScheduler = JobTracker.this.taskScheduler;
                            synchronized (taskScheduler) {
                                for (JobInProgress job : retiredJobs) {
                                    JobTracker.this.removeJobTasks(job);
                                    JobTracker.this.jobs.remove(job.getProfile().getJobID());
                                    for (JobInProgressListener l : JobTracker.this.jobInProgressListeners) {
                                        l.jobRemoved(job);
                                    }
                                    jobUser = job.getProfile().getUser();
                                    LOG.info("Retired job with id: '" + job.getProfile().getJobID() + "' of user '" + (String)jobUser + "'");
                                    JobHistory.JobInfo.cleanupJob(job.getProfile().getJobID());
                                    this.addToCache(job);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException t) {
                }
                catch (Throwable t) {
                    LOG.error("Error in retiring job:\n" + StringUtils.stringifyException(t));
                    continue;
                }
                break;
            }
        }
    }

    static class RetireJobInfo {
        final JobStatus status;
        final JobProfile profile;
        final long finishTime;
        final Counters counters;
        private String historyFile;

        RetireJobInfo(Counters counters, JobStatus status, JobProfile profile, long finishTime, String historyFile) {
            this.counters = counters;
            this.status = status;
            this.profile = profile;
            this.finishTime = finishTime;
            this.historyFile = historyFile;
        }

        void setHistoryFile(String file) {
            this.historyFile = file;
        }

        String getHistoryFile() {
            return this.historyFile;
        }
    }

    class ExpireTrackers
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            HashMap hashMap = JobTracker.this.taskTrackers;
                            synchronized (hashMap) {
                                TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                                synchronized (treeSet) {
                                    long now = JobTracker.this.clock.getTime();
                                    TaskTrackerStatus leastRecent = null;
                                    while (JobTracker.this.trackerExpiryQueue.size() > 0 && (leastRecent = JobTracker.this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                        JobTracker.this.trackerExpiryQueue.remove(leastRecent);
                                        String trackerName = leastRecent.getTrackerName();
                                        TaskTracker current = JobTracker.this.getTaskTracker(trackerName);
                                        TaskTrackerStatus newProfile = current == null ? null : current.getStatus();
                                        if (newProfile == null) continue;
                                        if (now - newProfile.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                            JobTracker.this.removeTracker(current);
                                            String hostname = newProfile.getHost();
                                            JobTracker.this.hostnameToTaskTracker.get(hostname).remove(trackerName);
                                            continue;
                                        }
                                        JobTracker.this.trackerExpiryQueue.add(newProfile);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
                catch (Exception t) {
                    LOG.error("Tracker Expiry Thread got exception: " + StringUtils.stringifyException(t));
                    continue;
                }
                break;
            }
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private Map<TaskAttemptID, Long> launchingTasks = new LinkedHashMap<TaskAttemptID, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        long now = JobTracker.this.clock.getTime();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Starting launching task sweep");
                        }
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            Map<TaskAttemptID, Long> map = this.launchingTasks;
                            synchronized (map) {
                                Iterator<Map.Entry<TaskAttemptID, Long>> itr = this.launchingTasks.entrySet().iterator();
                                while (itr.hasNext()) {
                                    Map.Entry<TaskAttemptID, Long> pair = itr.next();
                                    TaskAttemptID taskId = pair.getKey();
                                    long age = now - pair.getValue();
                                    LOG.info(taskId + " is " + age + " ms debug.");
                                    if (age <= TASKTRACKER_EXPIRY_INTERVAL) break;
                                    LOG.info("Launching task " + taskId + " timed out.");
                                    TaskInProgress tip = null;
                                    tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                    if (tip != null) {
                                        JobInProgress job = tip.getJob();
                                        String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                        TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTrackerStatus(trackerName);
                                        if (trackerStatus != null) {
                                            job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerName);
                                        }
                                    }
                                    itr.remove();
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error("Expire Launching Task Thread got exception: " + StringUtils.stringifyException(e));
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, JobTracker.this.clock.getTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }
    }

    public static class IllegalStateException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public IllegalStateException(String msg) {
            super(msg);
        }
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

