/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TimeBucketMetrics;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

class QueueMetrics
implements MetricsSource {
    private static final Log LOG = LogFactory.getLog(QueueMetrics.class);
    public static final String BUCKET_PROPERTY = "mapred.queue.metrics.runtime.buckets";
    private static final String DEFAULT_BUCKETS = "60,300,1440";
    final MetricsRegistry registry = new MetricsRegistry("Queue");
    final MetricMutableCounterInt mapsLaunched = this.registry.newCounter("maps_launched", "", 0);
    final MetricMutableCounterInt mapsCompleted = this.registry.newCounter("maps_completed", "", 0);
    final MetricMutableCounterInt mapsFailed = this.registry.newCounter("maps_failed", "", 0);
    final MetricMutableCounterInt redsLaunched = this.registry.newCounter("reduces_launched", "", 0);
    final MetricMutableCounterInt redsCompleted = this.registry.newCounter("reduces_completed", "", 0);
    final MetricMutableCounterInt redsFailed = this.registry.newCounter("reduces_failed", "", 0);
    final MetricMutableCounterInt jobsSubmitted = this.registry.newCounter("jobs_submitted", "", 0);
    final MetricMutableCounterInt jobsCompleted = this.registry.newCounter("jobs_completed", "", 0);
    final MetricMutableGaugeInt waitingMaps = this.registry.newGauge("waiting_maps", "", 0);
    final MetricMutableGaugeInt waitingReds = this.registry.newGauge("waiting_reduces", "", 0);
    final MetricMutableGaugeInt reservedMapSlots = this.registry.newGauge("reserved_map_slots", "", 0);
    final MetricMutableGaugeInt reservedRedSlots = this.registry.newGauge("reserved_reduce_slots", "", 0);
    final MetricMutableCounterInt jobsFailed = this.registry.newCounter("jobs_failed", "", 0);
    final MetricMutableCounterInt jobsKilled = this.registry.newCounter("jobs_killed", "", 0);
    final MetricMutableGaugeInt jobsPreparing = this.registry.newGauge("jobs_preparing", "", 0);
    final MetricMutableGaugeInt jobsRunning = this.registry.newGauge("jobs_running", "", 0);
    final MetricMutableCounterInt mapsKilled = this.registry.newCounter("maps_killed", "", 0);
    final MetricMutableCounterInt redsKilled = this.registry.newCounter("reduces_killed", "", 0);
    final MetricMutableGaugeInt[] runningTime;
    TimeBucketMetrics<JobID> runBuckets;
    final String sessionId;
    private String queueName;

    public QueueMetrics(String queueName, Configuration conf) {
        this.queueName = queueName;
        this.sessionId = conf.get("session.id", "");
        this.registry.setContext("mapred").tag("sessionId", "", this.sessionId);
        this.registry.tag("Queue", "Metrics by queue", queueName);
        this.runningTime = this.buildBuckets(conf);
    }

    public String getQueueName() {
        return this.queueName;
    }

    private static ArrayList<Integer> parseInts(String value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String word : value.split(",")) {
            result.add(Integer.parseInt(word.trim()));
        }
        return result;
    }

    private MetricMutableGaugeInt[] buildBuckets(Configuration conf) {
        ArrayList<Integer> buckets = QueueMetrics.parseInts(conf.get(BUCKET_PROPERTY, DEFAULT_BUCKETS));
        MetricMutableGaugeInt[] result = new MetricMutableGaugeInt[buckets.size() + 1];
        result[0] = this.registry.newGauge("running_0", "", 0);
        long[] cuts = new long[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            result[i + 1] = this.registry.newGauge("running_" + buckets.get(i), "", 0);
            cuts[i] = buckets.get(i) * 1000 * 60;
        }
        this.runBuckets = new TimeBucketMetrics(cuts);
        return result;
    }

    private void updateRunningTime() {
        int[] counts = this.runBuckets.getBucketCounts(System.currentTimeMillis());
        for (int i = 0; i < counts.length; ++i) {
            this.runningTime[i].set(counts[i]);
        }
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.updateRunningTime();
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }

    public void launchMap(TaskAttemptID taskAttemptID) {
        this.mapsLaunched.incr();
        this.decWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    public void completeMap(TaskAttemptID taskAttemptID) {
        this.mapsCompleted.incr();
    }

    public void failedMap(TaskAttemptID taskAttemptID) {
        this.mapsFailed.incr();
        this.addWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    public void launchReduce(TaskAttemptID taskAttemptID) {
        this.redsLaunched.incr();
        this.decWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    public void completeReduce(TaskAttemptID taskAttemptID) {
        this.redsCompleted.incr();
    }

    public void failedReduce(TaskAttemptID taskAttemptID) {
        this.redsFailed.incr();
        this.addWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    public void submitJob(JobConf conf, JobID id) {
        this.jobsSubmitted.incr();
    }

    public void completeJob(JobConf conf, JobID id) {
        this.jobsCompleted.incr();
    }

    public void addWaitingMaps(JobID id, int task) {
        this.waitingMaps.incr(task);
    }

    public void decWaitingMaps(JobID id, int task) {
        this.waitingMaps.decr(task);
    }

    public void addWaitingReduces(JobID id, int task) {
        this.waitingReds.incr(task);
    }

    public void decWaitingReduces(JobID id, int task) {
        this.waitingReds.decr(task);
    }

    public void addReservedMapSlots(int slots) {
        this.reservedMapSlots.incr(slots);
    }

    public void decReservedMapSlots(int slots) {
        this.reservedMapSlots.decr(slots);
    }

    public void addReservedReduceSlots(int slots) {
        this.reservedRedSlots.incr(slots);
    }

    public void decReservedReduceSlots(int slots) {
        this.reservedRedSlots.decr(slots);
    }

    public void failedJob(JobConf conf, JobID id) {
        this.jobsFailed.incr();
    }

    public void killedJob(JobConf conf, JobID id) {
        this.jobsKilled.incr();
    }

    public void addPrepJob(JobConf conf, JobID id) {
        this.jobsPreparing.incr();
    }

    public void decPrepJob(JobConf conf, JobID id) {
        this.jobsPreparing.decr();
    }

    public void addRunningJob(JobConf conf, JobID id) {
        this.jobsRunning.incr();
        this.runBuckets.add(id, System.currentTimeMillis());
    }

    public void decRunningJob(JobConf conf, JobID id) {
        this.jobsRunning.decr();
        this.runBuckets.remove(id);
    }

    public void killedMap(TaskAttemptID taskAttemptID) {
        this.mapsKilled.incr();
    }

    public void killedReduce(TaskAttemptID taskAttemptID) {
        this.redsKilled.incr();
    }

    static QueueMetrics create(String queueName, Configuration conf) {
        return QueueMetrics.create(queueName, conf, DefaultMetricsSystem.INSTANCE);
    }

    static QueueMetrics create(String queueName, Configuration conf, MetricsSystem ms) {
        return ms.register("QueueMetrics,q=" + queueName, "Queue metrics", new QueueMetrics(queueName, conf));
    }
}

