/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.Configuration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.ConfigurationException;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.PropertiesConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.SubsetConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsPlugin;
import org.apache.hadoop.metrics2.impl.MetricsConfigException;
import org.apache.hadoop.util.StringUtils;

class MetricsConfig
extends SubsetConfiguration {
    static final Log LOG = LogFactory.getLog(MetricsConfig.class);
    static final String DEFAULT_FILE_NAME = "hadoop-metrics2.properties";
    static final String PREFIX_DEFAULT = "*.";
    static final String PERIOD_KEY = "period";
    static final int PERIOD_DEFAULT = 10;
    static final String QUEUE_CAPACITY_KEY = "queue.capacity";
    static final int QUEUE_CAPACITY_DEFAULT = 1;
    static final String RETRY_DELAY_KEY = "retry.delay";
    static final int RETRY_DELAY_DEFAULT = 10;
    static final String RETRY_BACKOFF_KEY = "retry.backoff";
    static final int RETRY_BACKOFF_DEFAULT = 2;
    static final String RETRY_COUNT_KEY = "retry.count";
    static final int RETRY_COUNT_DEFAULT = 1;
    static final String JMX_CACHE_TTL_KEY = "jmx.cache.ttl";
    static final int JMX_CACHE_TTL_DEFAULT = 10000;
    static final String CONTEXT_KEY = "context";
    static final String NAME_KEY = "name";
    static final String DESC_KEY = "description";
    static final String SOURCE_KEY = "source";
    static final String SINK_KEY = "sink";
    static final String METRIC_FILTER_KEY = "metric.filter";
    static final String RECORD_FILTER_KEY = "record.filter";
    static final String SOURCE_FILTER_KEY = "source.filter";
    static final Pattern INSTANCE_REGEX = Pattern.compile("([^.*]+)\\..+");

    MetricsConfig(Configuration c, String prefix) {
        super(c, prefix.toLowerCase(Locale.US), ".");
    }

    static MetricsConfig create(String prefix) {
        return MetricsConfig.loadFirst(prefix, "hadoop-metrics2-" + prefix.toLowerCase(Locale.US) + ".properties", DEFAULT_FILE_NAME);
    }

    static MetricsConfig create(String prefix, String ... fileNames) {
        return MetricsConfig.loadFirst(prefix, fileNames);
    }

    static MetricsConfig loadFirst(String prefix, String ... fileNames) {
        for (String fname : fileNames) {
            try {
                Configuration cf = new PropertiesConfiguration(fname).interpolatedConfiguration();
                LOG.info("loaded properties from " + fname);
                return new MetricsConfig(cf, prefix);
            }
            catch (ConfigurationException e) {
                if (e.getMessage().startsWith("Cannot locate configuration")) continue;
                throw new MetricsConfigException(e);
            }
        }
        throw new MetricsConfigException("Cannot locate configuration: tried " + StringUtils.join((CharSequence)", ", fileNames));
    }

    @Override
    public MetricsConfig subset(String prefix) {
        return new MetricsConfig(this, prefix);
    }

    Map<String, MetricsConfig> getInstanceConfigs(String type) {
        HashMap<String, MetricsConfig> map = new HashMap<String, MetricsConfig>();
        MetricsConfig sub = this.subset(type);
        for (String key : sub.keys()) {
            String instance;
            Matcher matcher = INSTANCE_REGEX.matcher(key);
            if (!matcher.matches() || map.containsKey(instance = matcher.group(1))) continue;
            map.put(instance, sub.subset(instance));
        }
        return map;
    }

    Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return MetricsConfig.this.getKeys();
            }
        };
    }

    @Override
    public Object getProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            LOG.debug("poking parent " + this.getParent().getClass().getSimpleName() + " for " + key);
            return this.getParent().getProperty(key.startsWith(PREFIX_DEFAULT) ? key : PREFIX_DEFAULT + key);
        }
        return value;
    }

    <T extends MetricsPlugin> T getPlugin(String name) {
        String classKey = name.isEmpty() ? "class" : name + ".class";
        String pluginClassName = this.getString(classKey);
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        try {
            Class<?> pluginClass = Class.forName(pluginClassName);
            MetricsPlugin plugin = (MetricsPlugin)pluginClass.newInstance();
            plugin.init(name.isEmpty() ? this : this.subset(name));
            return (T)plugin;
        }
        catch (Exception e) {
            throw new MetricsConfigException("Error creating plugin: " + pluginClassName, e);
        }
    }

    MetricsFilter getFilter(String prefix) {
        if (this.subset(prefix).isEmpty()) {
            return null;
        }
        return (MetricsFilter)this.getPlugin(prefix);
    }

    public String toString() {
        return this.toString(this);
    }

    String toString(Configuration c) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(buffer);
        PropertiesConfiguration tmp = new PropertiesConfiguration();
        tmp.copy(c);
        try {
            tmp.save(ps);
        }
        catch (Exception e) {
            throw new MetricsConfigException(e);
        }
        return buffer.toString();
    }
}

