/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import org.apache.hadoop.security.NetgroupCache;

public class JniBasedUnixGroupsNetgroupMapping
extends JniBasedUnixGroupsMapping {
    private static final Log LOG = LogFactory.getLog(JniBasedUnixGroupsNetgroupMapping.class);
    private static final NetgroupCache netgroupCache = new NetgroupCache();

    native String[] getUsersForNetgroupJNI(String var1);

    @Override
    public List<String> getGroups(String user) throws IOException {
        LinkedList<String> groups = new LinkedList<String>(super.getGroups(user));
        netgroupCache.getNetgroups(user, groups);
        return groups;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        List<String> groups = netgroupCache.getNetgroupNames();
        netgroupCache.clear();
        this.cacheGroupsAdd(groups);
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        for (String group : groups) {
            if (group.length() == 0 || group.charAt(0) != '@' || netgroupCache.isCached(group)) continue;
            netgroupCache.add(group, this.getUsersForNetgroup(group));
        }
    }

    protected synchronized List<String> getUsersForNetgroup(String netgroup) {
        String[] users = null;
        try {
            users = this.getUsersForNetgroupJNI(netgroup.substring(1));
        }
        catch (Exception e) {
            LOG.warn("Got exception while trying to obtain the users for netgroup [" + netgroup + "] [" + e + "]");
        }
        if (users != null && users.length != 0) {
            return Arrays.asList(users);
        }
        return new LinkedList<String>();
    }
}

