/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileOrcDataSource
implements OrcDataSource {
    private final File path;
    private final long size;
    private final RandomAccessFile input;
    private final DataSize maxMergeDistance;
    private long readTimeNanos;

    public FileOrcDataSource(File path, DataSize maxMergeDistance) throws IOException {
        this.path = (File)Preconditions.checkNotNull((Object)path, (Object)"path is null");
        this.size = path.length();
        this.input = new RandomAccessFile(path, "r");
        this.maxMergeDistance = (DataSize)Preconditions.checkNotNull((Object)maxMergeDistance, (Object)"maxMergeDistance is null");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
    }

    @Override
    public <K> Map<K, Slice> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Preconditions.checkNotNull(diskRanges, (Object)"diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        Iterable<DiskRange> mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), this.maxMergeDistance);
        LinkedHashMap<DiskRange, byte[]> buffers = new LinkedHashMap<DiskRange, byte[]>();
        for (DiskRange mergedRange : mergedRanges) {
            byte[] buffer = new byte[mergedRange.getLength()];
            this.readFully(mergedRange.getOffset(), buffer);
            buffers.put(mergedRange, buffer);
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            slices.put(entry.getKey(), (Object)OrcDataSourceUtils.getDiskRangeSlice(entry.getValue(), buffers));
        }
        return slices.build();
    }

    public String toString() {
        return this.path.getPath();
    }
}

