/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryJsonReader
implements JsonMapKeyReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean writeBinary;
    @Nonnull
    private DictionaryEntry[] dictionary = new DictionaryEntry[0];
    @Nonnull
    private int[] dictionaryLength = new int[0];
    @Nonnull
    private DictionaryEntry[] rowGroupDictionary = new DictionaryEntry[0];
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private BooleanStream inDictionaryStream;
    @Nullable
    private LongStream dataStream;

    public SliceDictionaryJsonReader(StreamDescriptor streamDescriptor, boolean writeBinary) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.writeBinary = writeBinary;
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        DictionaryEntry value = this.getNextValue();
        byte[] data = value.getData();
        int offset = value.getOffset();
        int length = value.length();
        if (this.writeBinary) {
            generator.writeBinary(data, offset, length);
        } else {
            generator.writeUTF8String(data, offset, length);
        }
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        DictionaryEntry value = this.getNextValue();
        byte[] data = value.getData();
        int offset = value.getOffset();
        int length = value.length();
        if (this.writeBinary) {
            return BaseEncoding.base64().encode(data, offset, length);
        }
        return new String(data, offset, length, StandardCharsets.UTF_8);
    }

    private DictionaryEntry getNextValue() throws IOException {
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        int dictionaryIndex = Ints.checkedCast((long)this.dataStream.next());
        DictionaryEntry value = this.inDictionaryStream == null || this.inDictionaryStream.nextBit() ? this.dictionary[dictionaryIndex] : this.rowGroupDictionary[dictionaryIndex];
        return value;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        if (this.inDictionaryStream != null) {
            this.inDictionaryStream.skip(skipSize);
        }
        this.dataStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        int dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        if (dictionarySize > 0) {
            LongStream lengthStream;
            if (this.dictionary.length < dictionarySize) {
                this.dictionary = new DictionaryEntry[dictionarySize];
                this.dictionaryLength = new int[dictionarySize];
            }
            if ((lengthStream = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream()) == null) {
                throw new OrcCorruptionException("Dictionary is not empty but length stream is not present");
            }
            lengthStream.nextIntVector(dictionarySize, this.dictionaryLength);
            ByteArrayStream dictionaryDataStream = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayStream.class).openStream();
            SliceDictionaryJsonReader.readDictionary(dictionaryDataStream, dictionarySize, this.dictionaryLength, this.dictionary);
        }
        this.presentStream = null;
        this.dataStream = null;
        this.inDictionaryStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        RowGroupDictionaryLengthStream lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthStream.class).openStream();
        if (lengthStream == null) {
            this.inDictionaryStream = null;
        } else {
            this.inDictionaryStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class).openStream();
            int dictionaryEntryCount = lengthStream.getEntryCount();
            if (this.rowGroupDictionary.length < dictionaryEntryCount) {
                this.rowGroupDictionary = new DictionaryEntry[dictionaryEntryCount];
                this.rowGroupDictionaryLength = new int[dictionaryEntryCount];
            }
            lengthStream.nextIntVector(dictionaryEntryCount, this.rowGroupDictionaryLength);
            ByteArrayStream dictionaryDataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayStream.class).openStream();
            SliceDictionaryJsonReader.readDictionary(dictionaryDataStream, dictionaryEntryCount, this.rowGroupDictionaryLength, this.rowGroupDictionary);
        }
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
    }

    private static void readDictionary(ByteArrayStream dictionaryDataStream, int dictionarySize, int[] dictionaryLength, DictionaryEntry[] dictionary) throws IOException {
        int totalLength = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            totalLength += dictionaryLength[i];
        }
        byte[] dictionaryData = new byte[]{};
        if (totalLength > 0) {
            if (dictionaryDataStream == null) {
                throw new OrcCorruptionException("Dictionary length is not zero but dictionary data stream is not present");
            }
            dictionaryData = dictionaryDataStream.next(totalLength);
        }
        int offset = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            int length = dictionaryLength[i];
            dictionary[i] = new DictionaryEntry(dictionaryData, offset, length);
            offset += length;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    private static class DictionaryEntry {
        private final byte[] dictionary;
        private final int offset;
        private final int length;

        public DictionaryEntry(byte[] dictionary, int offset, int length) {
            this.dictionary = dictionary;
            this.offset = offset;
            this.length = length;
        }

        public int length() {
            return this.length;
        }

        public byte[] getData() {
            return this.dictionary;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

