/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.services.cloudfront.model.Paths;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class CreateInvalidationRequestMarshaller
implements Marshaller<Request<CreateInvalidationRequest>, CreateInvalidationRequest> {
    @Override
    public Request<CreateInvalidationRequest> marshall(CreateInvalidationRequest createInvalidationRequest) {
        InvalidationBatch invalidationBatchInvalidationBatch;
        if (createInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInvalidationRequest> request = new DefaultRequest<CreateInvalidationRequest>(createInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2014-05-31/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(createInvalidationRequest.getDistributionId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2014-05-31/");
        if (createInvalidationRequest != null && (invalidationBatchInvalidationBatch = createInvalidationRequest.getInvalidationBatch()) != null) {
            Paths pathsPaths;
            xmlWriter.startElement("InvalidationBatch");
            if (invalidationBatchInvalidationBatch != null && (pathsPaths = invalidationBatchInvalidationBatch.getPaths()) != null) {
                List<String> pathsPathsitemsList;
                xmlWriter.startElement("Paths");
                if (pathsPaths.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(pathsPaths.getQuantity()).endElement();
                }
                if (pathsPaths != null && (pathsPathsitemsList = pathsPaths.getItems()) != null && pathsPathsitemsList.size() > 0) {
                    int pathsPathsitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (String pathsPathsitemsListValue : pathsPathsitemsList) {
                        xmlWriter.startElement("Path");
                        xmlWriter.value(pathsPathsitemsListValue);
                        xmlWriter.endElement();
                        ++pathsPathsitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (invalidationBatchInvalidationBatch.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(invalidationBatchInvalidationBatch.getCallerReference()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

