/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCognitoSyncAsyncClient
extends AmazonCognitoSyncClient
implements AmazonCognitoSyncAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCognitoSyncAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCognitoSyncAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
            }
        });
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest, final AsyncHandler<UpdateRecordsRequest, UpdateRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                UpdateRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateRecordsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest, final AsyncHandler<DescribeIdentityPoolUsageRequest, DescribeIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                DescribeIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeIdentityPoolUsageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDatasetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest, final AsyncHandler<ListIdentityPoolUsageRequest, ListIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                ListIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listIdentityPoolUsageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest, final AsyncHandler<ListRecordsRequest, ListRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                ListRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listRecordsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDatasetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDatasetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest, final AsyncHandler<DescribeIdentityUsageRequest, DescribeIdentityUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                DescribeIdentityUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeIdentityUsageRequest, result);
                return result;
            }
        });
    }
}

