/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDhcpOptionsRequestMarshaller
implements Marshaller<Request<DescribeDhcpOptionsRequest>, DescribeDhcpOptionsRequest> {
    @Override
    public Request<DescribeDhcpOptionsRequest> marshall(DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        if (describeDhcpOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDhcpOptionsRequest> request = new DefaultRequest<DescribeDhcpOptionsRequest>(describeDhcpOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeDhcpOptions");
        request.addParameter("Version", "2014-06-15");
        List<String> dhcpOptionsIdsList = describeDhcpOptionsRequest.getDhcpOptionsIds();
        int dhcpOptionsIdsListIndex = 1;
        for (String dhcpOptionsIdsListValue : dhcpOptionsIdsList) {
            if (dhcpOptionsIdsListValue != null) {
                request.addParameter("DhcpOptionsId." + dhcpOptionsIdsListIndex, StringUtils.fromString(dhcpOptionsIdsListValue));
            }
            ++dhcpOptionsIdsListIndex;
        }
        List<Filter> filtersList = describeDhcpOptionsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

