/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListInstancesRequestMarshaller
implements Marshaller<Request<ListInstancesRequest>, ListInstancesRequest> {
    @Override
    public Request<ListInstancesRequest> marshall(ListInstancesRequest listInstancesRequest) {
        if (listInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInstancesRequest> request = new DefaultRequest<ListInstancesRequest>(listInstancesRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.ListInstances";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag instanceGroupTypesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listInstancesRequest.getClusterId() != null) {
                jsonWriter.key("ClusterId").value(listInstancesRequest.getClusterId());
            }
            if (listInstancesRequest.getInstanceGroupId() != null) {
                jsonWriter.key("InstanceGroupId").value(listInstancesRequest.getInstanceGroupId());
            }
            if (!((instanceGroupTypesList = (ListWithAutoConstructFlag)listInstancesRequest.getInstanceGroupTypes()) == null || instanceGroupTypesList.isAutoConstruct() && instanceGroupTypesList.isEmpty())) {
                jsonWriter.key("InstanceGroupTypes");
                jsonWriter.array();
                for (String instanceGroupTypesListValue : instanceGroupTypesList) {
                    if (instanceGroupTypesListValue == null) continue;
                    jsonWriter.value(instanceGroupTypesListValue);
                }
                jsonWriter.endArray();
            }
            if (listInstancesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listInstancesRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

