/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClustersRequestMarshaller
implements Marshaller<Request<DescribeClustersRequest>, DescribeClustersRequest> {
    @Override
    public Request<DescribeClustersRequest> marshall(DescribeClustersRequest describeClustersRequest) {
        if (describeClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClustersRequest> request = new DefaultRequest<DescribeClustersRequest>(describeClustersRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusters");
        request.addParameter("Version", "2012-12-01");
        if (describeClustersRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(describeClustersRequest.getClusterIdentifier()));
        }
        if (describeClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeClustersRequest.getMaxRecords()));
        }
        if (describeClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeClustersRequest.getMarker()));
        }
        return request;
    }
}

