/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

public class StringResponseHandler
implements ResponseHandler<StringResponse, RuntimeException> {
    private static final StringResponseHandler STRING_RESPONSE_HANDLER = new StringResponseHandler();

    public static StringResponseHandler createStringResponseHandler() {
        return STRING_RESPONSE_HANDLER;
    }

    private StringResponseHandler() {
    }

    @Override
    public StringResponse handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public StringResponse handle(Request request, Response response) {
        try {
            String contentType = response.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse((String)contentType);
                return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), (Charset)mediaType.charset().or((Object)Charsets.UTF_8)));
            }
            return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class StringResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;
        private final String body;

        public StringResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers, String body) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getBody() {
            return this.body;
        }

        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)name);
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }
    }
}

