/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;

public class JettyIoPool
implements Closeable {
    private final String name;
    private final QueuedThreadPool executor;
    private final ByteBufferPool byteBufferPool;
    private final Scheduler scheduler;

    public JettyIoPool(String name, JettyIoPoolConfig config) {
        this.name = name;
        try {
            String baseName = "http-client-" + name;
            ThreadGroup threadGroup = new ThreadGroup(baseName);
            JettyThreadPool threadPool = new JettyThreadPool(threadGroup, config);
            threadPool.setName(baseName);
            threadPool.setDaemon(true);
            threadPool.start();
            threadPool.setStopTimeout(2000L);
            this.executor = threadPool;
            this.scheduler = new JettyScheduler(threadGroup, baseName + "-scheduler");
            this.scheduler.start();
            this.byteBufferPool = new MappedByteBufferPool();
        }
        catch (Exception e) {
            this.close();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            JettyIoPool.closeQuietly((LifeCycle)this.executor);
        }
        finally {
            JettyIoPool.closeQuietly((LifeCycle)this.scheduler);
        }
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool setByteBufferPool() {
        return this.byteBufferPool;
    }

    public Scheduler setScheduler() {
        return this.scheduler;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    private static class JettyScheduler
    extends AbstractLifeCycle
    implements Scheduler {
        private final String name;
        private final ThreadGroup threadGroup;
        private volatile ScheduledThreadPoolExecutor scheduler;

        public JettyScheduler(ThreadGroup threadGroup, String name) {
            this.threadGroup = (ThreadGroup)Preconditions.checkNotNull((Object)threadGroup, (Object)"threadGroup is null");
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        }

        protected void doStart() throws Exception {
            this.scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(threadGroup, runnable);
                    thread.setName(name + "-" + thread.getId());
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.scheduler.setRemoveOnCancelPolicy(true);
            super.doStart();
        }

        protected void doStop() throws Exception {
            this.scheduler.shutdownNow();
            super.doStop();
            this.scheduler = null;
        }

        public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
            return new ScheduledFutureTask(this.scheduler.schedule(task, delay, unit));
        }

        private class ScheduledFutureTask
        implements Scheduler.Task {
            private final ScheduledFuture<?> scheduledFuture;

            public ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
                this.scheduledFuture = (ScheduledFuture)Preconditions.checkNotNull(scheduledFuture, (Object)"scheduledFuture is null");
            }

            public boolean cancel() {
                return this.scheduledFuture.cancel(false);
            }
        }
    }

    private static class JettyThreadPool
    extends QueuedThreadPool {
        private final ThreadGroup threadGroup;

        private JettyThreadPool(ThreadGroup threadGroup, JettyIoPoolConfig config) {
            super(config.getMaxThreads(), config.getMinThreads());
            this.threadGroup = (ThreadGroup)Preconditions.checkNotNull((Object)threadGroup, (Object)"threadGroup is null");
        }

        protected Thread newThread(Runnable runnable) {
            return new Thread(this.threadGroup, runnable);
        }
    }
}

