/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import org.weakref.jmx.guice.AnnotatedExportBinder;
import org.weakref.jmx.guice.MapExportBinder;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.Mapping;
import org.weakref.jmx.guice.NamedExportBinder;
import org.weakref.jmx.guice.SetExportBinder;
import org.weakref.jmx.guice.SetMapping;
import org.weakref.jmx.guice.StringMapExportBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportBinder {
    private final Multibinder<Mapping> binder;
    private final Multibinder<SetMapping<?>> collectionBinder;
    private final Multibinder<MapMapping<?, ?>> mapBinder;

    ExportBinder(Multibinder<Mapping> binder, Multibinder<SetMapping<?>> collectionBinder, Multibinder<MapMapping<?, ?>> mapBinder) {
        this.binder = binder;
        this.collectionBinder = collectionBinder;
        this.mapBinder = mapBinder;
    }

    public static ExportBinder newExporter(Binder binder) {
        Multibinder collectionBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<SetMapping<?>>(){});
        Multibinder mapBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<MapMapping<?, ?>>(){});
        return new ExportBinder((Multibinder<Mapping>)Multibinder.newSetBinder((Binder)binder, Mapping.class), collectionBinder, mapBinder);
    }

    public AnnotatedExportBinder export(Class<?> clazz) {
        return new AnnotatedExportBinder(this.binder, Key.get(clazz));
    }

    public NamedExportBinder export(Key<?> key) {
        return new NamedExportBinder(this.binder, key);
    }

    public <T> SetExportBinder<T> exportSet(Class<T> clazz) {
        return new SetExportBinder<T>(this.collectionBinder, clazz);
    }

    public <V> StringMapExportBinder<V> exportMap(Class<V> valueClass) {
        return new StringMapExportBinder<V>(this.mapBinder, valueClass);
    }

    public <K, V> MapExportBinder<K, V> exportMap(Class<K> keyClass, Class<V> valueClass) {
        return new MapExportBinder<K, V>(this.mapBinder, keyClass, valueClass);
    }
}

