/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;

public class ReaderWriterProfiler {
    private static final String HIVE_READER_WRITER_PROFILER_ENABLED_CONFIG = "hive.exec.profiler.readwrite";
    private static final boolean HIVE_READER_WRITER_PROFILER_ENABLED_DEFAULT = false;
    private static final String HIVE_READER_WRITER_PROFILER_USE_CPU_CONFIG = "hive.exec.profiler.readwrite.cpu";
    private static final boolean HIVE_READER_WRITER_PROFILER_USE_CPU_DEFAULT = false;
    private static boolean profile = false;
    private static boolean useCpuTime = false;
    private static ReaderWriterProfiler instance;
    protected static long[] profileStart;
    protected static int[] profileStarted;
    protected static int[] ended;
    protected static int[] started;
    protected static long[] profileTimes;
    protected static long[] profileTypeStart;
    protected static int[] profileTypeStarted;
    protected static int[] typeEnded;
    protected static int[] typeStarted;
    protected static long[] profileTypeTimes;
    public static final Log LOG;

    private ReaderWriterProfiler() {
    }

    public static void setProfilerOptions(Configuration conf) {
        if (conf != null) {
            if (conf.getBoolean(HIVE_READER_WRITER_PROFILER_ENABLED_CONFIG, false)) {
                profile = true;
                useCpuTime = conf.getBoolean(HIVE_READER_WRITER_PROFILER_USE_CPU_CONFIG, false);
            }
            instance = ReaderWriterProfiler.createInstance();
        }
        if (instance == null) {
            instance = ReaderWriterProfiler.createInstance();
        }
    }

    private static ReaderWriterProfiler createInstance() {
        if (profile) {
            if (useCpuTime) {
                return new CpuReaderWriterProfiler();
            }
            return new WalltimeReaderWriterProfiler();
        }
        return new ReaderWriterProfiler();
    }

    public static ReaderWriterProfiler getInstance() {
        return instance;
    }

    public static void start(Counter c) {
        instance.startProfiler(c);
    }

    public static void end(Counter c) {
        instance.endProfiler(c);
    }

    protected void startProfiler(Counter c) {
    }

    protected void endProfiler(Counter c) {
    }

    public static void log() {
        ReaderWriterProfiler.log(null);
    }

    public static void log(Reporter logReporter) {
        for (Counter c : Counter.values()) {
            LOG.info((Object)((Object)((Object)c) + " start (" + started[c.value] + "), end (" + ended[c.value] + "): " + profileTimes[c.value]));
            if (logReporter == null) continue;
            logReporter.incrCounter((Enum)c, profileTimes[c.value]);
        }
        long read = profileTypeTimes[Counter.Type.READ.ordinal()];
        long write = profileTypeTimes[Counter.Type.WRITE.ordinal()];
        if (logReporter != null) {
            LOG.info((Object)("read time: " + read));
            LOG.info((Object)("write time: " + write));
            logReporter.incrCounter((Enum)ReadWriteCounter.READ_TIME, read);
            logReporter.incrCounter((Enum)ReadWriteCounter.WRITE_TIME, write);
        }
    }

    static {
        profileStart = new long[6];
        profileStarted = new int[6];
        ended = new int[6];
        started = new int[6];
        profileTimes = new long[6];
        profileTypeStart = new long[2];
        profileTypeStarted = new int[2];
        typeEnded = new int[2];
        typeStarted = new int[2];
        profileTypeTimes = new long[2];
        LOG = LogFactory.getLog((String)ReaderWriterProfiler.class.getName());
    }

    private static class WalltimeReaderWriterProfiler
    extends ReaderWriterProfiler {
        private WalltimeReaderWriterProfiler() {
        }

        @Override
        protected void startProfiler(Counter c) {
            long time = -1L;
            if (profileStarted[c.value] == 0) {
                int n = c.value;
                started[n] = started[n] + 1;
                WalltimeReaderWriterProfiler.profileStart[((Counter)c).value] = time = System.nanoTime();
            }
            if (profileTypeStarted[c.type.ordinal()] == 0) {
                int n = c.type.ordinal();
                typeStarted[n] = typeStarted[n] + 1;
                if (time == -1L) {
                    time = System.nanoTime();
                }
                WalltimeReaderWriterProfiler.profileTypeStart[((Counter)c).type.ordinal()] = time;
            }
            int n = c.value;
            profileStarted[n] = profileStarted[n] + 1;
            int n2 = c.type.ordinal();
            profileTypeStarted[n2] = profileTypeStarted[n2] + 1;
        }

        @Override
        protected void endProfiler(Counter c) {
            int n = c.value;
            profileStarted[n] = profileStarted[n] - 1;
            int n2 = c.type.ordinal();
            profileTypeStarted[n2] = profileTypeStarted[n2] - 1;
            long time = -1L;
            if (profileStarted[c.value] == 0) {
                time = System.nanoTime();
                int n3 = c.value;
                profileTimes[n3] = profileTimes[n3] + (time - profileStart[c.value]);
                int n4 = c.value;
                ended[n4] = ended[n4] + 1;
            }
            if (profileTypeStarted[c.type.ordinal()] == 0) {
                if (time == -1L) {
                    time = System.nanoTime();
                }
                int n5 = c.type.ordinal();
                profileTypeTimes[n5] = profileTypeTimes[n5] + (time - profileTypeStart[c.type.ordinal()]);
                int n6 = c.type.ordinal();
                typeEnded[n6] = typeEnded[n6] + 1;
            }
        }
    }

    private static class CpuReaderWriterProfiler
    extends ReaderWriterProfiler {
        private final ThreadMXBean BEAN = ManagementFactory.getThreadMXBean();
        private final long mainThreadId = this.getMainThreadId();

        private long getMainThreadId() {
            long[] ids = this.BEAN.getAllThreadIds();
            ThreadInfo[] infos = this.BEAN.getThreadInfo(ids);
            for (int i = 0; i < infos.length; ++i) {
                String threadName = infos[i].getThreadName();
                if (!threadName.equals("main")) continue;
                return ids[i];
            }
            return -1L;
        }

        private long getCpuTime(long mainThreadId) {
            return this.BEAN.isCurrentThreadCpuTimeSupported() ? this.BEAN.getThreadCpuTime(mainThreadId) : 0L;
        }

        @Override
        protected void startProfiler(Counter c) {
            long cpuTime = -1L;
            if (profileStarted[c.value] == 0) {
                int n = c.value;
                started[n] = started[n] + 1;
                CpuReaderWriterProfiler.profileStart[((Counter)c).value] = cpuTime = this.getCpuTime(this.mainThreadId);
            }
            if (profileTypeStarted[c.type.ordinal()] == 0) {
                int n = c.type.ordinal();
                typeStarted[n] = typeStarted[n] + 1;
                if (cpuTime == -1L) {
                    cpuTime = this.getCpuTime(this.mainThreadId);
                }
                CpuReaderWriterProfiler.profileTypeStart[((Counter)c).type.ordinal()] = cpuTime;
            }
            int n = c.value;
            profileStarted[n] = profileStarted[n] + 1;
            int n2 = c.type.ordinal();
            profileTypeStarted[n2] = profileTypeStarted[n2] + 1;
        }

        @Override
        protected void endProfiler(Counter c) {
            int n = c.value;
            profileStarted[n] = profileStarted[n] - 1;
            int n2 = c.type.ordinal();
            profileTypeStarted[n2] = profileTypeStarted[n2] - 1;
            long cpuTime = -1L;
            if (profileStarted[c.value] == 0) {
                cpuTime = this.getCpuTime(this.mainThreadId);
                int n3 = c.value;
                profileTimes[n3] = profileTimes[n3] + (cpuTime - profileStart[c.value]);
                int n4 = c.value;
                ended[n4] = ended[n4] + 1;
            }
            if (profileTypeStarted[c.type.ordinal()] == 0) {
                if (cpuTime == -1L) {
                    cpuTime = this.getCpuTime(this.mainThreadId);
                }
                int n5 = c.type.ordinal();
                profileTypeTimes[n5] = profileTypeTimes[n5] + (cpuTime - profileTypeStart[c.type.ordinal()]);
                int n6 = c.type.ordinal();
                typeEnded[n6] = typeEnded[n6] + 1;
            }
        }
    }

    public static enum ReadWriteCounter {
        READ_TIME,
        WRITE_TIME;

    }

    public static enum Counter {
        DECOMPRESSION_TIME(0, Type.READ),
        COMPRESSION_TIME(1, Type.WRITE),
        SERIALIZATION_TIME(2, Type.WRITE),
        DESERIALIZATION_TIME(3, Type.READ),
        DECODING_TIME(4, Type.READ),
        ENCODING_TIME(5, Type.WRITE);

        private int value;
        private Type type;

        private Counter(int v, Type type) {
            this.value = v;
            this.type = type;
        }

        public static enum Type {
            READ,
            WRITE;

        }
    }
}

