/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class StreamDescriptor {
    private final String streamName;
    private final int streamId;
    private final OrcType.OrcTypeKind streamType;
    private final String fieldName;
    private final OrcDataSource fileInput;
    private final List<StreamDescriptor> nestedStreams;

    public StreamDescriptor(String streamName, int streamId, String fieldName, OrcType.OrcTypeKind streamType, OrcDataSource fileInput, List<StreamDescriptor> nestedStreams) {
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName, (Object)"streamName is null");
        this.streamId = streamId;
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName is null");
        this.streamType = (OrcType.OrcTypeKind)((Object)Preconditions.checkNotNull((Object)((Object)streamType), (Object)"type is null"));
        this.fileInput = (OrcDataSource)Preconditions.checkNotNull((Object)fileInput, (Object)"fileInput is null");
        this.nestedStreams = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(nestedStreams, (Object)"nestedStreams is null")));
    }

    public String getStreamName() {
        return this.streamName;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public OrcType.OrcTypeKind getStreamType() {
        return this.streamType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public OrcDataSource getFileInput() {
        return this.fileInput;
    }

    public List<StreamDescriptor> getNestedStreams() {
        return this.nestedStreams;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("streamName", (Object)this.streamName).add("streamId", this.streamId).add("streamType", (Object)this.streamType).add("path", (Object)this.fileInput).toString();
    }
}

