/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.lazy.OrcLazyMap;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;

public class OrcLazyMapObjectInspector
implements MapObjectInspector {
    private final ObjectInspector key;
    private final ObjectInspector value;

    public OrcLazyMapObjectInspector(MapTypeInfo info) {
        this.key = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getMapKeyTypeInfo());
        this.value = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getMapValueTypeInfo());
    }

    public OrcLazyMapObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        this.key = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(0), types);
        this.value = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(1), types);
    }

    public Map<?, ?> getMap(Object data) {
        if (data == null) {
            return null;
        }
        try {
            return (Map)((OrcLazyMap)data).materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectInspector getMapKeyObjectInspector() {
        return this.key;
    }

    public int getMapSize(Object data) {
        return this.getMap(data).size();
    }

    public Object getMapValueElement(Object data, Object key) {
        return this.getMap(data).get(key);
    }

    public ObjectInspector getMapValueObjectInspector() {
        return this.value;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }

    public String getTypeName() {
        return "map<" + this.key.getTypeName() + "," + this.value.getTypeName() + ">";
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        OrcLazyMapObjectInspector other = (OrcLazyMapObjectInspector)o;
        return other.key.equals(this.key) && other.value.equals(this.value);
    }
}

