/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyStructTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import com.facebook.hive.orc.lazy.OrcLazyStruct;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class OrcLazyRow
extends OrcLazyStruct {
    private OrcLazyObject[] fields;
    private final List<String> fieldNames;

    public OrcLazyRow(OrcLazyObject[] fields, List<String> fieldNames) {
        super((LazyStructTreeReader)null);
        this.fields = fields;
        this.fieldNames = fieldNames;
    }

    @Override
    public void next() {
        super.next();
        for (OrcLazyObject field : this.fields) {
            if (field == null) continue;
            field.next();
        }
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        for (OrcLazyObject field : this.fields) {
            if (field == null) continue;
            field.startStripe(streams, encodings, indexes, rowBaseInStripe);
        }
    }

    @Override
    public Object materialize(long row, Object previous) throws IOException {
        OrcStruct previousRow;
        if (previous != null) {
            previousRow = (OrcStruct)previous;
            previousRow.setFieldNames(this.fieldNames);
        } else {
            previousRow = new OrcStruct(this.fieldNames);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            previousRow.setFieldValue(i, this.fields[i]);
        }
        return previousRow;
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        for (OrcLazyObject field : this.fields) {
            if (field == null) continue;
            field.seekToRow(rowNumber);
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public OrcLazyObject getFieldValue(int index) {
        if (index >= this.fields.length) {
            return null;
        }
        return this.fields[index];
    }

    public void reset(OrcLazyRow other) throws IOException {
        this.fields = other.getRawFields();
        this.seekToRow(0L);
    }

    protected OrcLazyObject[] getRawFields() {
        return this.fields;
    }

    @Override
    public void close() throws IOException {
        for (OrcLazyObject field : this.fields) {
            if (field == null) continue;
            field.close();
        }
    }
}

