/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.ReflectionUtils;

public final class PrestoFileSystemCache
extends FileSystem.Cache {
    private final Map<FileSystem.Cache.Key, FileSystem> map = PrestoFileSystemCache.getPrivateMap(this);

    @Override
    FileSystem get(URI uri, Configuration conf) throws IOException {
        return this.getInternal(uri, conf, new FileSystem.Cache.Key(uri, conf));
    }

    private synchronized FileSystem getInternal(URI uri, Configuration conf, FileSystem.Cache.Key key) throws IOException {
        FileSystem fs = this.map.get(key);
        if (fs != null) {
            return fs;
        }
        fs = PrestoFileSystemCache.createFileSystem(uri, conf);
        this.map.put(key, fs);
        return fs;
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<?> clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance(clazz, conf);
        fs.initialize(uri, conf);
        return fs;
    }

    private static Map<FileSystem.Cache.Key, FileSystem> getPrivateMap(FileSystem.Cache cache) {
        try {
            Field field = FileSystem.Cache.class.getDeclaredField("map");
            field.setAccessible(true);
            return (Map)field.get(cache);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

