/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hadoop.shaded.org.apache.commons.net.util.SubnetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.SocketIOWithTimeout;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ReflectionUtils;

public class NetUtils {
    private static final Log LOG = LogFactory.getLog(NetUtils.class);
    private static Map<String, String> hostToResolved = new HashMap<String, String>();
    private static ConcurrentHashMap<String, String> canonicalizedHostCache = new ConcurrentHashMap();

    public static SocketFactory getSocketFactory(Configuration conf, Class<?> clazz) {
        SocketFactory factory = null;
        String propValue = conf.get("hadoop.rpc.socket.factory.class." + clazz.getSimpleName());
        if (propValue != null && propValue.length() > 0) {
            factory = NetUtils.getSocketFactoryFromProperty(conf, propValue);
        }
        if (factory == null) {
            factory = NetUtils.getDefaultSocketFactory(conf);
        }
        return factory;
    }

    public static SocketFactory getDefaultSocketFactory(Configuration conf) {
        String propValue = conf.get("hadoop.rpc.socket.factory.class.default");
        if (propValue == null || propValue.length() == 0) {
            return SocketFactory.getDefault();
        }
        return NetUtils.getSocketFactoryFromProperty(conf, propValue);
    }

    public static SocketFactory getSocketFactoryFromProperty(Configuration conf, String propValue) {
        try {
            Class<?> theClass = conf.getClassByName(propValue);
            return (SocketFactory)ReflectionUtils.newInstance(theClass, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Socket Factory class not found: " + cnfe);
        }
    }

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        if (target == null) {
            throw new IllegalArgumentException("Socket address is null");
        }
        boolean hasScheme = target.contains("://");
        URI uri = null;
        try {
            uri = hasScheme ? URI.create(target) : URI.create("dummyscheme://" + target);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Does not contain a valid host:port authority: " + target);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        String path = uri.getPath();
        if (host == null || port < 0 || !hasScheme && path != null && !path.isEmpty()) {
            throw new IllegalArgumentException("Does not contain a valid host:port authority: " + target);
        }
        return NetUtils.makeSocketAddr(host, port);
    }

    public static InetSocketAddress makeSocketAddr(String host, int port) {
        InetSocketAddress addr;
        String staticHost = NetUtils.getStaticResolution(host);
        String resolveHost = staticHost != null ? staticHost : host;
        try {
            InetAddress iaddr = SecurityUtil.getByName(resolveHost);
            if (staticHost != null) {
                iaddr = InetAddress.getByAddress(host, iaddr.getAddress());
            }
            addr = new InetSocketAddress(iaddr, port);
        }
        catch (UnknownHostException e) {
            addr = InetSocketAddress.createUnresolved(host, port);
        }
        return addr;
    }

    public static URI getCanonicalUri(URI uri, int defaultPort) {
        String host = uri.getHost();
        if (host == null) {
            return uri;
        }
        String fqHost = NetUtils.canonicalizeHost(host);
        int port = uri.getPort();
        if (host.equals(fqHost) && port != -1) {
            return uri;
        }
        try {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), fqHost, port == -1 ? defaultPort : port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    private static String canonicalizeHost(String host) {
        String fqHost = canonicalizedHostCache.get(host);
        if (fqHost == null) {
            try {
                fqHost = SecurityUtil.getByName(host).getHostName();
                canonicalizedHostCache.put(host, fqHost);
            }
            catch (UnknownHostException e) {
                fqHost = host;
            }
        }
        return fqHost;
    }

    @Deprecated
    public static String getServerAddress(Configuration conf, String oldBindAddressName, String oldPortName, String newBindAddressName) {
        String oldAddr = conf.get(oldBindAddressName);
        String oldPort = conf.get(oldPortName);
        String newAddrPort = conf.get(newBindAddressName);
        if (oldAddr == null && oldPort == null) {
            return newAddrPort;
        }
        String[] newAddrPortParts = newAddrPort.split(":", 2);
        if (newAddrPortParts.length != 2) {
            throw new IllegalArgumentException("Invalid address/port: " + newAddrPort);
        }
        if (oldAddr == null) {
            oldAddr = newAddrPortParts[0];
        } else {
            LOG.warn("Configuration parameter " + oldBindAddressName + " is deprecated. Use " + newBindAddressName + " instead.");
        }
        if (oldPort == null) {
            oldPort = newAddrPortParts[1];
        } else {
            LOG.warn("Configuration parameter " + oldPortName + " is deprecated. Use " + newBindAddressName + " instead.");
        }
        return oldAddr + ":" + oldPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticResolution(String host, String resolvedName) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            hostToResolved.put(host, resolvedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResolution(String host) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            return hostToResolved.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllStaticResolutions() {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            Set<Map.Entry<String, String>> entries = hostToResolved.entrySet();
            if (entries.size() == 0) {
                return null;
            }
            ArrayList<String[]> l = new ArrayList<String[]>(entries.size());
            for (Map.Entry<String, String> e : entries) {
                l.add(new String[]{e.getKey(), e.getValue()});
            }
            return l;
        }
    }

    public static InetSocketAddress getConnectAddress(Server server) {
        InetSocketAddress addr = server.getListenerAddress();
        if (addr.getAddress().isAnyLocalAddress()) {
            addr = NetUtils.makeSocketAddr("127.0.0.1", addr.getPort());
        }
        return addr;
    }

    public static InputStream getInputStream(Socket socket) throws IOException {
        return NetUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static InputStream getInputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getInputStream() : new SocketInputStream(socket, timeout);
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return NetUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getOutputStream() : new SocketOutputStream(socket, timeout);
    }

    public static void connect(Socket socket, SocketAddress address, int timeout) throws IOException {
        NetUtils.connect(socket, address, null, timeout);
    }

    public static void connect(Socket socket, SocketAddress endpoint, SocketAddress localAddr, int timeout) throws IOException {
        if (socket == null || endpoint == null || timeout < 0) {
            throw new IllegalArgumentException("Illegal argument for connect()");
        }
        SocketChannel ch = socket.getChannel();
        if (localAddr != null) {
            socket.bind(localAddr);
        }
        if (ch == null) {
            socket.connect(endpoint, timeout);
        } else {
            SocketIOWithTimeout.connect(ch, endpoint, timeout);
        }
        if (socket.getLocalPort() == socket.getPort() && socket.getLocalAddress().equals(socket.getInetAddress())) {
            LOG.info("Detected a loopback TCP socket, disconnecting it");
            socket.close();
            throw new ConnectException("Localhost targeted connection resulted in a loopback. No daemon is listening on the target port.");
        }
    }

    public static String normalizeHostName(String name) {
        try {
            InetAddress ipAddress = InetAddress.getByName(name);
            return ipAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static void verifyHostnames(String[] names) throws UnknownHostException {
        for (String name : names) {
            if (name == null) {
                throw new UnknownHostException("null hostname found");
            }
            URI uri = null;
            try {
                uri = new URI(name);
                if (uri.getHost() == null) {
                    uri = new URI("http://" + name);
                }
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null && uri.getHost() != null) continue;
            throw new UnknownHostException(name + " is not a valid Inet address");
        }
    }

    public static InetAddress getLocalInetAddress(String host) throws SocketException {
        if (host == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
            if (NetworkInterface.getByInetAddress(addr) == null) {
                addr = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }

    public static boolean isValidSubnet(String subnet) {
        try {
            new SubnetUtils(subnet);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private static void addMatchingAddrs(NetworkInterface nif, SubnetUtils.SubnetInfo subnetInfo, List<InetAddress> addrs) {
        Enumeration<InetAddress> ifAddrs = nif.getInetAddresses();
        while (ifAddrs.hasMoreElements()) {
            InetAddress ifAddr = ifAddrs.nextElement();
            if (!subnetInfo.isInRange(ifAddr.getHostAddress())) continue;
            addrs.add(ifAddr);
        }
    }

    public static List<InetAddress> getIPs(String subnet, boolean returnSubinterfaces) {
        Enumeration<NetworkInterface> nifs;
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(subnet).getInfo();
        try {
            nifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOG.error("Unable to get host interfaces", e);
            return addrs;
        }
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            NetUtils.addMatchingAddrs(nif, subnetInfo, addrs);
            if (!returnSubinterfaces) continue;
            Enumeration<NetworkInterface> subNifs = nif.getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetUtils.addMatchingAddrs(subNifs.nextElement(), subnetInfo, addrs);
            }
        }
        return addrs;
    }
}

