/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.shaded.org.apache.commons.codec.binary.Base64;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

class ColumnarTextHiveRecordCursor<K>
extends HiveRecordCursor {
    private final RecordReader<K, BytesRefArrayWritable> recordReader;
    private final K key;
    private final BytesRefArrayWritable value;
    private final String[] names;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final ObjectInspector[] fieldInspectors;
    private final int[] hiveColumnIndexes;
    private final boolean[] isPartitionColumn;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final boolean[] nulls;
    private final long totalBytes;
    private final DateTimeZone hiveStorageTimeZone;
    private final DateTimeZone sessionTimeZone;
    private long completedBytes;
    private boolean closed;

    public ColumnarTextHiveRecordCursor(RecordReader<K, BytesRefArrayWritable> recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, TypeManager typeManager) {
        Preconditions.checkNotNull(recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null");
        Preconditions.checkNotNull((Object)sessionTimeZone, (Object)"sessionTimeZone is null");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (BytesRefArrayWritable)recordReader.createValue();
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.sessionTimeZone = sessionTimeZone;
        int size = columns.size();
        this.names = new String[size];
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.hiveColumnIndexes = new int[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.nulls = new boolean[size];
        StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(splitSchema);
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            this.names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            if (!column.isPartitionKey()) {
                this.fieldInspectors[i] = rowInspector.getStructFieldRef(column.getName()).getFieldObjectInspector();
            }
            this.hiveColumnIndexes[i] = column.getHiveColumnIndex();
            this.isPartitionColumn[i] = column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
            String name = this.names[columnIndex];
            Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.datePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, name);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, (Object)this.value)) {
                this.close();
                return false;
            }
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseBooleanColumn(column, bytes, start, length);
        }
    }

    private void parseBooleanColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (HiveBooleanParser.isTrue(bytes, start, length)) {
            this.booleans[column] = true;
            wasNull = false;
        } else if (HiveBooleanParser.isFalse(bytes, start, length)) {
            this.booleans[column] = false;
            wasNull = false;
        } else {
            wasNull = true;
        }
        this.nulls[column] = wasNull;
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!(this.types[fieldId].equals(BigintType.BIGINT) || this.types[fieldId].equals(DateType.DATE) || this.types[fieldId].equals(TimestampType.TIMESTAMP))) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, %s or %s , actual %s (field %s)", BigintType.BIGINT, DateType.DATE, TimestampType.TIMESTAMP, this.types[fieldId], fieldId));
        }
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseLongColumn(column, bytes, start, length);
        }
    }

    private void parseLongColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == 0 || length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_DATE)) {
            String value = new String(bytes, start, length);
            this.longs[column] = HiveUtil.parseHiveDate(value);
            wasNull = false;
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_TIMESTAMP)) {
            String value = new String(bytes, start, length);
            this.longs[column] = HiveUtil.parseHiveTimestamp(value, this.hiveStorageTimeZone);
            wasNull = false;
        } else {
            this.longs[column] = NumberParser.parseLong(bytes, start, length);
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseDoubleColumn(column, bytes, start, length);
        }
    }

    private void parseDoubleColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == 0 || length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else {
            this.doubles[column] = NumberParser.parseDouble(bytes, start, length);
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseStringColumn(column, bytes, start, length);
        }
    }

    private void parseStringColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
            LazyObject lazyObject = LazyFactory.createLazyObject((ObjectInspector)this.fieldInspectors[column]);
            ByteArrayRef byteArrayRef = new ByteArrayRef();
            byteArrayRef.setData(bytes);
            lazyObject.init(byteArrayRef, start, length);
            this.slices[column] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, lazyObject.getObject(), this.fieldInspectors[column]));
            wasNull = false;
        } else {
            this.slices[column] = Slices.wrappedBuffer((byte[])Arrays.copyOfRange(bytes, start, start + length));
            if (this.hiveTypes[column].equals(HiveType.HIVE_BINARY)) {
                this.slices[column] = Slices.wrappedBuffer((byte[])Base64.decodeBase64((byte[])this.slices[column].getBytes()));
            }
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (type.equals(BooleanType.BOOLEAN)) {
            this.parseBooleanColumn(column);
        } else if (type.equals(BigintType.BIGINT)) {
            this.parseLongColumn(column);
        } else if (type.equals(DoubleType.DOUBLE)) {
            this.parseDoubleColumn(column);
        } else if (VarcharType.VARCHAR.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseStringColumn(column);
        } else if (type.equals(DateType.DATE)) {
            this.parseLongColumn(column);
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            this.parseLongColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Class<?> type) {
        if (!this.types[fieldId].getJavaType().equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

