/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class HiveHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public HiveHandleResolver(HiveConnectorId connectorId) {
        this.connectorId = ((HiveConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof HiveTableHandle && ((HiveTableHandle)tableHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof HiveColumnHandle && ((HiveColumnHandle)columnHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof HiveSplit && ((HiveSplit)split).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorOutputTableHandle handle) {
        return handle instanceof HiveOutputTableHandle && ((HiveOutputTableHandle)handle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return HiveTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return HiveColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return HiveSplit.class;
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        return HiveOutputTableHandle.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }
}

