/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TypeJsonUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class HiveRecordSink
implements RecordSink {
    private final int fieldCount;
    private final Serializer serializer;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final List<Type> columnTypes;
    private final Object row;
    private final int sampleWeightField;
    private final ConnectorSession connectorSession;
    private int field = -1;

    public HiveRecordSink(HiveOutputTableHandle handle, Path target, JobConf conf) {
        this.fieldCount = handle.getColumnNames().size();
        this.sampleWeightField = handle.getColumnNames().indexOf("__presto__sample_weight__");
        this.columnTypes = ImmutableList.copyOf(handle.getColumnTypes());
        this.connectorSession = handle.getConnectorSession();
        Iterable hiveTypeNames = Iterables.transform((Iterable)Iterables.transform(handle.getColumnTypes(), HiveType::toHiveType), HiveType::getHiveTypeName);
        Properties properties = new Properties();
        properties.setProperty("columns", Joiner.on((char)',').join(handle.getColumnNames()));
        properties.setProperty("columns.types", Joiner.on((char)':').join(hiveTypeNames));
        this.serializer = HiveRecordSink.initializeSerializer((Configuration)conf, properties, handle.getHiveStorageFormat().getSerDe());
        this.recordWriter = HiveRecordSink.createRecordWriter(target, conf, properties, handle.getHiveStorageFormat().getOutputFormat());
        this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector(handle.getColumnNames(), HiveRecordSink.getJavaObjectInspectors(this.columnTypes));
        this.structFields = ImmutableList.copyOf((Collection)this.tableInspector.getAllStructFieldRefs());
        this.row = this.tableInspector.create();
    }

    public void beginRecord(long sampleWeight) {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        if (this.sampleWeightField >= 0) {
            this.tableInspector.setStructFieldData(this.row, this.structFields.get(this.sampleWeightField), (Object)sampleWeight);
        }
        this.field = 0;
        if (this.sampleWeightField == 0) {
            ++this.field;
        }
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.fieldCount ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        try {
            this.recordWriter.write(this.serializer.serialize(this.row, (ObjectInspector)this.tableInspector));
        }
        catch (IOException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendNull() {
        this.append(null);
    }

    public void appendBoolean(boolean value) {
        this.append(value);
    }

    public void appendLong(long value) {
        Type type = this.columnTypes.get(this.field);
        if (type == DateType.DATE) {
            this.append(new Date(TimeUnit.DAYS.toMillis(value)));
        } else if (type == TimestampType.TIMESTAMP) {
            this.append(new Timestamp(value));
        } else {
            this.append(value);
        }
    }

    public void appendDouble(double value) {
        this.append(value);
    }

    public void appendString(byte[] value) {
        Type type = this.columnTypes.get(this.field);
        if (type == VarbinaryType.VARBINARY) {
            this.append(value);
        } else {
            this.append(new String(value, StandardCharsets.UTF_8));
        }
    }

    public Collection<Slice> commit() {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"record not finished");
        try {
            this.recordWriter.close(false);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return ImmutableList.of();
    }

    public void rollback() {
        try {
            this.recordWriter.close(true);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    private void append(Object value) {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.fieldCount ? 1 : 0) != 0, (Object)"all fields already set");
        Type type = this.columnTypes.get(this.field);
        if (HiveUtil.isMapType(type) || HiveUtil.isArrayType(type)) {
            value = TypeJsonUtils.stackRepresentationToObject(this.connectorSession, (String)value, type);
        }
        this.tableInspector.setStructFieldData(this.row, this.structFields.get(this.field), value);
        ++this.field;
        if (this.field == this.sampleWeightField) {
            ++this.field;
        }
    }

    private static Serializer initializeSerializer(Configuration conf, Properties properties, String serializerName) {
        try {
            Serializer result = (Serializer)Class.forName(serializerName).getConstructor(new Class[0]).newInstance(new Object[0]);
            result.initialize(conf, properties);
            return result;
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, JobConf conf, Properties properties, String outputFormatName) {
        try {
            Object writer = Class.forName(outputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            return ((HiveOutputFormat)writer).getHiveRecordWriter(conf, target, Text.class, false, properties, (Progressable)Reporter.NULL);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<ObjectInspector> getJavaObjectInspectors(Iterable<Type> types) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (Type type : types) {
            list.add((Object)HiveRecordSink.getJavaObjectInspector(type));
        }
        return list.build();
    }

    private static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (HiveUtil.isArrayType(type)) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)HiveRecordSink.getJavaObjectInspector((Type)type.getTypeParameters().get(0)));
        }
        if (HiveUtil.isMapType(type)) {
            ObjectInspector keyObjectInspector = HiveRecordSink.getJavaObjectInspector((Type)type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = HiveRecordSink.getJavaObjectInspector((Type)type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static boolean isTypeSupported(Type type) {
        try {
            HiveRecordSink.getJavaObjectInspector(type);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

