/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HiveRecordSink;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.RecordSink;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class HiveRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveRecordSinkProvider(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = (HdfsEnvironment)Preconditions.checkNotNull((Object)hdfsEnvironment, (Object)"hdfsEnvironment is null");
    }

    public RecordSink getRecordSink(ConnectorOutputTableHandle tableHandle) {
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        Path target = new Path(handle.getTemporaryPath(), UUID.randomUUID().toString());
        JobConf conf = new JobConf(this.hdfsEnvironment.getConfiguration(target));
        return new HiveRecordSink(handle, target, conf);
    }

    public RecordSink getRecordSink(ConnectorInsertTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }
}

