/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplitSourceProvider;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.joda.time.DateTimeZone;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    private static final String PARTITION_VALUE_WILDCARD = "";
    private static final Logger log = Logger.get(HiveSplitManager.class);
    private final String connectorId;
    private final HiveMetastore metastore;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final DateTimeZone timeZone;
    private final Executor executor;
    private final int maxOutstandingSplits;
    private final int maxSplitIteratorThreads;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final int maxInitialSplits;
    private final boolean forceLocalScheduling;
    private final boolean recursiveDfsWalkerEnabled;
    private final boolean assumeCanonicalPartitionKeys;

    @Inject
    public HiveSplitManager(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService) {
        this(connectorId, metastore, namenodeStats, hdfsEnvironment, directoryLister, DateTimeZone.forTimeZone((TimeZone)hiveClientConfig.getTimeZone()), (Executor)new BoundedExecutor((Executor)executorService, hiveClientConfig.getMaxGlobalSplitIteratorThreads()), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMaxSplitIteratorThreads(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getMaxSplitSize(), hiveClientConfig.getMaxInitialSplitSize(), hiveClientConfig.getMaxInitialSplits(), hiveClientConfig.isForceLocalScheduling(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), false);
    }

    public HiveSplitManager(HiveConnectorId connectorId, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, DateTimeZone timeZone, Executor executor, int maxOutstandingSplits, int maxSplitIteratorThreads, int minPartitionBatchSize, int maxPartitionBatchSize, DataSize maxSplitSize, DataSize maxInitialSplitSize, int maxInitialSplits, boolean forceLocalScheduling, boolean assumeCanonicalPartitionKeys, boolean recursiveDfsWalkerEnabled) {
        this.connectorId = ((HiveConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.metastore = (HiveMetastore)Preconditions.checkNotNull((Object)metastore, (Object)"metastore is null");
        this.namenodeStats = (NamenodeStats)Preconditions.checkNotNull((Object)namenodeStats, (Object)"namenodeStats is null");
        this.hdfsEnvironment = (HdfsEnvironment)Preconditions.checkNotNull((Object)hdfsEnvironment, (Object)"hdfsEnvironment is null");
        this.directoryLister = (DirectoryLister)Preconditions.checkNotNull((Object)directoryLister, (Object)"directoryLister is null");
        this.timeZone = (DateTimeZone)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxSplitSize = (DataSize)Preconditions.checkNotNull((Object)maxSplitSize, (Object)"maxSplitSize is null");
        this.maxInitialSplitSize = (DataSize)Preconditions.checkNotNull((Object)maxInitialSplitSize, (Object)"maxInitialSplitSize is null");
        this.maxInitialSplits = maxInitialSplits;
        this.forceLocalScheduling = forceLocalScheduling;
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull(effectivePredicate, (Object)"effectivePredicate is null");
        if (effectivePredicate.isNone()) {
            return new ConnectorPartitionResult((List)ImmutableList.of(), TupleDomain.none());
        }
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Table table = this.getTable(tableName);
        Optional<HiveBucketing.HiveBucket> bucket = HiveBucketing.getHiveBucket(table, effectivePredicate.extractFixedValues());
        TupleDomain<HiveColumnHandle> compactEffectivePredicate = HiveSplitManager.toCompactTupleDomain(effectivePredicate);
        if (table.getPartitionKeys().isEmpty()) {
            return new ConnectorPartitionResult((List)ImmutableList.of((Object)new HivePartition(tableName, compactEffectivePredicate, bucket)), effectivePredicate);
        }
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(this.connectorId, table, 0);
        List<String> partitionNames = this.getFilteredPartitionNames(tableName, partitionColumns, effectivePredicate);
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (String partitionName : partitionNames) {
            Optional<Map<ConnectorColumnHandle, SerializableNativeValue>> values = this.parseValuesAndFilterPartition(partitionName, partitionColumns, effectivePredicate);
            if (!values.isPresent()) continue;
            partitions.add((Object)new HivePartition(tableName, compactEffectivePredicate, partitionName, values.get(), bucket));
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)effectivePredicate.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
        return new ConnectorPartitionResult((List)partitions.build(), remainingTupleDomain);
    }

    private static TupleDomain<HiveColumnHandle> toCompactTupleDomain(TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : effectivePredicate.getDomains().entrySet()) {
            HiveColumnHandle hiveColumnHandle = Types.checkType(entry.getKey(), HiveColumnHandle.class, "ColumnHandle");
            SortedRangeSet ranges = ((Domain)entry.getValue()).getRanges();
            if (!ranges.isNone()) {
                ranges = SortedRangeSet.of((Range)((Domain)entry.getValue()).getRanges().getSpan(), (Range[])new Range[0]);
            }
            builder.put((Object)hiveColumnHandle, (Object)new Domain(ranges, ((Domain)entry.getValue()).isNullAllowed()));
        }
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    private Optional<Map<ConnectorColumnHandle, SerializableNativeValue>> parseValuesAndFilterPartition(String partitionName, List<HiveColumnHandle> partitionColumns, TupleDomain<ConnectorColumnHandle> predicate) {
        List<String> partitionValues = HiveSplitManager.extractPartitionKeyValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            SerializableNativeValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), column.getHiveType(), this.timeZone);
            Domain allowedDomain = (Domain)predicate.getDomains().get(column);
            if (allowedDomain != null && !allowedDomain.includesValue(parsedValue.getValue())) {
                return Optional.empty();
            }
            builder.put((Object)column, (Object)parsedValue);
        }
        return Optional.of(builder.build());
    }

    private Table getTable(SchemaTableName tableName) {
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            String protectMode = (String)table.getParameters().get(ProtectMode.PARAMETER_NAME);
            if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                throw new TableOfflineException(tableName);
            }
            String prestoOffline = (String)table.getParameters().get(PRESTO_OFFLINE);
            if (!Strings.isNullOrEmpty((String)prestoOffline)) {
                throw new TableOfflineException(tableName, String.format("Table '%s' is offline for Presto: %s", tableName, prestoOffline));
            }
            return table;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    private List<String> getFilteredPartitionNames(SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ConnectorColumnHandle> effectivePredicate) {
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)effectivePredicate.getDomains().get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Comparable value = domain.getNullableSingleValue();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (value instanceof Slice) {
                    filter.add(((Slice)value).toStringUtf8());
                    continue;
                }
                if (value instanceof Boolean || value instanceof Double || value instanceof Long) {
                    if (this.assumeCanonicalPartitionKeys) {
                        filter.add(value.toString());
                        continue;
                    }
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only Boolean, Double and Long partition keys are supported");
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        try {
            return this.metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filter);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    private static List<String> extractPartitionKeyValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object[])new Object[]{partitionName});
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> connectorPartitions) {
        Iterable<HivePartitionMetadata> hivePartitions;
        Table table;
        HiveTableHandle hiveTableHandle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        Preconditions.checkNotNull(connectorPartitions, (Object)"connectorPartitions is null");
        List partitions = Lists.transform(connectorPartitions, partition -> Types.checkType(partition, HivePartition.class, "partition"));
        HivePartition partition2 = (HivePartition)Iterables.getFirst((Iterable)partitions, null);
        if (partition2 == null) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        SchemaTableName tableName = partition2.getTableName();
        Optional<HiveBucketing.HiveBucket> bucket = partition2.getBucket();
        partitions = Ordering.natural().onResultOf(ConnectorPartition::getPartitionId).reverse().sortedCopy((Iterable)partitions);
        try {
            table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            hivePartitions = this.getPartitionMetadata(table, tableName, partitions);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
        return new HiveSplitSourceProvider(this.connectorId, table, hivePartitions, bucket, this.maxSplitSize, this.maxOutstandingSplits, this.maxSplitIteratorThreads, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, this.maxPartitionBatchSize, hiveTableHandle.getSession(), this.maxInitialSplitSize, this.maxInitialSplits, this.forceLocalScheduling, this.recursiveDfsWalkerEnabled).get();
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(final Table table, final SchemaTableName tableName, List<HivePartition> partitions) throws NoSuchObjectException {
        HivePartition firstPartition;
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (partitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(partitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, UnpartitionedPartition.UNPARTITIONED_PARTITION));
        }
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(partitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, (Function)new Function<List<HivePartition>, List<HivePartitionMetadata>>(){

            public List<HivePartitionMetadata> apply(List<HivePartition> partitionBatch) {
                Throwable exception = null;
                for (int attempt = 0; attempt < 10; ++attempt) {
                    try {
                        Map<String, Partition> partitions = HiveSplitManager.this.metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform(partitionBatch, ConnectorPartition::getPartitionId));
                        Preconditions.checkState((partitionBatch.size() == partitions.size() ? 1 : 0) != 0, (String)"expected %s partitions but found %s", (Object[])new Object[]{partitionBatch.size(), partitions.size()});
                        ImmutableList.Builder results = ImmutableList.builder();
                        for (HivePartition hivePartition : partitionBatch) {
                            Partition partition = partitions.get(hivePartition.getPartitionId());
                            Preconditions.checkState((partition != null ? 1 : 0) != 0, (String)"Partition %s was not loaded", (Object[])new Object[]{hivePartition.getPartitionId()});
                            String protectMode = (String)partition.getParameters().get(ProtectMode.PARAMETER_NAME);
                            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues());
                            if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                                throw new PartitionOfflineException(tableName, partName);
                            }
                            String prestoOffline = (String)partition.getParameters().get(HiveSplitManager.PRESTO_OFFLINE);
                            if (!Strings.isNullOrEmpty((String)prestoOffline)) {
                                throw new PartitionOfflineException(tableName, partName, String.format("Partition '%s' is offline for Presto: %s", partName, prestoOffline));
                            }
                            List tableColumns = table.getSd().getCols();
                            List partitionColumns = partition.getSd().getCols();
                            for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
                                String partitionType;
                                String tableType = ((FieldSchema)tableColumns.get(i)).getType();
                                if (tableType.equals(partitionType = ((FieldSchema)partitionColumns.get(i)).getType())) continue;
                                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Table '%s' partition '%s' column '%s' type '%s' does not match table column type '%s'", tableName, partName, ((FieldSchema)partitionColumns.get(i)).getName(), partitionType, tableType));
                            }
                            results.add((Object)new HivePartitionMetadata(hivePartition, partition));
                        }
                        return results.build();
                    }
                    catch (PrestoException | IllegalArgumentException | IllegalStateException | NullPointerException | NoSuchObjectException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (RuntimeException | MetaException e) {
                        exception = e;
                        log.debug("getPartitions attempt %s failed, will retry. Exception: %s", new Object[]{attempt, e.getMessage()});
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate((Throwable)e2);
                        }
                    }
                }
                assert (exception != null);
                throw Throwables.propagate(exception);
            }
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }
}

