/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class HiveType {
    public static final HiveType HIVE_BOOLEAN = new HiveType("boolean");
    public static final HiveType HIVE_BYTE = new HiveType("tinyint");
    public static final HiveType HIVE_SHORT = new HiveType("smallint");
    public static final HiveType HIVE_INT = new HiveType("int");
    public static final HiveType HIVE_LONG = new HiveType("bigint");
    public static final HiveType HIVE_FLOAT = new HiveType("float");
    public static final HiveType HIVE_DOUBLE = new HiveType("double");
    public static final HiveType HIVE_STRING = new HiveType("string");
    public static final HiveType HIVE_TIMESTAMP = new HiveType("timestamp");
    public static final HiveType HIVE_DATE = new HiveType("date");
    public static final HiveType HIVE_BINARY = new HiveType("binary");
    private static final Set<HiveType> SUPPORTED_HIVE_TYPES = ImmutableSet.of((Object)HIVE_BOOLEAN, (Object)HIVE_BYTE, (Object)HIVE_SHORT, (Object)HIVE_INT, (Object)HIVE_LONG, (Object)HIVE_FLOAT, (Object[])new HiveType[]{HIVE_DOUBLE, HIVE_STRING, HIVE_TIMESTAMP, HIVE_DATE, HIVE_BINARY});
    private final String hiveTypeName;
    private final ObjectInspector.Category category;

    private HiveType(String hiveTypeName) {
        this.hiveTypeName = (String)Preconditions.checkNotNull((Object)hiveTypeName, (Object)"hiveTypeName is null");
        this.category = TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeName).getCategory();
    }

    @JsonValue
    public String getHiveTypeName() {
        return this.hiveTypeName;
    }

    public ObjectInspector.Category getCategory() {
        return this.category;
    }

    public static HiveType getSupportedHiveType(String hiveTypeName) {
        HiveType hiveType = HiveType.getHiveType(hiveTypeName);
        Preconditions.checkArgument((hiveType != null ? 1 : 0) != 0, (Object)("Unknown Hive type: " + hiveTypeName));
        return hiveType;
    }

    @JsonCreator
    @Nullable
    public static HiveType getHiveType(String hiveTypeName) {
        HiveType hiveType = new HiveType(hiveTypeName);
        if (!HiveUtil.isStructuralType(hiveType) && !SUPPORTED_HIVE_TYPES.contains(hiveType)) {
            return null;
        }
        return hiveType;
    }

    public static HiveType getSupportedHiveType(ObjectInspector fieldInspector) {
        HiveType hiveType = HiveType.getHiveType(fieldInspector);
        Preconditions.checkArgument((hiveType != null ? 1 : 0) != 0, (Object)("Unknown Hive category: " + fieldInspector.getCategory()));
        return hiveType;
    }

    public static HiveType getHiveType(ObjectInspector fieldInspector) {
        return HiveType.getHiveType(fieldInspector.getTypeName());
    }

    public static HiveType toHiveType(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HIVE_BOOLEAN;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HIVE_LONG;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HIVE_DOUBLE;
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return HIVE_STRING;
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HIVE_BINARY;
        }
        if (DateType.DATE.equals((Object)type)) {
            return HIVE_DATE;
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return HIVE_TIMESTAMP;
        }
        if (HiveUtil.isArrayType(type)) {
            HiveType hiveElementType = HiveType.toHiveType((Type)type.getTypeParameters().get(0));
            return new HiveType(String.format("array<%s>", hiveElementType.getHiveTypeName()));
        }
        if (HiveUtil.isMapType(type)) {
            HiveType hiveKeyType = HiveType.toHiveType((Type)type.getTypeParameters().get(0));
            HiveType hiveValueType = HiveType.toHiveType((Type)type.getTypeParameters().get(1));
            return new HiveType(String.format("map<%s,%s>", hiveKeyType.getHiveTypeName(), hiveValueType.getHiveTypeName()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    public String toString() {
        return this.hiveTypeName;
    }

    public static Type getType(String hiveType) {
        switch (hiveType) {
            case "boolean": {
                return BooleanType.BOOLEAN;
            }
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "bigint": {
                return BigintType.BIGINT;
            }
            case "float": 
            case "double": {
                return DoubleType.DOUBLE;
            }
            case "string": {
                return VarcharType.VARCHAR;
            }
            case "timestamp": {
                return TimestampType.TIMESTAMP;
            }
            case "binary": {
                return VarbinaryType.VARBINARY;
            }
        }
        throw new IllegalArgumentException("Unsupported hive type " + hiveType);
    }

    @Nullable
    public static Type getType(ObjectInspector fieldInspector, TypeManager typeManager) {
        switch (fieldInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveObjectInspector)fieldInspector).getPrimitiveCategory();
                return HiveType.getPrimitiveType(primitiveCategory);
            }
            case MAP: {
                MapObjectInspector mapObjectInspector = Types.checkType(fieldInspector, MapObjectInspector.class, "fieldInspector");
                Type keyType = HiveType.getType(mapObjectInspector.getMapKeyObjectInspector(), typeManager);
                Type valueType = HiveType.getType(mapObjectInspector.getMapValueObjectInspector(), typeManager);
                if (keyType == null || valueType == null) {
                    return null;
                }
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
            }
            case LIST: {
                ListObjectInspector listObjectInspector = Types.checkType(fieldInspector, ListObjectInspector.class, "fieldInspector");
                Type elementType = HiveType.getType(listObjectInspector.getListElementObjectInspector(), typeManager);
                if (elementType == null) {
                    return null;
                }
                return typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType.getTypeSignature()), (List)ImmutableList.of());
            }
            case STRUCT: {
                StructObjectInspector structObjectInspector = Types.checkType(fieldInspector, StructObjectInspector.class, "fieldInspector");
                ArrayList<TypeSignature> fieldTypes = new ArrayList<TypeSignature>();
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (StructField field : structObjectInspector.getAllStructFieldRefs()) {
                    fieldNames.add(field.getFieldName());
                    Type fieldType = HiveType.getType(field.getFieldObjectInspector(), typeManager);
                    if (fieldType == null) {
                        return null;
                    }
                    fieldTypes.add(fieldType.getTypeSignature());
                }
                return typeManager.getParameterizedType("row", fieldTypes, fieldNames);
            }
        }
        throw new IllegalArgumentException("Unsupported hive type " + fieldInspector.getTypeName());
    }

    private static Type getPrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return BigintType.BIGINT;
            }
            case SHORT: {
                return BigintType.BIGINT;
            }
            case INT: {
                return BigintType.BIGINT;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return DoubleType.DOUBLE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
        }
        return null;
    }
}

